/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.validation.specification;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.BpmnDiagram;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.validation.BpmnValidationMessages;

public class MessagingEdgeConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        if (ctx.getTarget() instanceof MessagingEdge && (ctx.getFeature() == null || ctx.getFeature().getFeatureID() == 11)) {
            MessagingEdge edge = (MessagingEdge)ctx.getTarget();
            Activity source = edge.getSource();
            Activity target = edge.getTarget();
            if (source == null || target == null) {
                return ctx.createSuccessStatus();
            }
            switch (source.getActivityType().getValue()) {
                case 3: 
                case 9: {
                    FeatureMap.Entry fentry = (FeatureMap.Entry)source.getOrderedMessages().get(0);
                    MessagingEdge firstMsgOfSource = (MessagingEdge)fentry.getValue();
                    if (fentry.getEStructuralFeature().getFeatureID() == 10 && firstMsgOfSource.getSource() == edge.getTarget()) break;
                    return ctx.createFailureStatus(new Object[]{BpmnValidationMessages.MessagingEdgeConstraint_intermediateEventShouldNotHaveIncomingMessages});
                }
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    return ctx.createFailureStatus(new Object[]{BpmnValidationMessages.MessagingEdgeConstraint_IntermediateEventMustNotSendMessages});
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return ctx.createFailureStatus(new Object[]{BpmnValidationMessages.MessagingEdgeConstraint_StartEventMustNotSendMessage});
                }
            }
            switch (target.getActivityType().getValue()) {
                case 18: {
                    if (((FeatureMap.Entry)source.getOrderedMessages().get(0)).getEStructuralFeature().getFeatureID() != 11) {
                        return ctx.createFailureStatus(new Object[]{BpmnValidationMessages.MessagingEdgeConstraint_EndEventMustNotReceiveAMessage});
                    }
                }
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    return ctx.createFailureStatus(new Object[]{BpmnValidationMessages.MessagingEdgeConstraint_EndEventMustNotReceiveMessage});
                }
            }
            Pool src = this.getPool((EObject)source);
            Pool tgt = this.getPool((EObject)target);
            if (src != null && src.equals(tgt)) {
                return ctx.createFailureStatus(new Object[]{BpmnValidationMessages.MessagingEdgeConstraint_MessageBetweenSamePoolElements});
            }
        }
        return ctx.createSuccessStatus();
    }

    private Pool getPool(EObject elt) {
        if (elt instanceof BpmnDiagram || elt.eResource() == null) {
            return null;
        }
        if (elt instanceof Pool) {
            return (Pool)elt;
        }
        return this.getPool(elt.eContainer());
    }
}

