/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.infrastructure.emf;

import java.util.Collections;
import java.util.List;

public class EditModelEvent {
    public static final int SAVE = 1;
    public static final int DIRTY = 2;
    public static final int REVERT = 10;
    public static final int REMOVED_RESOURCE = 3;
    public static final int ADDED_RESOURCE = 4;
    public static final int PRE_DISPOSE = 5;
    public static final int LOADED_RESOURCE = 6;
    public static final int UNLOADED_RESOURCE = 7;
    public static final int KNOWN_RESOURCES_ABOUT_TO_CHANGE = 8;
    public static final int KNOWN_RESOURCES_CHANGED = 9;
    private final int eventCode;
    private final List changedResources;

    public EditModelEvent(int anEventCode) {
        this.eventCode = anEventCode;
        this.changedResources = Collections.EMPTY_LIST;
    }

    public EditModelEvent(int anEventCode, List theChangedResources) {
        this.eventCode = anEventCode;
        this.changedResources = Collections.unmodifiableList(theChangedResources);
    }

    public List getChangedResources() {
        return this.changedResources;
    }

    public int getEventCode() {
        return this.eventCode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("EditModelEvent[type =");
        switch (this.getEventCode()) {
            case 1: {
                buffer.append("save");
                break;
            }
            case 2: {
                buffer.append("dirty");
                break;
            }
            case 10: {
                buffer.append("revert");
                break;
            }
            case 3: {
                buffer.append("removed resource");
                break;
            }
            case 4: {
                buffer.append("added resource");
                break;
            }
            case 5: {
                buffer.append("pre-dispose");
                break;
            }
            case 6: {
                buffer.append("loaded resource");
                break;
            }
            case 7: {
                buffer.append("unloaded resource");
            }
        }
        return buffer.append("]").toString();
    }
}

