/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.infrastructure.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.stp.core.infrastructure.emf.EditModelException;
import org.eclipse.stp.core.infrastructure.emf.IEditModelFactory;
import org.eclipse.stp.core.infrastructure.emf.IEditModelScribbler;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public abstract class AbstractScribblerOperation
extends AbstractDataModelOperation {
    private IProgressMonitor progressMonitor;
    private IEditModelScribbler scribbler = null;
    private boolean isArtifactEditModelSelfManaged = false;

    public AbstractScribblerOperation() {
    }

    public AbstractScribblerOperation(IDataModel model) {
        super(model);
    }

    protected abstract IStatus doExecute(IProgressMonitor var1) throws ExecutionException;

    protected abstract IStatus doRedo(IProgressMonitor var1) throws ExecutionException;

    protected abstract IStatus doUndo(IProgressMonitor var1) throws ExecutionException;

    public final IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.setProgressMonitor(monitor);
        if (info != null) {
            this.scribbler = (IEditModelScribbler)info.getAdapter(IEditModelScribbler.class);
        }
        if (this.scribbler == null) {
            this.scribbler = this.createEditModelScribbler();
        }
        try {
            IStatus status = this.doExecute(monitor);
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            try {
                if (this.scribbler != null) {
                    this.scribbler.save(false, monitor);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            if (this.isArtifactEditModelSelfManaged && this.scribbler != null) {
                try {
                    this.scribbler.close(monitor);
                }
                catch (EditModelException e) {
                    e.printStackTrace();
                }
            }
        }
        return Status.OK_STATUS;
    }

    public final IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.doRedo(monitor);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.doUndo(monitor);
    }

    protected void setProgressMonitor(IProgressMonitor newProgressMonitor) {
        this.progressMonitor = newProgressMonitor;
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    protected IEditModelScribbler createEditModelScribbler() {
        IEditModelScribbler aScribbler = null;
        if (this.model.isPropertySet("IAbstractScribblerDataModelProperties.EDIT_MODEL_LABEL") && this.model.isPropertySet("IAbstractScribblerDataModelProperties.SCRIBBLER_DOMAINS") && this.model.isPropertySet("IAbstractScribblerDataModelProperties.PROJECT_NAME")) {
            String editModelLabel = this.model.getStringProperty("IAbstractScribblerDataModelProperties.EDIT_MODEL_LABEL");
            IScribblerDomain[] domains = (IScribblerDomain[])this.model.getProperty("IAbstractScribblerDataModelProperties.SCRIBBLER_DOMAINS");
            try {
                aScribbler = IEditModelFactory.eINSTANCE.createScribblerForWrite(this.getProject(), editModelLabel, domains);
                this.isArtifactEditModelSelfManaged = true;
            }
            catch (EditModelException e) {
                e.printStackTrace();
            }
        }
        return aScribbler;
    }

    protected IProject getProject() {
        String pName = this.model.getStringProperty("IAbstractScribblerDataModelProperties.PROJECT_NAME");
        if (pName != null && pName.length() > 0) {
            return ProjectUtilities.getProject((String)pName);
        }
        return null;
    }

    protected IEditModelScribbler getEditModelScribbler() {
        if (this.scribbler == null) {
            this.scribbler = this.createEditModelScribbler();
        }
        return this.scribbler;
    }
}

