/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.infrastructure.emf;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.core.infrastructure.emf.IEditModelErrorHandler;
import org.eclipse.stp.core.internal.infrastructure.emf.EMFInfrastructurePlugin;
import org.eclipse.stp.core.internal.infrastructure.emf.Messages;

public class LoggerErrorHandler
implements IEditModelErrorHandler {
    public static final LoggerErrorHandler INSTANCE = new LoggerErrorHandler();
    private static final URI UNKNOWN_URI = URI.createURI((String)"Unknown Path");

    private LoggerErrorHandler() {
    }

    public void handleLoadFailed(URI anAttemptedURI, Exception e) {
        EMFInfrastructurePlugin.log((IStatus)new Status(4, EMFInfrastructurePlugin.PLUGIN_ID, 0, NLS.bind((String)Messages.Could_not_load_resource, (Object)anAttemptedURI), (Throwable)e));
    }

    public void handleLoadFailed(Resource resource, Exception e) {
        URI uri = resource != null ? resource.getURI() : UNKNOWN_URI;
        EMFInfrastructurePlugin.log((IStatus)new Status(4, EMFInfrastructurePlugin.PLUGIN_ID, 0, NLS.bind((String)Messages.Could_not_load_resource, (Object)uri), (Throwable)e));
    }

    public void handleSaveFailed(Resource resource, Exception e) {
        URI uri = resource != null ? resource.getURI() : UNKNOWN_URI;
        EMFInfrastructurePlugin.log((IStatus)new Status(4, EMFInfrastructurePlugin.PLUGIN_ID, 0, NLS.bind((String)Messages.Could_not_save_resource, (Object)uri), (Throwable)e));
    }

    public void handleRevertFailed(Resource resource, Exception e) {
        URI uri = resource != null ? resource.getURI() : UNKNOWN_URI;
        EMFInfrastructurePlugin.log((IStatus)new Status(4, EMFInfrastructurePlugin.PLUGIN_ID, 0, NLS.bind((String)Messages.Could_not_revert_resource, (Object)uri), (Throwable)e));
    }

    public void handleGeneralFailure(Object target, Exception e) {
        EMFInfrastructurePlugin.log((IStatus)new Status(4, EMFInfrastructurePlugin.PLUGIN_ID, 0, NLS.bind((String)Messages.Problem_with_resource, (Object)target), (Throwable)e));
    }
}

