/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.infrastructure.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stp.core.infrastructure.emf.DefaultScribblerDomain;
import org.eclipse.stp.core.infrastructure.emf.EclipseResourceDescriptor;
import org.eclipse.stp.core.infrastructure.emf.IResourceDescriptor;
import org.eclipse.stp.core.infrastructure.emf.IScribblerDomain;

public class TestDomain
extends DefaultScribblerDomain
implements IScribblerDomain {
    private static final IPath defaultLocation = new Path("META-INF/ejb-jar.xml");
    private IContainer container;
    private IResourceDescriptor[] descriptors;
    private URI testURI;
    private IResourceDescriptor testDescriptor;

    public static TestDomain createTestDomain(IProject aProject) {
        return new TestDomain((IContainer)aProject.getFolder("ejbModule"));
    }

    public TestDomain(IContainer aContainer) {
        this.container = aContainer;
        this.testURI = URI.createPlatformResourceURI((String)this.container.getFullPath().append(defaultLocation).toString());
        this.testDescriptor = new EclipseResourceDescriptor(defaultLocation, this.container.getFile(defaultLocation).getFullPath());
        this.descriptors = new IResourceDescriptor[]{this.testDescriptor};
    }

    public IResourceDescriptor[] getResourceDescriptors() {
        return this.descriptors;
    }

    public String getLabel() {
        return "EJB Deployment Descriptor Domain";
    }

    public URI getTestURI() {
        return this.testURI;
    }

    public IPath getTestPath() {
        return this.container.getFullPath().append(defaultLocation);
    }

    public String getEditModelLabel() {
        return String.valueOf(this.container.getProject().getName()) + ".test.ejb.editmodel";
    }

    public IResourceDescriptor getTestDescriptor() {
        return this.testDescriptor;
    }
}

