/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.model;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.JavaInterface;
import org.eclipse.stp.core.sca.Module;
import org.eclipse.stp.core.sca.SCACoreRoot;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SLSBBinding;
import org.eclipse.stp.core.sca.WebServiceBinding;
import org.eclipse.stp.core.tests.util.AssertionSAXHandler;
import org.eclipse.stp.core.tests.util.XMLAssertions;

public class BindingTests
extends TestCase {
    private static final String PROJECT_NAME = "BindingTests";
    private IProject project;

    protected void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        this.project.create((IProgressMonitor)new NullProgressMonitor());
        this.project.open((IProgressMonitor)new NullProgressMonitor());
    }

    protected void tearDown() throws Exception {
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public void testEntryPointBindings() throws Exception {
        URI uri = URI.createPlatformResourceURI((String)"BindingTests/sca.module");
        Resource res = WorkbenchResourceHelperBase.createResource((URI)uri);
        SCAFactory fact = SCAFactory.eINSTANCE;
        SCACoreRoot root = fact.createSCACoreRoot();
        res.getContents().add((Object)((EObject)root));
        Module module = fact.createModule();
        module.setName("TestModule");
        root.setModule(module);
        EntryPoint point = SCAFactory.eINSTANCE.createEntryPoint();
        JavaInterface jInterface = SCAFactory.eINSTANCE.createJavaInterface();
        jInterface.setInterface("org.acme.IJavaInterface");
        point.setInterface((Interface)jInterface);
        SLSBBinding ejbbinding = SCAFactory.eINSTANCE.createSLSBBinding();
        ejbbinding.setUri("SessionBean");
        WebServiceBinding wsbinding = SCAFactory.eINSTANCE.createWebServiceBinding();
        wsbinding.setUri("Webservice1");
        point.getBindings().add(ejbbinding);
        point.getBindings().add(wsbinding);
        BindingTests.assertTrue((String)"There should be some bindings.", (point.getBindings().size() == 2 ? 1 : 0) != 0);
        module.getEntryPoints().add(point);
        res.save(null);
        res.unload();
        XMLAssertions xmlAssert = AssertionSAXHandler.parseFile(res, true);
        xmlAssert.assertNoXSITypeAttributes();
    }

    public void testExternalServiceBindings() throws Exception {
        URI uri = URI.createPlatformResourceURI((String)"BindingTests/sca.module");
        Resource res = WorkbenchResourceHelperBase.createResource((URI)uri);
        SCAFactory fact = SCAFactory.eINSTANCE;
        SCACoreRoot root = fact.createSCACoreRoot();
        res.getContents().add((Object)((EObject)root));
        Module module = fact.createModule();
        module.setName("TestModule");
        root.setModule(module);
        ExternalService extService = SCAFactory.eINSTANCE.createExternalService();
        SLSBBinding ejbbinding = SCAFactory.eINSTANCE.createSLSBBinding();
        ejbbinding.setUri("SessionBean");
        WebServiceBinding wsbinding = SCAFactory.eINSTANCE.createWebServiceBinding();
        wsbinding.setUri("Webservice1");
        extService.getBindings().add(ejbbinding);
        extService.getBindings().add(wsbinding);
        BindingTests.assertTrue((String)"There should be some bindings.", (extService.getBindings().size() == 2 ? 1 : 0) != 0);
        module.getExternalServices().add(extService);
        res.save(null);
        res.unload();
        XMLAssertions xmlAssert = AssertionSAXHandler.parseFile(res, true);
        xmlAssert.assertNoXSITypeAttributes();
    }
}

