/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.tests.saf;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.stp.core.saf.Context;
import org.eclipse.stp.core.saf.ISAFManager;
import org.eclipse.stp.core.saf.exception.SAFException;
import org.eclipse.stp.core.saf.handler.IComponentHandler;
import org.eclipse.stp.core.saf.handler.IHandler;
import org.eclipse.stp.core.saf.handler.IInterfaceHandler;
import org.eclipse.stp.core.sca.Component;
import org.eclipse.stp.core.sca.EntryPoint;
import org.eclipse.stp.core.sca.ExternalService;
import org.eclipse.stp.core.sca.Interface;
import org.eclipse.stp.core.sca.SCAFactory;
import org.eclipse.stp.core.sca.SCAObject;

public class ComponentFrameworkBaseTests
extends TestCase {
    private IProject testProject = null;
    private IFile implFile = null;

    public ComponentFrameworkBaseTests(String name) {
        super(name);
    }

    private void printTestHeader(String msg) {
        System.out.println("");
        System.out.println("---------------------------------- Test Begins -------------------------------------------");
        System.out.println("==========================================================================================");
        System.out.println("Test: " + msg);
        System.out.println("==========================================================================================");
    }

    private void printPassed(String msg) {
        String text = "";
        if (msg != null && !msg.equals("")) {
            text = " (" + msg + ")";
        }
        System.out.println(">>>> Passed." + text);
        System.out.println("------------------------------------ Test Ends --------------------------------------------");
    }

    protected void createDummyImplFile() {
        String buf = "This is dummy impl file file";
        ByteArrayInputStream stream = new ByteArrayInputStream(buf.getBytes());
        try {
            this.implFile.create((InputStream)stream, true, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void createProjectModule(IProject project) {
        IFile moduleFile = project.getFile((IPath)new Path("sca.composite"));
        try {
            String buf = "";
            ByteArrayInputStream in = new ByteArrayInputStream(buf.getBytes());
            moduleFile.create((InputStream)in, true, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Component createComponent(String componentKind, String componentName) {
        Component component = null;
        ISAFManager manager = ISAFManager.INSTANCE;
        try {
            IComponentHandler handler = null;
            IComponentHandler[] handlers = manager.getAllComponentHandlers(null);
            int i = 0;
            while (i < handlers.length) {
                if (handlers[i].getKind().equals(componentKind)) {
                    handler = handlers[i];
                    break;
                }
                ++i;
            }
            if (handler != null) {
                component = handler.createComponent();
                component.setName(componentName);
            }
        }
        catch (Throwable e) {
            System.out.println(e);
        }
        return component;
    }

    protected Component createModuleAndComponent(String componentKind, String componentName, IProject project) {
        this.createProjectModule(project);
        Component component = this.createComponent(componentKind, componentName);
        return component;
    }

    protected ExternalService createExternalServiceWithoutBinding() {
        return SCAFactory.eINSTANCE.createExternalService();
    }

    protected ExternalService createExternalService() {
        ExternalService newExternalService = this.createExternalServiceWithoutBinding();
        String externalServiceName = "newExternalService";
        newExternalService.setName(externalServiceName);
        return newExternalService;
    }

    protected EntryPoint createEntryPointWithoutBinding() {
        return SCAFactory.eINSTANCE.createEntryPoint();
    }

    protected EntryPoint createDefaultEntryPoint() {
        EntryPoint newEntryPoint = this.createEntryPointWithoutBinding();
        return newEntryPoint;
    }

    protected void setUp() throws Exception {
        try {
            this.testProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getName());
            this.testProject.create((IProgressMonitor)new NullProgressMonitor());
            this.testProject.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.testProject == null) {
            throw new Exception("Fail to create Project " + this.getName());
        }
    }

    protected void tearDown() {
        this.testProject = null;
        this.implFile = null;
    }

    public void testGetComponentHandlersForNullObject() {
        this.printTestHeader("getComponentHandlersFor with null object");
        ISAFManager manager = ISAFManager.INSTANCE;
        IHandler[] handlers = null;
        Throwable exception = null;
        try {
            handlers = manager.getComponentHandlersFor(null, null);
        }
        catch (Throwable e) {
            exception = e;
            e.printStackTrace();
        }
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! Expecting an empty handler array to be returned.", (handlers != null && handlers.length == 0 ? 1 : 0) != 0);
        ComponentFrameworkBaseTests.assertFalse((String)"%%!! SAFException unexpected.", (boolean)(exception instanceof SAFException));
        this.printPassed("Nothing returned.");
    }

    public void testGetComponentHandlersForNonExistImplFile() {
        this.printTestHeader("getComponentHandlersFor with non-exist implFile");
        ISAFManager manager = ISAFManager.INSTANCE;
        IHandler[] handlers = null;
        Throwable exception = null;
        try {
            handlers = manager.getComponentHandlersFor(null, (Object)this.implFile);
        }
        catch (Throwable e) {
            exception = e;
            e.printStackTrace();
        }
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! Expecting an empty handler array to be returned.", (handlers != null && handlers.length == 0 ? 1 : 0) != 0);
        ComponentFrameworkBaseTests.assertFalse((String)"%%!! SAFException unexpected.", (boolean)(exception instanceof SAFException));
        this.printPassed("SAFException thrown.");
    }

    public void testGetHandlerForComponentWithNullArg() {
        this.printTestHeader("getHandlerFor with null component");
        ISAFManager manager = ISAFManager.INSTANCE;
        IComponentHandler handler = null;
        Exception exception = null;
        try {
            handler = manager.getHandlerFor(null);
        }
        catch (Exception e) {
            exception = e;
            e.printStackTrace();
        }
        System.out.println("%% Descriptor should be null: " + handler);
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! Descriptor should be null.", (handler == null ? 1 : 0) != 0);
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! No exception should be thrown.", (exception == null ? 1 : 0) != 0);
        this.printPassed("Descriptor is null.");
    }

    public void testGetHandlerForComponentWithoutImplmentation() {
        this.printTestHeader("getHandlerFor with component without implementation");
        ISAFManager manager = ISAFManager.INSTANCE;
        SCAFactory scdlFactory = SCAFactory.eINSTANCE;
        Component component = scdlFactory.createComponent();
        IComponentHandler handler = null;
        Exception exception = null;
        try {
            handler = manager.getHandlerFor(component);
        }
        catch (Exception e) {
            exception = e;
            e.printStackTrace();
        }
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! Handler should be null.", (handler == null ? 1 : 0) != 0);
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! No exception should be thrown.", (exception == null ? 1 : 0) != 0);
        this.printPassed("Handler null.");
    }

    public void testGetHandlersForExternalServiceWithNullArg() {
        this.printTestHeader("getHandlersFor with null externalService");
        ISAFManager manager = ISAFManager.INSTANCE;
        IHandler[] handlers = null;
        Exception exception = null;
        try {
            handlers = manager.getHandlersFor(null);
        }
        catch (Exception e) {
            exception = e;
            e.printStackTrace();
        }
        System.out.println("%% Handlers should be null: " + handlers);
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! Handlers should be null.", (handlers == null ? 1 : 0) != 0);
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! No exception should be thrown.", (exception == null ? 1 : 0) != 0);
        this.printPassed("Handlers is null.");
    }

    public void testGetHandlersForExternalServiceWithoutBinding() {
        this.printTestHeader("getHandlersFor with externalService without binding");
        ISAFManager manager = ISAFManager.INSTANCE;
        ExternalService theExternalService = this.createExternalServiceWithoutBinding();
        IHandler[] handlers = null;
        Exception exception = null;
        try {
            handlers = manager.getHandlersFor(theExternalService);
        }
        catch (Exception e) {
            exception = e;
            e.printStackTrace();
        }
        ComponentFrameworkBaseTests.assertFalse((String)"%%!! Handlers should not be null.", (handlers == null ? 1 : 0) != 0);
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! Handlers should be empty.", (handlers.length == 0 ? 1 : 0) != 0);
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! No exception should be thrown.", (exception == null ? 1 : 0) != 0);
        this.printPassed("Handlers is empty.");
    }

    public void testGetExternalServiceHandlersForNullObject() {
        this.printTestHeader("getExternalServiceHandlersFor with null object");
        ISAFManager manager = ISAFManager.INSTANCE;
        IHandler[] handlers = null;
        Throwable exception = null;
        try {
            handlers = manager.getExternalServiceHandlersFor(null, null);
        }
        catch (Throwable e) {
            exception = e;
            e.printStackTrace();
        }
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! Expecting an empty handler array to be returned.", (handlers != null && handlers.length == 0 ? 1 : 0) != 0);
        ComponentFrameworkBaseTests.assertFalse((String)"%%!! SAFException unexpected.", (boolean)(exception instanceof SAFException));
        this.printPassed("Nothing returned.");
    }

    public void testGetExternalServiceHandlersForInvalidObject() {
        this.printTestHeader("getExternalServiceHandlersFor with invalid object");
        ISAFManager manager = ISAFManager.INSTANCE;
        IHandler[] handlers = null;
        Throwable exception = null;
        try {
            handlers = manager.getExternalServiceHandlersFor(null, new Object());
        }
        catch (Throwable e) {
            exception = e;
            e.printStackTrace();
        }
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! Expecting an empty handler array to be returned.", (handlers != null && handlers.length == 0 ? 1 : 0) != 0);
        ComponentFrameworkBaseTests.assertFalse((String)"%%!! SAFException unexpected.", (boolean)(exception instanceof SAFException));
        this.printPassed("SAFException thrown.");
    }

    public void testGetHandlersForEntryPointWithNullArg() {
        this.printTestHeader("getHandlersFor null entry point");
        ISAFManager manager = ISAFManager.INSTANCE;
        IHandler[] handlers = null;
        Exception exception = null;
        try {
            handlers = manager.getHandlersFor(null);
        }
        catch (Exception e) {
            exception = e;
            e.printStackTrace();
        }
        System.out.println("%% Handlers should be null: " + handlers);
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! Handlers should be null.", (handlers == null ? 1 : 0) != 0);
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! No exception should be thrown.", (exception == null ? 1 : 0) != 0);
        this.printPassed("Handlers is null.");
    }

    public void testGetHandlersForEntryPointWithoutBinding() {
        this.printTestHeader("getHandlersFor for entry point without binding");
        ISAFManager manager = ISAFManager.INSTANCE;
        EntryPoint theEntryPoint = this.createEntryPointWithoutBinding();
        IHandler[] handlers = null;
        Exception exception = null;
        try {
            handlers = manager.getHandlersFor(theEntryPoint);
        }
        catch (Exception e) {
            exception = e;
            e.printStackTrace();
        }
        ComponentFrameworkBaseTests.assertFalse((String)"%%!! Handlers should not be null.", (handlers == null ? 1 : 0) != 0);
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! Handlers should be empty.", (handlers.length == 0 ? 1 : 0) != 0);
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! No exception should be thrown.", (exception == null ? 1 : 0) != 0);
        this.printPassed("Handlers is empty.");
    }

    public void testGetEntryPointHandlersForNullObject() {
        this.printTestHeader("getEntryPointHandlersFor with null object");
        ISAFManager manager = ISAFManager.INSTANCE;
        IHandler[] handlers = null;
        Throwable exception = null;
        try {
            handlers = manager.getEntryPointHandlersFor(null, null);
        }
        catch (Throwable e) {
            exception = e;
            e.printStackTrace();
        }
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! Expecting an empty handler array to be returned.", (handlers != null && handlers.length == 0 ? 1 : 0) != 0);
        ComponentFrameworkBaseTests.assertFalse((String)"%%!! SAFException unexpected.", (boolean)(exception instanceof SAFException));
        this.printPassed("Nothing returned.");
    }

    public void testGetEntryPointHandlersForInvalidObject() {
        this.printTestHeader("getEntryPointHandlersFor with invalid object");
        ISAFManager manager = ISAFManager.INSTANCE;
        IHandler[] handlers = null;
        Throwable exception = null;
        try {
            handlers = manager.getEntryPointHandlersFor(null, new Object());
        }
        catch (Throwable e) {
            exception = e;
            e.printStackTrace();
        }
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! Expecting an empty handler array to be returned.", (handlers != null && handlers.length == 0 ? 1 : 0) != 0);
        ComponentFrameworkBaseTests.assertFalse((String)"%%!! SAFException unexpected.", (boolean)(exception instanceof SAFException));
        this.printPassed("Empty List.");
    }

    public void testGetHandlersForInterfaceWithNullArg() {
        this.printTestHeader("getHandlerFor with null interface");
        ISAFManager manager = ISAFManager.INSTANCE;
        IInterfaceHandler handler = null;
        Exception exception = null;
        try {
            handler = manager.getHandlerFor(null);
        }
        catch (Exception e) {
            exception = e;
            e.printStackTrace();
        }
        System.out.println("%% Handler should be null: " + handler);
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! Handler should be null.", (handler == null ? 1 : 0) != 0);
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! No exception should be thrown.", (exception == null ? 1 : 0) != 0);
        this.printPassed("Handler is null.");
    }

    public void testGetHandlersForInterfaceWithoutImplementation() {
        this.printTestHeader("getHandlerFor with interface without implemntation");
        ISAFManager manager = ISAFManager.INSTANCE;
        SCAFactory scdlFactory = SCAFactory.eINSTANCE;
        Interface interfaze = scdlFactory.createInterface();
        IInterfaceHandler handler = null;
        Exception exception = null;
        try {
            handler = manager.getHandlerFor(interfaze);
        }
        catch (Exception e) {
            exception = e;
            e.printStackTrace();
        }
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! Handler should be null.", (handler == null ? 1 : 0) != 0);
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! No exception should be thrown.", (exception == null ? 1 : 0) != 0);
        this.printPassed("Handler is null.");
    }

    public void testGetInterfaceHandlersForNullObject() {
        this.printTestHeader("getInterfaceHandlersFor with null object");
        ISAFManager manager = ISAFManager.INSTANCE;
        IHandler[] handlers = null;
        Throwable exception = null;
        try {
            handlers = manager.getInterfaceHandlersFor(null);
        }
        catch (Throwable e) {
            exception = e;
            e.printStackTrace();
        }
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! Expecting an empty handler array to be returned.", (handlers != null && handlers.length == 0 ? 1 : 0) != 0);
        ComponentFrameworkBaseTests.assertFalse((String)"%%!! SAFException unexpected.", (boolean)(exception instanceof SAFException));
        this.printPassed("Nothing returned.");
    }

    public void testGetInterfaceHandlersForInvalidObject() {
        this.printTestHeader("getInterfaceHandlersFor with invalid object");
        ISAFManager manager = ISAFManager.INSTANCE;
        IHandler[] handlers = null;
        Throwable exception = null;
        try {
            handlers = manager.getInterfaceHandlersFor(new Object());
        }
        catch (Throwable e) {
            exception = e;
            e.printStackTrace();
        }
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! Expecting an empty handler array to be returned.", (handlers != null && handlers.length == 0 ? 1 : 0) != 0);
        ComponentFrameworkBaseTests.assertFalse((String)"%%!! SAFException unexpected.", (boolean)(exception instanceof SAFException));
        this.printPassed("Empty List.");
    }

    public void testGetAllComponentHandlers() {
        this.printTestHeader("getAllComponentHandlers");
        String type = "comp";
        this.testContext(type, null, true, true, true, true, true);
        Context context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test1");
        this.testContext(type, context, true, true, false, false, false);
        context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test2");
        this.testContext(type, context, false, false, true, true, true);
        context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test3");
        this.testContext(type, context, true, true, false, false, false);
        context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test4");
        this.testContext(type, context, false, false, true, true, true);
        context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test5");
        this.testContext(type, context, true, true, false, false, false);
        context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test6");
        this.testContext(type, context, false, false, true, true, true);
        context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test7");
        this.testContext(type, context, true, true, true, true, false);
        context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test8");
        this.testContext(type, context, false, false, false, false, true);
        this.printPassed("All context processed successfully");
    }

    public void testGetAllExternalServiceHandlers() {
        this.printTestHeader("getAllExternalServiceHandlers");
        String type = "es";
        this.testContext(type, null, true, true, true, true, true);
        Context context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test1");
        this.testContext(type, context, true, true, false, false, false);
        context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test2");
        this.testContext(type, context, false, false, true, true, true);
        context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test3");
        this.testContext(type, context, true, true, true, true, true);
        context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test4");
        this.testContext(type, context, true, true, true, true, true);
        context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test5");
        this.testContext(type, context, true, true, false, false, false);
        context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test6");
        this.testContext(type, context, false, false, true, true, true);
        context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test7");
        this.testContext(type, context, true, true, true, true, false);
        context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test8");
        this.testContext(type, context, false, false, false, false, true);
        this.printPassed("All context processed successfully");
    }

    public void testGetAllEntryPointHandlers() {
        this.printTestHeader("getAllEntryPointHandlers");
        String type = "ep";
        this.testContext(type, null, true, true, true, true, true);
        Context context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test1");
        this.testContext(type, context, true, true, false, false, false);
        context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test2");
        this.testContext(type, context, false, false, true, true, true);
        context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test3");
        this.testContext(type, context, true, true, true, true, true);
        context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test4");
        this.testContext(type, context, true, true, true, true, true);
        context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test5");
        this.testContext(type, context, true, true, false, false, false);
        context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test6");
        this.testContext(type, context, false, false, true, true, true);
        context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test7");
        this.testContext(type, context, true, true, true, true, false);
        context = new Context((SCAObject)SCAFactory.eINSTANCE.createModule(), "test8");
        this.testContext(type, context, false, false, false, false, true);
        this.printPassed("All context processed successfully");
    }

    private void testContext(String type, Context context, boolean r1, boolean r2, boolean r3, boolean r4, boolean r5) {
        String c1Kind = "c1";
        String c2Kind = "c2";
        String c3Kind = "c3";
        String c4Kind = "i4";
        String c5Kind = "i5";
        if (type.equals("ep")) {
            c1Kind = "ep1";
            c2Kind = "ep2";
            c3Kind = "ep3";
            c4Kind = "entrypoint4";
            c5Kind = "entrypoint5";
        } else if (type.equals("es")) {
            c1Kind = "es1";
            c2Kind = "es2";
            c3Kind = "es3";
            c4Kind = "externalservice4";
            c5Kind = "externalservice5";
        }
        ISAFManager manager = ISAFManager.INSTANCE;
        boolean c1 = false;
        boolean c2 = false;
        boolean c3 = false;
        boolean c4 = false;
        boolean c5 = false;
        IHandler[] handlers = null;
        Throwable exception = null;
        try {
            if (type.equals("comp")) {
                handlers = manager.getAllComponentHandlers(context);
            } else if (type.equals("ep")) {
                handlers = manager.getAllEntryPointHandlers(context);
            } else if (type.equals("es")) {
                handlers = manager.getAllExternalServiceHandlers(context);
            }
        }
        catch (Throwable e) {
            exception = e;
            e.printStackTrace();
        }
        ComponentFrameworkBaseTests.assertFalse((String)"%%!! SAFException unexpected.", (boolean)(exception instanceof SAFException));
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! Expecting an non-empty handler array to be returned.", (handlers != null && handlers.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < handlers.length) {
            IHandler handler = handlers[i];
            if (handler.getKind().equals(c1Kind)) {
                c1 = true;
            }
            if (handler.getKind().equals(c2Kind)) {
                c2 = true;
            }
            if (handler.getKind().equals(c3Kind)) {
                c3 = true;
            }
            if (handler.getKind().equals(c4Kind)) {
                c4 = true;
            }
            if (handler.getKind().equals(c5Kind)) {
                c5 = true;
            }
            ++i;
        }
        ComponentFrameworkBaseTests.assertTrue((String)"%%!! Not all expected handlers were returned.", (!(c1 ^ r1) && !(c2 ^ r2) && !(c3 ^ r3) && !(c4 ^ r4) && !(c5 ^ r5) ? 1 : 0) != 0);
    }
}

