/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.internal.introspection;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.internal.introspection.AttributeSet;
import org.eclipse.stp.core.internal.introspection.AttributeSetStack;
import org.eclipse.stp.core.internal.introspection.ModelDeltaStack;
import org.eclipse.stp.core.internal.introspection.query.AttributesExpression;
import org.eclipse.stp.core.internal.introspection.query.CombinedQuery;
import org.eclipse.stp.core.internal.introspection.query.IModelQuery;
import org.eclipse.stp.core.internal.introspection.query.StructuralFeatureExpression;
import org.eclipse.stp.core.introspection.IDynamicModelIntrospector;
import org.eclipse.stp.core.sca.SCAObject;

public class IntrospectionRecorder
implements IDynamicModelIntrospector {
    private final AttributeSetStack attributeSetStack = new AttributeSetStack();
    private final ModelDeltaStack deltaStack = new ModelDeltaStack();
    private SCAObject rootObject;

    public void startIntrospection(EStructuralFeature theRootFeature, SCAObject theRootObject) {
        this.reset();
        this.rootObject = theRootObject;
        this.deltaStack.push(new CombinedQuery());
    }

    public void startFeature(EStructuralFeature feature, EClass type, EStructuralFeature substitutionGroupFeature) {
        this.startFeature(feature, type, substitutionGroupFeature, 1);
    }

    public void startFeature(EStructuralFeature feature, EClass type, EStructuralFeature substitutionGroupFeature, int announcementType) {
        this.deltaStack.push(new StructuralFeatureExpression(feature, type, substitutionGroupFeature, announcementType));
        this.attributeSetStack.push(new AttributeSet());
    }

    public void attribute(EAttribute attribute, Object value, boolean isUniqueKey) {
        this.attributeSetStack.peek().add(attribute, value, isUniqueKey);
    }

    public void endFeature(EStructuralFeature feature) {
        AttributeSet attributes = this.attributeSetStack.pop();
        AttributesExpression matchesAttributes = new AttributesExpression(attributes);
        IModelQuery child = this.deltaStack.pop();
        child.addChildQuery(matchesAttributes);
        IModelQuery parent = this.deltaStack.peek();
        parent.addChildQuery(child);
    }

    public void endIntrospection() {
        if (!this.deltaStack.isEmpty() && this.rootObject != null) {
            this.deltaStack.peek().applyDelta(this.rootObject.getEObject());
        }
        Assert.isTrue((boolean)this.attributeSetStack.isEmpty());
    }

    public void removeUntouched(EStructuralFeature feature) {
        if (!this.deltaStack.isEmpty()) {
            this.deltaStack.peek().removeUntouched(this.rootObject, feature);
        }
    }

    public void reset() {
        while (!this.deltaStack.isEmpty()) {
            this.deltaStack.pop();
        }
        this.rootObject = null;
    }
}

