/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.sca.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.stp.core.sca.util.ModelFileIndex;

public class ModelFileIndexer
implements IResourceChangeListener {
    private static final Object lock = new Object();
    public static final String COMPOSITE_EXT = "composite";
    public static final String COMPONENT_TYPE_EXT = "componentType";
    public static final String SUBSYSTEM_EXT = "subsystem";
    public static final String MODULE_EXT = "module";
    private static final Set interestingExtensions = new HashSet();
    private static ModelFileIndexer instance;
    private final Map indices = new HashMap();

    static {
        interestingExtensions.add(COMPOSITE_EXT);
        interestingExtensions.add(COMPONENT_TYPE_EXT);
        interestingExtensions.add(SUBSYSTEM_EXT);
        interestingExtensions.add(MODULE_EXT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelFileIndexer getInstance() {
        if (instance != null) {
            return instance;
        }
        Object object = lock;
        synchronized (object) {
            if (instance == null) {
                instance = new ModelFileIndexer();
            }
        }
        return instance;
    }

    private ModelFileIndexer() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (1 == event.getType()) {
            IResourceDelta[] addedDeltas = event.getDelta().getAffectedChildren(1);
            IResource source = null;
            int i = 0;
            while (i < addedDeltas.length) {
                source = addedDeltas[i].getResource();
                if (1 == source.getType() && interestingExtensions.contains(source.getFileExtension())) {
                    this.getModelIndex(source.getProject()).addModelFile((IFile)source);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelFileIndex getModelIndex(IProject project) {
        ModelFileIndex index = (ModelFileIndex)this.indices.get(project);
        if (index != null) {
            return index;
        }
        ModelFileIndexer modelFileIndexer = this;
        synchronized (modelFileIndexer) {
            index = (ModelFileIndex)this.indices.get(project);
            if (index == null) {
                index = new ModelFileIndex(project);
                this.indices.put(project, index);
            }
        }
        return index;
    }
}

