/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.workspace;

import junit.framework.TestCase;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.stp.sc.common.utils.WorkbenchUtils;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;

public class WorkspaceManagerTest
extends TestCase {
    private static final String PROJECT_NAME = "WorkspaceManagerTestProj";
    private static final String TEST_BUILDER = "org.eclipse.stp.sc.annvalidator";
    IProject project;

    protected void setUp() throws Exception {
        super.setUp();
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        if (!newProject.exists()) {
            this.project = WorkbenchUtils.createProject((String)PROJECT_NAME, null);
        } else {
            this.project.open(null);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.project.delete(true, null);
    }

    public void testAddRemoveBuilder() throws Exception {
        WorkspaceManager.addBuilder((IProject)this.project, (String)TEST_BUILDER, (WorkspaceManager.BuilderOrder)WorkspaceManager.BuilderOrder.FIRST);
        WorkspaceManagerTest.assertTrue((String)"should added the builder", (boolean)this.hasBuilder(this.project, TEST_BUILDER));
        WorkspaceManager.removeBuilder((IProject)this.project, (String)TEST_BUILDER);
        WorkspaceManagerTest.assertFalse((String)"should removed the builder", (boolean)this.hasBuilder(this.project, TEST_BUILDER));
    }

    private boolean hasBuilder(IProject project, String builder) throws Exception {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(TEST_BUILDER)) {
                found = true;
                break;
            }
            ++i;
        }
        return found;
    }
}

