/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.runtime;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.runtime.IExtRuntimeProcessor;

public class ExtRuntimeManager {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(ExtRuntimeManager.class);
    private static final String EXT_POINT_ID = "org.eclipse.stp.sc.common.ExtRuntimeProcessor";
    private static final String EXT_ELEMENT_NAME = "processor";
    private static final String EXT_ELEMENT_ATTR_CLASS = "class";
    private static final String EXT_ELEMENT_ATTR_RUNTIMETYPE = "runtimeTypeID";
    private static ExtRuntimeManager instance;

    private ExtRuntimeManager() {
    }

    public static synchronized ExtRuntimeManager getInstance() {
        if (instance == null) {
            instance = new ExtRuntimeManager();
        }
        return instance;
    }

    public IExtRuntimeProcessor getExtendedRuntimeProcessor(String runtimeTypeID) {
        IExtRuntimeProcessor retValue = null;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtension[] extensions = reg.getExtensionPoint(EXT_POINT_ID).getExtensions();
        if (extensions != null && extensions.length > 0) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] elements = ext.getConfigurationElements();
                if (elements != null && elements.length > 0) {
                    IConfigurationElement[] iConfigurationElementArray = elements;
                    int n3 = elements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        if (element.getName().equals(EXT_ELEMENT_NAME) && element.getAttribute(EXT_ELEMENT_ATTR_RUNTIMETYPE).equals(runtimeTypeID)) {
                            try {
                                Object obj = element.createExecutableExtension(EXT_ELEMENT_ATTR_CLASS);
                                if (obj instanceof IExtRuntimeProcessor) {
                                    retValue = (IExtRuntimeProcessor)obj;
                                    return retValue;
                                }
                            }
                            catch (CoreException ex) {
                                LOG.error((Object)"error while create extended runtime processor", (Throwable)ex);
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return retValue;
    }
}

