/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.cxf.actions;

import java.io.File;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.cxf.TestUtilities;
import org.eclipse.stp.sc.cxf.actions.Java2wsGenerateClientAction;
import org.eclipse.stp.sc.cxf.actions.Java2wsGenerateServerAction;
import org.eclipse.stp.sc.cxf.generators.ToolConstants;
import org.eclipse.stp.sc.jaxws.actions.AssignedJava2WsdlAction;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.workspace.ScJavaFirstNature;
import org.eclipse.stp.sc.jaxws.wsdl.WsdlUtils;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.navigator.IResourceNavigator;

public class Java2wsGenerateActionTest
extends TestCase {
    private static String TEST_PROJECT_NAME = "JAXWS-JavaFirst-TestProject";
    private static String TEMP_PROJECT_NAME = "tempProject";
    private static final String JAVA_RESOURCE = "Hello.java_resource";
    private static final String SRC_FOLDER = "src" + File.separator + "com" + File.separator + "iona";
    private static final String LOCAL_JAVA = String.valueOf(SRC_FOLDER) + File.separator + "Hello.java";
    private static final String WSDL_FILE_PATH = "wsdl" + File.separator + TEST_PROJECT_NAME + ".wsdl";
    private static final String SERVER_FILE_PATH = String.valueOf(SRC_FOLDER) + File.separator + "HelloServer.java";
    private static final String CLIENT_FILE_PATH = String.valueOf(SRC_FOLDER) + File.separator + "HelloClient.java";
    private IProject project;

    protected void setUp() throws Exception {
        this.project = TestUtilities.createTestCeltixProject(TEST_PROJECT_NAME);
        TestUtilities.setupCeltixProject(this.project);
        ScJavaFirstNature.addToProject((IProject)this.project);
        IFolder srcFolder = this.project.getFolder("src/com/iona");
        srcFolder.getLocation().toFile().mkdirs();
        srcFolder.refreshLocal(2, null);
        IFile testFile = TestUtilities.addFileResourceToTestProject(this.project, LOCAL_JAVA, ((Object)((Object)this)).getClass(), "/resources/Hello.java_resource");
        this.project.setPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_STARTING_POINT, testFile.getProjectRelativePath().toOSString());
        this.project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_DATA_BINDING, "jaxb");
        this.project.setPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_SOAP_OPTION, ToolConstants.PROPERTY_VALUE_SOAP11);
        this.project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_WSDL, "true");
        this.project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_SERVER, "true");
        this.project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_CLIENT, "true");
        this.project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_XSD_IMPORT, "false");
        this.project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_VERBOSE, "false");
        IResourceNavigator viewPart = (IResourceNavigator)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.ResourceNavigator");
        viewPart.getViewer().setSelection((ISelection)new StructuredSelection((Object[])new IProject[]{this.project}));
    }

    protected void tearDown() throws Exception {
        IProject proj = WorkspaceManager.getProject((String)TEST_PROJECT_NAME);
        if (proj.exists()) {
            proj.delete(true, null);
        }
        if ((proj = WorkspaceManager.getProject((String)TEMP_PROJECT_NAME)).exists()) {
            proj.delete(true, null);
        }
    }

    public void testGenerateCodeAction() throws Exception {
    }

    public void testGenerateServerAction() throws Exception {
        Java2wsGenerateServerAction action = new Java2wsGenerateServerAction();
        action.run(null);
        IFile serverFile = this.project.getFile(SERVER_FILE_PATH);
        Java2wsGenerateActionTest.assertNotNull((Object)serverFile);
        Java2wsGenerateActionTest.assertTrue((String)"should generate server file", (boolean)serverFile.exists());
    }

    public void testGenerateClientAction() throws Exception {
        Java2wsGenerateClientAction action = new Java2wsGenerateClientAction();
        action.run(null);
        IFile clientFile = this.project.getFile(CLIENT_FILE_PATH);
        Java2wsGenerateActionTest.assertNotNull((Object)clientFile);
        Java2wsGenerateActionTest.assertTrue((String)"should generate client file", (boolean)clientFile.exists());
    }

    public void testGenerateWsdlAction() throws Exception {
        AssignedJava2WsdlAction action = new AssignedJava2WsdlAction();
        action.run(null);
        IFile wsdlFile = this.project.getFile(WSDL_FILE_PATH);
        Java2wsGenerateActionTest.assertNotNull((Object)wsdlFile);
        Java2wsGenerateActionTest.assertTrue((String)"should generate wsdl file", (boolean)wsdlFile.exists());
        Definition wsdlDef = WsdlUtils.readWSDL((String)wsdlFile.getRawLocation().toOSString());
        Service service = (Service)wsdlDef.getServices().values().toArray()[0];
        Port port = service.getPort("HelloPort");
        Java2wsGenerateActionTest.assertNotNull((String)"should create soap port", (Object)port);
    }
}

