/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.cxf.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.ResourceUtils;
import org.eclipse.stp.sc.cxf.generators.CxfJava2wsGenerator;
import org.eclipse.stp.sc.cxf.generators.ToolConstants;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public abstract class Java2wsActionBase
implements IWorkbenchWindowActionDelegate {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(Java2wsActionBase.class);

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            IRunnableWithProgress rwp = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Java2wsActionBase.this.invokeGenerator();
                }
            };
            pmd.run(false, false, rwp);
        }
        catch (Exception e) {
            LOG.error((Object)"error during webservice artifacts generation", (Throwable)e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void invokeGenerator() {
        try {
            IProject project = ResourceUtils.getActiveProject();
            project.build(10, null);
            CxfJava2wsGenerator generator = CxfJava2wsGenerator.getInstance();
            String genServer = project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_SERVER);
            String genClient = project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_CLIENT);
            String genWsdl = project.getPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_WSDL);
            this.setGeneratorParameters(project);
            generator.run(project);
            project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_WSDL, genWsdl);
            project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_SERVER, genServer);
            project.setPersistentProperty(ToolConstants.PROPERTY_KEY_JAVA2WS_PARA_CLIENT, genClient);
            project.build(10, null);
            project.refreshLocal(2, null);
        }
        catch (Exception e) {
            LOG.error((Object)"error during webservice artifacts generation", (Throwable)e);
        }
    }

    public abstract void setGeneratorParameters(IProject var1) throws CoreException;
}

