/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.cxf.launchers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.stp.common.logging.LoggingProxy;

public class JavaLaunchConfig
implements IJavaLaunchConfigurationConstants {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(JavaLaunchConfig.class);
    private String configBaseName = null;
    private String projectName = null;
    private String programArgs = null;
    private String serverMainClassName = null;
    private String clientMainClassName = null;

    public void setClientMainClassName(String clientMainClassNameStr) {
        this.clientMainClassName = clientMainClassNameStr;
    }

    public void setServerMainClassName(String serverMainClassNameStr) {
        this.serverMainClassName = serverMainClassNameStr;
    }

    public void setProjectName(String projectNameStr) {
        this.projectName = projectNameStr;
    }

    public void setProgramArgs(String programArgsStr) {
        this.programArgs = programArgsStr;
    }

    public void setConfigBaseName(String configBaseNameStr) {
        this.configBaseName = configBaseNameStr;
    }

    public void createServerLaunchConfig() {
        if (this.configBaseName != null && this.projectName != null && this.serverMainClassName != null) {
            LOG.debug((Object)("server config configBaseName: " + this.configBaseName));
            LOG.debug((Object)("server config projectName: " + this.projectName));
            LOG.debug((Object)("server config serverMainClassName: " + this.serverMainClassName));
            this.createLaunchConfig(this.serverMainClassName, "server_" + this.projectName);
        }
    }

    public void createClientLaunchConfig() {
        if (this.configBaseName != null && this.projectName != null && this.clientMainClassName != null) {
            LOG.debug((Object)("client config configBaseName: " + this.configBaseName));
            LOG.debug((Object)("client config projectName: " + this.projectName));
            LOG.debug((Object)("client config clientMainClassName: " + this.clientMainClassName));
            this.createLaunchConfig(this.clientMainClassName, "client_" + this.projectName);
        }
    }

    private void createLaunchConfig(String mainClassName, String id) {
        String launchConfigName = String.valueOf(this.configBaseName) + "_" + id;
        LOG.debug((Object)("run/debug config name: " + launchConfigName));
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(ID_JAVA_APPLICATION);
        try {
            ILaunchConfiguration[] configurations = manager.getLaunchConfigurations(type);
            int i = 0;
            while (i < configurations.length) {
                ILaunchConfiguration configuration = configurations[i];
                if (configuration.getName().equals(launchConfigName)) {
                    configuration.delete();
                    break;
                }
                ++i;
            }
            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, launchConfigName);
            workingCopy.setAttribute(ATTR_PROJECT_NAME, this.projectName);
            workingCopy.setAttribute(ATTR_MAIN_TYPE_NAME, mainClassName);
            workingCopy.setAttribute(ATTR_PROGRAM_ARGUMENTS, this.programArgs);
            workingCopy.doSave();
        }
        catch (CoreException coreException) {
            LOG.debug((Object)"Exception thrown trying to create run config");
        }
    }
}

