/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.cxf.natures;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IRuntimeKitProcessor;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;

public class CxfSimpleFrontendNature
implements IProjectNature {
    public static final String NATURE_ID = "org.eclipse.stp.sc.cxf.natures.cxfSimpleFrontendNature";
    private IProject theProject;

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.theProject;
    }

    public void setProject(IProject value) {
        this.theProject = value;
    }

    public static void addToProject(IProject project) throws CoreException {
        if (!project.hasNature(NATURE_ID)) {
            IProjectDescription desc = project.getDescription();
            String[] natures = desc.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 1, natures.length);
            newNatures[0] = NATURE_ID;
            desc.setNatureIds(newNatures);
            project.setDescription(desc, null);
            String runtimeType = RuntimeCore.getRuntimeType((IProject)project);
            String runtimeId = RuntimeCore.getRuntimeID((IProject)project);
            IRuntimeKitProcessor kitProcessor = RuntimeProviderManager.getInstance().getRuntimeKitProcessor(runtimeType, runtimeId);
            if (kitProcessor != null) {
                kitProcessor.completeJavaProjectBuildPath(JavaCore.create((IProject)project));
            }
        }
    }

    public static void removeFromProject(IProject project) throws CoreException {
        if (project.hasNature(NATURE_ID)) {
            IProjectDescription desc = project.getDescription();
            String[] natures = desc.getNatureIds();
            ArrayList newNatures = new ArrayList(Arrays.asList(natures));
            newNatures.remove(newNatures.indexOf(NATURE_ID));
            desc.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
            project.setDescription(desc, null);
            String runtimeType = RuntimeCore.getRuntimeType((IProject)project);
            String runtimeId = RuntimeCore.getRuntimeID((IProject)project);
            IRuntimeKitProcessor kitProcessor = RuntimeProviderManager.getInstance().getRuntimeKitProcessor(runtimeType, runtimeId);
            if (kitProcessor != null) {
                kitProcessor.clearJavaProjectBuildPath(JavaCore.create((IProject)project));
            }
        }
    }

    public static boolean hasNature(IProject aProject) throws CoreException {
        return aProject.hasNature(NATURE_ID);
    }
}

