package org.eclipse.stp.sc.common.runtime;

import java.util.List;

import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.RuntimeUtils;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;

public class RuntimeChangeListener implements IRuntimeLifecycleListener {

	private static final LoggingProxy LOG = LoggingProxy.getlogger(RuntimeChangeListener.class);
	
	public void runtimeAdded(IRuntime runtime) {
		LOG.debug("Runtime " + runtime.getName() + " has been added.");
		updateRuntimeLibrary(runtime);
	}

	public void runtimeChanged(IRuntime runtime) {
		LOG.debug("Runtime " + runtime.getName() + " has been changed.");
		if(RuntimeUtils.getRuntimeLibName(runtime) != null){
			updateRuntimeLibrary(runtime);
		}
		
	}

	public void runtimeRemoved(IRuntime runtime) {
		LOG.debug("Runtime " + runtime.getName() + " has been removed.");
		RuntimeUtils.removeRuntimeLib(runtime);
	}
	
	private void updateRuntimeLibrary(IRuntime runtime){
		IExtRuntimeProcessor processor = ExtRuntimeManager.getInstance().getExtendedRuntimeProcessor(runtime.getRuntimeType().getId());
		if(processor != null){
			List<IClasspathEntry> cpEntries = processor.getRuntimeClasspathEntry(runtime);
			if(cpEntries != null){
				RuntimeUtils.createRuntimeLib(runtime);
			}
		}
	}

}
