/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.xmlvalidator.preferences;

import java.io.File;
import java.net.URL;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.FileUtils;
import org.eclipse.stp.sc.xmlvalidator.XmlValidatorPlugin;
import org.eclipse.stp.sc.xmlvalidator.builder.XmlValidator;
import org.eclipse.stp.sc.xmlvalidator.rule.engine.VRuleManager;

/**
 * Class used to initialize default preference values.
 */
public class PreferenceInitializer extends AbstractPreferenceInitializer {
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(PreferenceInitializer.class);

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer#initializeDefaultPreferences()
	 */
	public void initializeDefaultPreferences() {
		IPreferenceStore store = XmlValidatorPlugin.getDefault()
				.getPreferenceStore();
		store.setDefault(PreferenceConstants.P_RULESET, "JohnsonTestTest");

		String rulePath = XmlValidatorPlugin.getDefault().getStateLocation()
				.makeAbsolute().toOSString();
		importDefaultRules();
		System.setProperty(VRuleManager.DEFAULT_RULE_PATH_PROPERTY, rulePath);

		int ruleCount = VRuleManager.getInstance().loadRules();
		LOG.debug("preference init with rules:" + ruleCount);
		
		//load rule settings from preferences
		VRuleManager.getInstance().loadFromPreference();
	}

	@SuppressWarnings("deprecation")
	public static void importDefaultRules() {

		IExtensionRegistry reg = Platform.getExtensionRegistry();

		IExtension[] extensions = reg.getExtensionPoint(
				XmlValidator.RULESET_EXT_ID).getExtensions();
		for (IExtension ext : extensions) {
			String pluginID = ext.getContributor().getName();
			IConfigurationElement[] extElts = ext.getConfigurationElements();
			for (IConfigurationElement cfg : extElts) {
				String location = cfg
						.getAttribute(XmlValidator.RULESET_EXT_ATTR_LOCATION);
				// get plugin from the contributer name
				Plugin plugin = Platform.getPlugin(pluginID);
				URL url = plugin.getBundle().getEntry(location);
				String workingPath = XmlValidatorPlugin.getDefault()
						.getStateLocation().makeAbsolute().toOSString();
				String targetFile = workingPath + File.separator
						+ FileUtils.getFileName(location);
				LOG.debug("target ruleset file:" + targetFile);
				try {
					FileUtils.copyFile(url.openStream(), targetFile);
				} catch (Exception e) {
					e.printStackTrace();
				}

			}

		}

	}

}
