/*******************************************************************************

 * Copyright (c) 2006 IONA Technologies PLC

 * All rights reserved. This program and the accompanying materials

 * are made available under the terms of the Eclipse Public License v1.0

 * which accompanies this distribution, and is available at

 * http://www.eclipse.org/legal/epl-v10.html

 * 

 * Contributors:

 *     IONA Technologies PLC - initial API and implementation

 *******************************************************************************/

package org.eclipse.stp.sc.xmlvalidator.preferences;

import java.util.Hashtable;
import java.util.List;

import org.eclipse.jface.preference.*;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.xmlvalidator.XmlValidatorPlugin;
import org.eclipse.stp.sc.xmlvalidator.XmlValidatorResources;
import org.eclipse.stp.sc.xmlvalidator.rule.engine.VRuleManager;
import org.eclipse.stp.sc.xmlvalidator.rule.model.VRuleDef;
import org.eclipse.stp.sc.xmlvalidator.rule.model.VRuleSet;
import org.eclipse.stp.sc.xmlvalidator.rule.model.VRuleDef.SEVERITY;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.TableItem;

/**
 * This class represents a preference page that is contributed to the
 * Preferences dialog. We use the eclipse preference to manage validation rules
 * here User can input/remove/configu rules
 */

public class ValidatorPreferencePage extends PreferencePage implements
		IWorkbenchPreferencePage {

	private static final LoggingProxy LOG = LoggingProxy
			.getlogger(ValidatorPreferencePage.class);

	public static final int STANDARD_OFFSET = 20;

	private Group grpRule;

	private Group grpRuleSet;

	RuleSetTable rulesetTable;

	RuleTableEditor ruleTableEditor;

	private static String[] RULESET_TABLE_COLUMNS = {
			XmlValidatorResources.getString("preference.rulesettable.name"),
			XmlValidatorResources.getString("preference.rulesettable.location"),
			XmlValidatorResources.getString("preference.rulesettable.desc") };

	public ValidatorPreferencePage() {
		super();
		setPreferenceStore(XmlValidatorPlugin.getDefault().getPreferenceStore());
		// String value = getPreferenceStore().getString(getPreferenceName());
//		// need the following line to active the PreferenceInitializer
//		getPreferenceStore().getString("ruleSet");

	}

	public Control createContents(Composite parent) {

		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout(1, true));
		createRuleSetPanel(composite);
		createRulePanel(composite);
		return composite;

	}

	private Composite createRulePanel(Composite parent) {

		// FormData formData;
		grpRule = new Group(parent, SWT.SHADOW_NONE);
		grpRule.setText(XmlValidatorResources
				.getString("preference.ruletable.group"));
		grpRule.setLayoutData(new GridData(GridData.FILL_BOTH));

		grpRule.setLayout(new GridLayout(2, false));
		createRuleTable(grpRule);
		createButtonPanel(grpRule);
		return grpRule;
	}

	private Composite createRuleSetPanel(Composite parent) {
		// FormData formData;
		grpRuleSet = new Group(parent, SWT.SHADOW_NONE);
		grpRuleSet.setText(XmlValidatorResources
				.getString("preference.rulesettable.group"));
		grpRuleSet.setLayoutData(new GridData(GridData.FILL_BOTH));
		grpRuleSet.setLayout(new GridLayout(1, false));

		Composite tableComp = createRuleSetTable(grpRuleSet);
		//tableComp.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_FILL
			//	| GridData.GRAB_HORIZONTAL));
		tableComp.setLayoutData(new GridData(GridData.FILL_BOTH));

		return grpRuleSet;

	}

	private Composite createButtonPanel(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridData gridBData = new GridData();
		gridBData.verticalAlignment = SWT.TOP;
		composite.setLayout(new GridLayout(1, false));
		composite.setLayoutData(gridBData);
		Button btnSelectAll = new Button(composite, SWT.PUSH);
		btnSelectAll.setText(XmlValidatorResources
				.getString("preference.ruletable.select.btn"));
		gridBData = new GridData();
		gridBData.horizontalAlignment = GridData.FILL;
		gridBData.grabExcessHorizontalSpace = true;
		btnSelectAll.setLayoutData(gridBData);

		btnSelectAll.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				ruleTableEditor.selectAll();
			}
		});

		Button btnDeselectAll = new Button(composite, SWT.PUSH);
		btnDeselectAll.setText(XmlValidatorResources
				.getString("preference.ruletable.deselect.btn"));
		btnDeselectAll.setLayoutData(gridBData);

		btnDeselectAll.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				ruleTableEditor.deselectAll();
			}
		});
		return composite;
	}

	private Composite createRuleTable(Composite parent) {
		ruleTableEditor = new RuleTableEditor();
		Composite composite = ruleTableEditor.createContents(parent);
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		return composite;
	}

	private Composite createRuleSetTable(Composite parent) {
		rulesetTable = new RuleSetTable(parent, SWT.BORDER | SWT.SINGLE
				| SWT.FULL_SELECTION | SWT.BORDER, RULESET_TABLE_COLUMNS);

		LOG.debug("rule set count:"
				+ VRuleManager.getInstance().getRuleSetTable().values().size());
		rulesetTable.setData(VRuleManager.getInstance().getRuleSetTable()
				.values());


		rulesetTable.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				TableItem[] selection = rulesetTable.getSelection();
				String ruleSetName = selection[0].getText();
				VRuleSet set = VRuleManager.getInstance().getRuleSetTable()
						.get(ruleSetName);
				if (set != null) {
					// ruleTable.setData(set.getRules());
					ruleTableEditor.setRules(set.getRules());
				}
			}
		});

		return rulesetTable;
	}

	public void init(IWorkbench workbench) {
		new PreferenceInitializer().initializeDefaultPreferences();
//		VRuleManager.getInstance().loadFromPreference();
	}
	
	protected void performDefaults(){
		super.performDefaults();
		
		//set all enabled and set severity Error
		Hashtable<String, VRuleSet> ruleSetTable = VRuleManager.getInstance().getRuleSetTable();
		if(ruleSetTable != null && ruleSetTable.size() > 0){
			for(VRuleSet ruleSet : ruleSetTable.values()){
				List<VRuleDef> rules = ruleSet.getRules();
				if(rules != null && rules.size() > 0){
					for(VRuleDef rule : rules){
						rule.setEnabled(true);
						rule.setSeverity(SEVERITY.ERROR);
					}
				}
			}
		}
		
		//update UI
		if(rulesetTable.getSelectionIndex() >= 0){
			TableItem item = rulesetTable.getItem(rulesetTable.getSelectionIndex());
			String ruleSetName = item.getText();
			VRuleSet set = VRuleManager.getInstance().getRuleSetTable().get(ruleSetName);
			if (set != null) {
				ruleTableEditor.setRules(set.getRules());
			}
		}
	}
	
	public boolean performOk(){
		VRuleManager.getInstance().saveToPreference();
		return super.performOk();
	}

}