/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.annotations;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.stp.sc.common.annotations.ScAnnotationSupportUtils;
import org.eclipse.stp.sc.jaxws.utils.TestUtilities;

public class ScAnnotationSupportUtilsTest
extends TestCase {
    public static final String JAVA_PROJECT_NAME = "ScAnnotationSupportTest_JAVA";
    public static final String JAXWS_PROJECT_NAME = "ScAnnotationSupportTest_JAXWS";
    IProject javaProject;
    IProject jaxwsProject;

    protected void setUp() throws Exception {
        super.setUp();
        this.jaxwsProject = ResourcesPlugin.getWorkspace().getRoot().getProject(JAXWS_PROJECT_NAME);
        if (!this.jaxwsProject.exists()) {
            this.jaxwsProject = this.createJaxWsProject();
            TestUtilities.setupJavaProject(this.jaxwsProject);
        } else {
            try {
                this.jaxwsProject.open(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.javaProject = TestUtilities.createTestCeltixProject(JAVA_PROJECT_NAME);
    }

    protected void tearDown() throws Exception {
        this.javaProject.delete(true, null);
        this.jaxwsProject.delete(true, null);
        super.tearDown();
    }

    private IProject createJaxWsProject() {
        return TestUtilities.createTestCeltixProject(JAXWS_PROJECT_NAME);
    }

    public void testAnnotationForTypes() throws Exception {
        List annoList = ScAnnotationSupportUtils.getAvailableAnnotationsForClass((IProject)this.jaxwsProject);
        ScAnnotationSupportUtilsTest.assertEquals((String)"should return 10 class annotaions for jax-ws project", (int)annoList.size(), (int)10);
        annoList = ScAnnotationSupportUtils.getAvailableAnnotationsForInterface((IProject)this.jaxwsProject);
        ScAnnotationSupportUtilsTest.assertEquals((String)"should return 6 interface annotaions for jax-ws project", (int)annoList.size(), (int)6);
    }

    public void testJavaAnnotationNature() throws Exception {
        List annoList = ScAnnotationSupportUtils.getAvailableAnnotationsForClass((IProject)this.javaProject);
        ScAnnotationSupportUtilsTest.assertTrue((String)"should return no class annotation for java project", (annoList.size() == 0 ? 1 : 0) != 0);
        annoList = ScAnnotationSupportUtils.getAvailableAnnotationsForInterface((IProject)this.javaProject);
        ScAnnotationSupportUtilsTest.assertTrue((String)"should return no interface annotation for java project", (annoList.size() == 0 ? 1 : 0) != 0);
    }

    public void testJaxWsAnnotationNature() throws Exception {
        List annoList = ScAnnotationSupportUtils.getAvailableAnnotationsForClass((IProject)this.jaxwsProject);
        ScAnnotationSupportUtilsTest.assertEquals((String)"should return 10 class annotaions for jax-ws project", (int)annoList.size(), (int)10);
        annoList = ScAnnotationSupportUtils.getAvailableAnnotationsForInterface((IProject)this.jaxwsProject);
        ScAnnotationSupportUtilsTest.assertEquals((String)"should return 6 interface annotaions for jax-ws project", (int)annoList.size(), (int)6);
    }
}

