/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards;

import java.lang.reflect.InvocationTargetException;
import javax.jws.WebService;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.utils.SWTUtils;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.internal.wizards.RuntimeSelectionPage;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IWizardPageContentsBase;
import org.eclipse.stp.sc.jaxws.utils.TestUtilities;
import org.eclipse.stp.sc.jaxws.wizards.AbstractStartingPointPageContents;
import org.eclipse.stp.sc.jaxws.wizards.StartingPointWizardPage;
import org.eclipse.stp.sc.jaxws.wizards.WebServiceProjectWizard;
import org.eclipse.stp.sc.jaxws.wizards.WizardPageBase;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class WebServiceProjectWizardTest
extends TestCase {
    private static String TEST_PROJECT_NAME = "JAXWS-JavaFirst-TestProject";
    private static String TEMP_PROJECT_NAME = "tempProject";
    private static final String JAVA_RESOURCE = "HelloInterface.java_resource";
    private static final String LOCAL_JAVA = "src/HelloInterface.java";
    private static final String IMPORTED_JAVA = "src/com/iona/HelloInterface.java";

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
        TestUtilities.destroy(DebugPlugin.getDefault().getLaunchManager(), ConsolePlugin.getDefault().getConsoleManager());
        IProject proj = WorkspaceManager.getProject((String)TEST_PROJECT_NAME);
        if (proj.exists()) {
            proj.delete(true, null);
        }
        if ((proj = WorkspaceManager.getProject((String)TEMP_PROJECT_NAME)).exists()) {
            proj.delete(true, null);
        }
    }

    public void testAddPages() throws Exception {
        WebServiceProjectWizard wizard = new WebServiceProjectWizard();
        wizard.init(PlatformUI.getWorkbench(), null);
        WebServiceProjectWizardTest.assertTrue((boolean)wizard.needsProgressMonitor());
        wizard.addPages();
        int count = wizard.getPageCount();
        WebServiceProjectWizardTest.assertEquals((String)"should have 3 pages", (int)3, (int)count);
    }

    public void testCreateJavaFirstProject() throws Exception {
        TestUtilities.createTestRuntime();
        MyWebServiceProjectWizard wizard = new MyWebServiceProjectWizard();
        wizard.addPages();
        wizard.init(PlatformUI.getWorkbench(), null);
        WizardNewProjectCreationPage genPage = (WizardNewProjectCreationPage)wizard.getPage("generalPage");
        genPage.createControl((Composite)PlatformUI.getWorkbench().getDisplay().getShells()[0]);
        Text txtProjectName = SWTUtils.getTextInCompositeByLabel((Composite)((Composite)genPage.getControl()), (String)"&Project name:");
        txtProjectName.setText(TEST_PROJECT_NAME);
        RuntimeSelectionPage runtimePage = (RuntimeSelectionPage)wizard.getPage("runtimePage");
        runtimePage.createControl((Composite)PlatformUI.getWorkbench().getDisplay().getShells()[0]);
        runtimePage.selectRuntimeByIndex(0);
        IProject tempProject = TestUtilities.createTestCeltixProject(TEMP_PROJECT_NAME);
        IFile testFile = TestUtilities.addFileResourceToTestProject((IProject)tempProject, (String)LOCAL_JAVA, ((Object)((Object)this)).getClass(), (String)"/resources/HelloInterface.java_resource");
        StartingPointWizardPage startPointPage = (StartingPointWizardPage)wizard.getPage("startingPointPage");
        startPointPage.createControl((Composite)PlatformUI.getWorkbench().getDisplay().getShells()[0]);
        startPointPage.updateControl(runtimePage.getRuntimeType());
        IWizardPage additionalPage = startPointPage.getNextPage();
        while (additionalPage != null) {
            if (additionalPage instanceof WizardPageBase && additionalPage.getControl() == null) {
                additionalPage.createControl((Composite)PlatformUI.getWorkbench().getDisplay().getShells()[0]);
            }
            additionalPage = additionalPage.getNextPage();
        }
        startPointPage.setPageContents((IWizardPageContentsBase)new MyStartingPointPageContents(testFile.getLocation().toOSString()));
        startPointPage.createControl((Composite)PlatformUI.getWorkbench().getDisplay().getShells()[0]);
        try {
            wizard.performFinish();
        }
        catch (Exception e) {
            e.printStackTrace();
            WebServiceProjectWizardTest.fail((String)e.getMessage());
        }
        IProject proj = WorkspaceManager.getProject((String)TEST_PROJECT_NAME);
        WebServiceProjectWizardTest.assertTrue((String)"should  create project.", (boolean)proj.exists());
        WebServiceProjectWizardTest.assertTrue((String)"should have jax-ws nature", (boolean)proj.hasNature("org.eclipse.stp.sc.jaxws.nature"));
        WebServiceProjectWizardTest.assertTrue((String)"should have java first nature", (boolean)proj.hasNature("org.eclipse.stp.sc.jaxws.javaFirstNature"));
        WebServiceProjectWizardTest.assertTrue((String)"should has ann validatation builder", (boolean)WorkspaceManager.hasBuilder((IProject)proj, (String)"org.eclipse.stp.sc.annvalidator"));
        String mode = proj.getPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_MODE);
        WebServiceProjectWizardTest.assertNotNull((Object)mode);
        WebServiceProjectWizardTest.assertTrue((String)"should set to java first mode.", (boolean)mode.equals("JavaFrist"));
        IFile importFile = proj.getFile(IMPORTED_JAVA);
        WebServiceProjectWizardTest.assertNotNull((Object)importFile);
        WebServiceProjectWizardTest.assertTrue((String)"should exist starting point file", (boolean)importFile.exists());
        proj.build(10, null);
        JDTUtils.hasAnnotationOnPrimaryType((IFile)importFile, WebService.class);
        IFile javaServer = proj.getFile("src/com/iona/HelloInterfaceImpl.java");
        String[] names = new String[]{"sourceMethod1", "sourceMethod2"};
        String[] sources = new String[]{"public java.lang.String sourceMethod1() {  System.out.println(\"In method1\");try {java.lang.String _return = \"SourceMehtod1\";return _return;} catch (Exception ex) {ex.printStackTrace();throw new RuntimeException(ex);}}", "public java.lang.String sourceMethod2(java.lang.String arg0) {  System.out.println(arg0);    try {java.lang.String _return = \"SourceMehtod2\";return _return;} catch (Exception ex) {ex.printStackTrace();throw new RuntimeException(ex);}}"};
        WebServiceProjectWizardTest.assertTrue((String)"Code Change!", (boolean)TestUtilities.addSourceCodeToMethod(javaServer, names, sources));
        IFile javaClient = proj.getFile("src/com/iona/HelloInterfaceClient.java");
        String[] clientnames = new String[]{"main"};
        String[] clientsources = new String[]{"public static void main(String[] args) {QName serviceName = new QName(\"http://iona.com/\", \"HelloInterfaceService\");QName portName = new QName(\"http://iona.com/\", \"HelloInterfacePort\");Service service = Service.create(serviceName);service.addPort(portName, SOAPBinding.SOAP11HTTP_BINDING,\"http://localhost:9090/HelloInterfacePort\"); com.iona.HelloInterface client = service.getPort(portName,  com.iona.HelloInterface.class);System.out.println(client.sourceMethod1());System.out.println(client.sourceMethod2(\"test\"));}"};
        WebServiceProjectWizardTest.assertTrue((String)"Code Change!", (boolean)TestUtilities.addSourceCodeToMethod(javaClient, clientnames, clientsources));
        WebServiceProjectWizardTest.assertTrue((String)"Build Successful!", (boolean)TestUtilities.buildProject(proj));
        ILaunchConfiguration[] configurations = TestUtilities.getConfiguration("org.eclipse.jdt.launching.localJavaApplication");
        WebServiceProjectWizardTest.assertNotNull((String)"Have these launth files!", (Object)configurations);
        WebServiceProjectWizardTest.assertEquals((String)"Have two launth files!", (int)2, (int)configurations.length);
        IConsoleManager consolemanager = TestUtilities.getConsoleManager();
        WebServiceProjectWizardTest.assertNotNull((String)"Run Server Successful!!", (Object)TestUtilities.runApplication(configurations, "server"));
        IConsole[] consoles = consolemanager.getConsoles();
        int time = 0;
        while (!((TextConsole)consoles[0]).getDocument().get().contains("Server ready")) {
            WebServiceProjectWizardTest.assertTrue((String)"Start Server Failure!", (++time < 30 ? 1 : 0) != 0);
            TestUtilities.delay(1000L);
        }
        ILaunch launch = TestUtilities.runApplication(configurations, "client");
        WebServiceProjectWizardTest.assertNotNull((String)"Run Client Successful!!", (Object)launch);
        time = 0;
        while (!launch.getProcesses()[0].isTerminated()) {
            WebServiceProjectWizardTest.assertTrue((String)"Start Client Failure!", (++time < 30 ? 1 : 0) != 0);
            TestUtilities.delay(1000L);
        }
        TestUtilities.delay(2000L);
        this.checkText(consolemanager.getConsoles());
    }

    private void checkText(IConsole[] consoles) {
        if (consoles[0].getName().contains("server")) {
            WebServiceProjectWizardTest.assertTrue((String)"Server Ready!", (boolean)TestUtilities.isContainString(consoles[0], "Server ready"));
            WebServiceProjectWizardTest.assertTrue((String)"Server method1()!", (boolean)TestUtilities.isContainString(consoles[0], "In method1"));
            WebServiceProjectWizardTest.assertTrue((String)"Server method1() parameter!", (boolean)TestUtilities.isContainString(consoles[0], "test"));
            WebServiceProjectWizardTest.assertTrue((String)"Client called SourceMehtod1()!", (boolean)TestUtilities.isContainString(consoles[1], "SourceMehtod1"));
            WebServiceProjectWizardTest.assertTrue((String)"Client called SourceMehtod2()!", (boolean)TestUtilities.isContainString(consoles[1], "SourceMehtod2"));
        } else {
            WebServiceProjectWizardTest.assertTrue((String)"Server Ready!", (boolean)TestUtilities.isContainString(consoles[1], "Server ready"));
            WebServiceProjectWizardTest.assertTrue((String)"Server method1()!", (boolean)TestUtilities.isContainString(consoles[1], "In method1"));
            WebServiceProjectWizardTest.assertTrue((String)"Server method1() parameter!", (boolean)TestUtilities.isContainString(consoles[1], "test"));
            WebServiceProjectWizardTest.assertTrue((String)"Client called SourceMehtod1()!", (boolean)TestUtilities.isContainString(consoles[0], "SourceMehtod1"));
            WebServiceProjectWizardTest.assertTrue((String)"Client called SourceMehtod2()!", (boolean)TestUtilities.isContainString(consoles[0], "SourceMehtod2"));
        }
    }

    class MyStartingPointPageContents
    extends AbstractStartingPointPageContents {
        private String fileName;

        public MyStartingPointPageContents(String fileName) {
            this.fileName = fileName;
        }

        public Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            this.txtStartingPoint.setText(this.fileName);
            return control;
        }
    }

    class MyWebServiceProjectWizard
    extends WebServiceProjectWizard {
        MyWebServiceProjectWizard() {
        }

        public boolean publicCreateProject() throws InvocationTargetException {
            return super.createProject(null);
        }
    }
}

