/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.sc.common.utils.SWTUtils;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.internal.wizards.RuntimeSelectionPage;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.utils.TestUtilities;
import org.eclipse.stp.sc.jaxws.wizards.WsdlFirstProjectWizard;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class WsdlFirstProjectWizardTest
extends TestCase {
    private static String TEST_PROJECT_NAME = "JAXWS-WSDLFirst-TestProject";
    private static String TEMP_PROJECT_NAME = "tempProject";
    private static String TEST_WSDL_FILE_RESOURCE = "hello_world.wsdl";
    private static String LOCAL_WSDL_FILE = "hello_world.wsdl";
    WsdlFirstProjectWizard wizard;
    MyWizardDialog dialog;
    Button backButton;
    Button nextButton;
    Button finishButton;
    Button cancelButton;

    protected void setUp() throws Exception {
        TestUtilities.createTestRuntime();
        this.wizard = new WsdlFirstProjectWizard();
        this.wizard.init(PlatformUI.getWorkbench(), null);
        this.dialog = new MyWizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)this.wizard);
        this.dialog.setBlockOnOpen(false);
        this.dialog.open();
        this.backButton = this.dialog.getTheButton(14);
        this.nextButton = this.dialog.getTheButton(15);
        this.finishButton = this.dialog.getTheButton(16);
        this.cancelButton = this.dialog.getTheButton(1);
    }

    protected void tearDown() throws Exception {
        TestUtilities.destroy(DebugPlugin.getDefault().getLaunchManager(), ConsolePlugin.getDefault().getConsoleManager());
        IProject proj = WorkspaceManager.getProject((String)TEST_PROJECT_NAME);
        if (proj.exists()) {
            proj.delete(true, null);
        }
        if ((proj = WorkspaceManager.getProject((String)TEMP_PROJECT_NAME)).exists()) {
            proj.delete(true, null);
        }
        if (this.dialog != null) {
            this.dialog.close();
        }
    }

    public void testAddPages() throws Exception {
        int count = this.wizard.getPageCount();
        WsdlFirstProjectWizardTest.assertEquals((String)"should have 4 pages", (int)4, (int)count);
    }

    public void testCreateWsdlFirstProjectOnly() throws Exception {
        WizardNewProjectCreationPage genPage = this.wizard.genPage;
        Text txtProjectName = SWTUtils.getTextInCompositeByLabel((Composite)((Composite)genPage.getControl()), (String)"&Project name:");
        txtProjectName.setText(TEST_PROJECT_NAME);
        RuntimeSelectionPage runtimePage = this.wizard.runtimePage;
        runtimePage.selectRuntimeByIndex(0);
        this.finishButton.notifyListeners(13, new Event());
        IProject proj = WorkspaceManager.getProject((String)TEST_PROJECT_NAME);
        WsdlFirstProjectWizardTest.assertTrue((String)"should  create project.", (boolean)proj.exists());
        WsdlFirstProjectWizardTest.assertTrue((String)"should have jax-ws nature", (boolean)proj.hasNature("org.eclipse.stp.sc.jaxws.nature"));
        WsdlFirstProjectWizardTest.assertFalse((String)"shouldn't have jaxb builder", (boolean)WorkspaceManager.hasBuilder((IProject)proj, (String)"org.eclipse.stp.sc.jaxws.builders.jaxbbuilder"));
        WsdlFirstProjectWizardTest.assertFalse((String)"shouldn't hava j2w builder", (boolean)WorkspaceManager.hasBuilder((IProject)proj, (String)"org.eclipse.stp.sc.jaxws.builders.javatowsdlbuilder"));
        WsdlFirstProjectWizardTest.assertTrue((String)"should has ann validatation builder", (boolean)WorkspaceManager.hasBuilder((IProject)proj, (String)"org.eclipse.stp.sc.annvalidator"));
        String mode = proj.getPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_MODE);
        WsdlFirstProjectWizardTest.assertNotNull((Object)mode);
        WsdlFirstProjectWizardTest.assertTrue((String)"should set to wsdl first mode.", (boolean)mode.equals("WSDLFrist"));
    }

    public void testCreateProjectWithWsdl() throws Exception {
        WizardNewProjectCreationPage genPage = this.wizard.genPage;
        Text txtProjectName = SWTUtils.getTextInCompositeByLabel((Composite)((Composite)genPage.getControl()), (String)"&Project name:");
        txtProjectName.setText(TEST_PROJECT_NAME);
        this.nextButton.notifyListeners(13, new Event());
        RuntimeSelectionPage runtimePage = this.wizard.runtimePage;
        runtimePage.selectRuntimeByIndex(0);
        this.nextButton.notifyListeners(13, new Event());
        IProject tempProject = TestUtilities.createTestCeltixProject(TEMP_PROJECT_NAME);
        IFile testFile = TestUtilities.addFileResourceToTestProject((IProject)tempProject, (String)LOCAL_WSDL_FILE, ((Object)((Object)this)).getClass(), (String)("/resources/" + TEST_WSDL_FILE_RESOURCE));
        this.wizard.wsdlPage.composite.txtFilePath.setText(testFile.getLocation().toOSString());
        this.nextButton.notifyListeners(13, new Event());
        this.finishButton.notifyListeners(13, new Event());
        IProject proj = WorkspaceManager.getProject((String)TEST_PROJECT_NAME);
        WsdlFirstProjectWizardTest.assertTrue((String)"should  create project.", (boolean)proj.exists());
        IFile javaFile = proj.getFile("src/org/apache/hello_world_soap_http/Greeter.java");
        WsdlFirstProjectWizardTest.assertTrue((String)"should generate java code.", (boolean)javaFile.exists());
        IFile wsdlFile = proj.getFile("wsdl/hello_world.wsdl");
        WsdlFirstProjectWizardTest.assertTrue((String)"should generate wsdl file.", (boolean)wsdlFile.exists());
        WsdlFirstProjectWizardTest.assertTrue((String)"Build Successful!", (boolean)TestUtilities.buildProject(proj));
        ILaunchConfiguration[] configurations = TestUtilities.getConfiguration("org.eclipse.jdt.launching.localJavaApplication");
        WsdlFirstProjectWizardTest.assertNotNull((String)"Got these launth files!", (Object)configurations);
        WsdlFirstProjectWizardTest.assertEquals((String)"Have two launth files!", (int)2, (int)configurations.length);
        IConsoleManager consolemanager = TestUtilities.getConsoleManager();
        WsdlFirstProjectWizardTest.assertNotNull((String)"Run Server Successful!!", (Object)TestUtilities.runApplication(configurations, "server"));
        IConsole[] consoles = consolemanager.getConsoles();
        int time = 0;
        while (!((TextConsole)consoles[0]).getDocument().get().contains("Server ready")) {
            WsdlFirstProjectWizardTest.assertTrue((String)"Start Server Failure!", (++time < 30 ? 1 : 0) != 0);
            TestUtilities.delay(1000L);
        }
        ILaunch launch = TestUtilities.runApplication(configurations, "client");
        WsdlFirstProjectWizardTest.assertNotNull((String)"Run Client Successful!!", (Object)launch);
        time = 0;
        while (!launch.getProcesses()[0].isTerminated()) {
            WsdlFirstProjectWizardTest.assertTrue((String)"Start Client Failure!", (++time < 30 ? 1 : 0) != 0);
            TestUtilities.delay(1000L);
        }
        this.checkText(consolemanager.getConsoles());
    }

    public void testCreateProjectWithoutCodeGeneration() throws Exception {
        WizardNewProjectCreationPage genPage = this.wizard.genPage;
        Text txtProjectName = SWTUtils.getTextInCompositeByLabel((Composite)((Composite)genPage.getControl()), (String)"&Project name:");
        txtProjectName.setText(TEST_PROJECT_NAME);
        this.nextButton.notifyListeners(13, new Event());
        RuntimeSelectionPage runtimePage = this.wizard.runtimePage;
        runtimePage.selectRuntimeByIndex(0);
        IProject tempProject = TestUtilities.createTestCeltixProject(TEMP_PROJECT_NAME);
        IFile testFile = TestUtilities.addFileResourceToTestProject((IProject)tempProject, (String)LOCAL_WSDL_FILE, ((Object)((Object)this)).getClass(), (String)("/resources/" + TEST_WSDL_FILE_RESOURCE));
        this.wizard.wsdlPage.composite.txtFilePath.setText(testFile.getLocation().toOSString());
        WsdlFirstProjectWizardTest.assertTrue((String)"should check the code generation button.", (boolean)this.wizard.wsdlPage.composite.cbtGenCode.getSelection());
        this.wizard.wsdlPage.composite.cbtGenCode.setSelection(false);
        this.wizard.wsdlPage.composite.cbtGenCode.notifyListeners(13, new Event());
        WsdlFirstProjectWizardTest.assertTrue((String)"should disable next button.", (!this.nextButton.isEnabled() ? 1 : 0) != 0);
        this.finishButton.notifyListeners(13, new Event());
        IProject proj = WorkspaceManager.getProject((String)TEST_PROJECT_NAME);
        WsdlFirstProjectWizardTest.assertTrue((String)"should  create project.", (boolean)proj.exists());
        IFile javaFile = proj.getFile("src/org/apache/hello_world_soap_http/Greeter.java");
        WsdlFirstProjectWizardTest.assertTrue((String)"should not generate java code.", (!javaFile.exists() ? 1 : 0) != 0);
        IFile wsdlFile = proj.getFile("wsdl/hello_world.wsdl");
        WsdlFirstProjectWizardTest.assertTrue((String)"should generate wsdl file.", (boolean)wsdlFile.exists());
    }

    private void checkText(IConsole[] consoles) {
        if (consoles[0].getName().contains("Server")) {
            WsdlFirstProjectWizardTest.assertTrue((String)"Server Ready!", (boolean)TestUtilities.isContainString(consoles[0], "Server ready"));
            WsdlFirstProjectWizardTest.assertTrue((String)"Client called sayHi()!", (boolean)TestUtilities.isContainString(consoles[1], "sayHi.result="));
            WsdlFirstProjectWizardTest.assertTrue((String)"Client called greetMe()!", (boolean)TestUtilities.isContainString(consoles[1], "greetMe.result="));
        } else {
            WsdlFirstProjectWizardTest.assertTrue((String)"Server Ready!", (boolean)TestUtilities.isContainString(consoles[1], "Server ready"));
            WsdlFirstProjectWizardTest.assertTrue((String)"Client called sayHi()!", (boolean)TestUtilities.isContainString(consoles[0], "sayHi.result="));
            WsdlFirstProjectWizardTest.assertTrue((String)"Client called greetMe()!", (boolean)TestUtilities.isContainString(consoles[0], "greetMe.result="));
        }
    }

    class MyWizardDialog
    extends WizardDialog {
        public MyWizardDialog(Shell parentShell, IWizard newWizard) {
            super(parentShell, newWizard);
        }

        public Button getTheButton(int id) {
            return super.getButton(id);
        }
    }
}

