/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards.annotations.webmethod;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.sc.jaxws.utils.TestUtilities;
import org.eclipse.stp.sc.jaxws.wizards.ScWizardDialog;
import org.eclipse.stp.sc.jaxws.wizards.annotations.webmethod.CreateWebMethodWizard;
import org.eclipse.stp.sc.jaxws.wizards.annotations.webmethod.MethodSelectionPage2;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class MethodSelectionPage2Test
extends TestCase {
    private static final String TEST_PROJECT_NAME = "MethodSelectionPageTestProject";
    private static final String LOCAL_JAVA = "MyWebService.java";
    private static final String JAVA_RESOURCE = "MyWebService.java_resource";
    IProject testProject;
    IMember member;
    CreateWebMethodWizard wizard;
    WizardDialog dialog;
    MethodSelectionPage2 testPage;

    protected void setUp() throws Exception {
        this.testProject = TestUtilities.createTestCeltixProject(TEST_PROJECT_NAME);
        IFile testFile = TestUtilities.addFileResourceToTestProject((IProject)this.testProject, (String)LOCAL_JAVA, ((Object)((Object)this)).getClass(), (String)"/resources/MyWebService.java_resource");
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        TestUtilities.openEditor((IWorkbenchWindow)window, (IFile)testFile);
        IJavaElement javaFile = JavaCore.create((IFile)testFile);
        MethodSelectionPage2Test.assertTrue((boolean)(javaFile instanceof ICompilationUnit));
        IType[] types = ((ICompilationUnit)javaFile).getTypes();
        int i = 0;
        while (i < types.length) {
            if (types[i] instanceof IMember) {
                this.member = types[i];
                break;
            }
            ++i;
        }
        this.wizard = new CreateWebMethodWizard(this.member);
        this.dialog = new ScWizardDialog(window.getShell(), (IWizard)this.wizard);
        this.dialog.setBlockOnOpen(false);
        this.dialog.open();
        this.testPage = (MethodSelectionPage2)this.wizard.getPage("selectionPage");
    }

    protected void tearDown() throws Exception {
        this.dialog.close();
        if (this.testProject != null && this.testProject.exists()) {
            this.testProject.delete(true, null);
        }
        this.testPage = null;
        this.wizard = null;
    }

    public void testInitialSetup() throws Exception {
        MethodSelectionPage2Test.assertEquals((int)5, (int)this.testPage.methodViewer.getTable().getItemCount());
        MethodSelectionPage2Test.assertEquals((int)0, (int)this.testPage.methodViewer.getCheckedElements().length);
    }

    public void testSortingAndLabeling() throws Exception {
        MethodSelectionPage2Test.assertEquals((String)"bye()", (String)this.testPage.methodViewer.getTable().getItem(0).getText());
        MethodSelectionPage2Test.assertEquals((String)"greetMe(String)", (String)this.testPage.methodViewer.getTable().getItem(1).getText());
        MethodSelectionPage2Test.assertEquals((String)"hi()", (String)this.testPage.methodViewer.getTable().getItem(2).getText());
        MethodSelectionPage2Test.assertEquals((String)"sayHi()", (String)this.testPage.methodViewer.getTable().getItem(3).getText());
        MethodSelectionPage2Test.assertEquals((String)"sendData(String)", (String)this.testPage.methodViewer.getTable().getItem(4).getText());
    }

    public void testValidation() throws Exception {
        MethodSelectionPage2Test.assertEquals((int)0, (int)this.testPage.methodViewer.getCheckedElements().length);
        MethodSelectionPage2Test.assertFalse((boolean)this.testPage.validateInputs());
        MethodSelectionPage2Test.assertNull((Object)this.testPage.getMessage());
        MethodSelectionPage2Test.assertNotNull((Object)this.testPage.getErrorMessage());
        this.simulateMetodSelectionByUser(1);
        MethodSelectionPage2Test.assertEquals((int)1, (int)this.testPage.methodViewer.getCheckedElements().length);
        MethodSelectionPage2Test.assertTrue((boolean)this.testPage.validateInputs());
        MethodSelectionPage2Test.assertNull((Object)this.testPage.getMessage());
        MethodSelectionPage2Test.assertNull((Object)this.testPage.getErrorMessage());
        this.simulateMetodSelectionByUser(0);
        MethodSelectionPage2Test.assertEquals((int)1, (int)this.testPage.methodViewer.getCheckedElements().length);
        MethodSelectionPage2Test.assertTrue((boolean)this.testPage.validateInputs());
        MethodSelectionPage2Test.assertNull((Object)this.testPage.getMessage());
        MethodSelectionPage2Test.assertNull((Object)this.testPage.getErrorMessage());
        this.simulateMetodSelectionByUser(0);
        MethodSelectionPage2Test.assertEquals((int)0, (int)this.testPage.methodViewer.getCheckedElements().length);
        MethodSelectionPage2Test.assertFalse((boolean)this.testPage.validateInputs());
        MethodSelectionPage2Test.assertNull((Object)this.testPage.getMessage());
        MethodSelectionPage2Test.assertNotNull((Object)this.testPage.getErrorMessage());
    }

    public void testInitializeFromData() throws Exception {
        this.wizard.getWizardData().remove("DATA_KEY_MEMBER");
        this.testPage.initializeFromData(this.wizard.getWizardData());
        MethodSelectionPage2Test.assertEquals((int)0, (int)this.testPage.methodViewer.getCheckedElements().length);
        MethodSelectionPage2Test.assertNotNull((Object)this.testPage.getErrorMessage());
        this.wizard.setJavaMemberToData((IMember)this.testPage.methodViewer.getElementAt(1));
        this.testPage.initializeFromData(this.wizard.getWizardData());
        MethodSelectionPage2Test.assertEquals((int)1, (int)this.testPage.methodViewer.getCheckedElements().length);
        MethodSelectionPage2Test.assertEquals((Object)this.testPage.methodViewer.getElementAt(1), (Object)this.testPage.methodViewer.getCheckedElements()[0]);
        MethodSelectionPage2Test.assertNull((Object)this.testPage.getErrorMessage());
        this.wizard.getWizardData().remove("DATA_KEY_MEMBER");
        this.testPage.initializeFromData(this.wizard.getWizardData());
        MethodSelectionPage2Test.assertEquals((int)0, (int)this.testPage.methodViewer.getCheckedElements().length);
        MethodSelectionPage2Test.assertNotNull((Object)this.testPage.getErrorMessage());
        this.wizard.setJavaMemberToData((IMember)this.testPage.methodViewer.getElementAt(0));
        this.testPage.initializeFromData(this.wizard.getWizardData());
        MethodSelectionPage2Test.assertEquals((int)1, (int)this.testPage.methodViewer.getCheckedElements().length);
        MethodSelectionPage2Test.assertEquals((Object)this.testPage.methodViewer.getElementAt(0), (Object)this.testPage.methodViewer.getCheckedElements()[0]);
        MethodSelectionPage2Test.assertNull((Object)this.testPage.getErrorMessage());
    }

    public void testApplyToData() throws Exception {
        this.wizard.getWizardData().remove("DATA_KEY_MEMBER");
        this.simulateMetodSelectionByUser(1);
        this.testPage.applyToData(this.wizard.getWizardData());
        MethodSelectionPage2Test.assertEquals((Object)this.testPage.methodViewer.getElementAt(1), (Object)this.wizard.getJavaMemberFromData());
        this.simulateMetodSelectionByUser(0);
        this.testPage.applyToData(this.wizard.getWizardData());
        MethodSelectionPage2Test.assertEquals((Object)this.testPage.methodViewer.getElementAt(0), (Object)this.wizard.getJavaMemberFromData());
        this.simulateMetodSelectionByUser(2);
        this.testPage.applyToData(this.wizard.getWizardData());
        MethodSelectionPage2Test.assertEquals((Object)this.testPage.methodViewer.getElementAt(2), (Object)this.wizard.getJavaMemberFromData());
    }

    private void simulateMetodSelectionByUser(int tableIndex) {
        Event event = new Event();
        event.detail = 32;
        TableItem item = this.testPage.methodViewer.getTable().getItem(tableIndex);
        item.setChecked(true);
        event.item = item;
        event.widget = item;
        this.testPage.methodViewer.handleSelect(new SelectionEvent(event));
    }
}

