/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards.handler;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.jws.HandlerChain;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.sc.common.annotations.ScAnnotationSupportUtils;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.utils.SWTUtils;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.internal.wizards.RuntimeSelectionPage;
import org.eclipse.stp.sc.jaxws.utils.TestUtilities;
import org.eclipse.stp.sc.jaxws.wizards.WebServiceProjectWizard;
import org.eclipse.stp.sc.jaxws.wizards.WsdlFirstProjectWizard;
import org.eclipse.stp.sc.jaxws.wizards.WsdlSelectionComposite;
import org.eclipse.stp.sc.jaxws.wizards.WsdlSettingPage;
import org.eclipse.stp.sc.jaxws.wizards.handler.NewHandlerCreationWizard;
import org.eclipse.stp.sc.jaxws.wizards.handler.NewHandlerWizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewHandlerCreationTest
extends TestCase {
    private static final String TEST_PROJECT_NAME = "JAXWS-Handler-TestProject";
    private static final String WSDL_HOLDER_PROJECT_NAME = "Wsdl-Holder-Project";
    private static final String LOCAL_WSDL = "hello_world.wsdl";
    private static final String HANDLER_CLASS_NAME = "MyHandler";
    private static final String NEW_HANDLER_CHAIN_FILE_NAME = "HandlerChain.xml";
    NewHandlerCreationWizard handlerWizard;
    MyWizardDialog dialog;
    Button finishButton;
    Button nextButton;
    private IProject testProject = null;
    private IProject wsdlProject = null;
    IFile wsdlFile = null;
    IFile serviceFile = null;

    protected void setUp() throws Exception {
        TestUtilities.createTestRuntime();
        this.wsdlProject = TestUtilities.createTestCeltixProject(WSDL_HOLDER_PROJECT_NAME);
        TestUtilities.setupJavaProject(this.wsdlProject);
        IFile tmpFile = TestUtilities.addFileResourceToTestProject((IProject)this.wsdlProject, (String)LOCAL_WSDL, ((Object)((Object)this)).getClass(), (String)"/resources/hello_world.wsdl");
        WsdlFirstProjectWizard projectWizard = new WsdlFirstProjectWizard();
        MyWizardDialog tmpDialog = new MyWizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)projectWizard);
        tmpDialog.setBlockOnOpen(false);
        tmpDialog.open();
        this.finishButton = tmpDialog.getTheButton(16);
        this.nextButton = tmpDialog.getTheButton(15);
        IWizardPage[] pages = projectWizard.getPages();
        WizardNewProjectCreationPage genPage = (WizardNewProjectCreationPage)pages[0];
        Text txtProjectName = SWTUtils.getTextInCompositeByLabel((Composite)((Composite)genPage.getControl()), (String)"&Project name:");
        txtProjectName.setText(TEST_PROJECT_NAME);
        this.nextButton.notifyListeners(13, new Event());
        RuntimeSelectionPage runtimePage = (RuntimeSelectionPage)projectWizard.getPage("runtimePage");
        runtimePage.selectRuntimeByIndex(0);
        String wsdlPath = tmpFile.getLocation().toOSString();
        WsdlSettingPage wsdlPage = (WsdlSettingPage)projectWizard.getPage("wsdlPage");
        WsdlSelectionComposite composite = (WsdlSelectionComposite)wsdlPage.getControl();
        composite.txtFilePath.setText(wsdlPath);
        this.nextButton.notifyListeners(13, new Event());
        this.finishButton.notifyListeners(13, new Event());
        if (tmpDialog != null) {
            tmpDialog.close();
        }
        this.testProject = WorkspaceManager.getProject((String)TEST_PROJECT_NAME);
        NewHandlerCreationTest.assertTrue((String)"should create project.", (boolean)this.testProject.exists());
        this.serviceFile = this.testProject.getFile("src/org/apache/hello_world_soap_http/Greeter.java");
        NewHandlerCreationTest.assertTrue((String)"should generate java code.", (boolean)this.serviceFile.exists());
        this.wsdlFile = this.testProject.getFile("wsdl/hello_world.wsdl");
        NewHandlerCreationTest.assertTrue((String)"should generate wsdl file.", (boolean)this.wsdlFile.exists());
    }

    public void testCreateSimpleLogicalHandler() throws Exception {
        this.handlerWizard = new NewHandlerCreationWizard();
        this.handlerWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object[])new IFile[]{this.wsdlFile}));
        this.dialog = new MyWizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)this.handlerWizard);
        this.dialog.setBlockOnOpen(false);
        this.dialog.open();
        this.finishButton = this.dialog.getTheButton(16);
        NewHandlerCreationTest.assertEquals((String)"should have 1 page", (int)1, (int)this.handlerWizard.getPageCount());
        NewHandlerWizardPage page = (NewHandlerWizardPage)this.handlerWizard.getPages()[0];
        page.setTypeName(HANDLER_CLASS_NAME, true);
        this.finishButton.notifyListeners(13, new Event());
        IJavaProject javaProject = JDTUtils.findJavaProject((String)TEST_PROJECT_NAME);
        NewHandlerCreationTest.assertNotNull((String)"should be a java project", (Object)javaProject);
        IType handlerClass = javaProject.findType(HANDLER_CLASS_NAME);
        NewHandlerCreationTest.assertNotNull((String)"should generate handler class", (Object)handlerClass);
    }

    public void testCreateLogicalHandler() throws Exception {
        this.handlerWizard = new NewHandlerCreationWizard();
        this.handlerWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object[])new IFile[]{this.serviceFile}));
        this.dialog = new MyWizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)this.handlerWizard);
        this.dialog.setBlockOnOpen(false);
        this.dialog.open();
        this.finishButton = this.dialog.getTheButton(16);
        NewHandlerCreationTest.assertEquals((String)"should have 1 page", (int)1, (int)this.handlerWizard.getPageCount());
        NewHandlerWizardPage page = (NewHandlerWizardPage)this.handlerWizard.getPages()[0];
        page.setTypeName(HANDLER_CLASS_NAME, true);
        page.setNewHandlerChainFilePath(TEST_PROJECT_NAME + File.separator + NEW_HANDLER_CHAIN_FILE_NAME);
        this.finishButton.notifyListeners(13, new Event());
        Thread.sleep(2000L);
        IJavaProject javaProject = JDTUtils.findJavaProject((String)TEST_PROJECT_NAME);
        NewHandlerCreationTest.assertNotNull((String)"should be a java project", (Object)javaProject);
        IType handlerClass = javaProject.findType("org.apache.hello_world_soap_http.MyHandler");
        NewHandlerCreationTest.assertNotNull((String)"should generate handler class", (Object)handlerClass);
        IFile chainFile = this.testProject.getFile(NEW_HANDLER_CHAIN_FILE_NAME);
        NewHandlerCreationTest.assertNotNull((String)"should generate handler chain file", (Object)chainFile);
        NewHandlerCreationTest.assertTrue((String)"should generate handler chain file", (boolean)chainFile.exists());
        Annotation handlerChainAnn = this.getHandlerChainAnn(this.serviceFile);
        NewHandlerCreationTest.assertNotNull((String)"should generate handler chain annotaion", (Object)handlerChainAnn);
        this.handlerWizard = new NewHandlerCreationWizard();
        this.handlerWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object[])new IFile[]{chainFile}));
        this.dialog = new MyWizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)this.handlerWizard);
        this.dialog.setBlockOnOpen(false);
        this.dialog.open();
        this.finishButton = this.dialog.getTheButton(16);
        Thread.sleep(2000L);
        NewHandlerCreationTest.assertEquals((String)"should have 1 page", (int)1, (int)this.handlerWizard.getPageCount());
        page = (NewHandlerWizardPage)this.handlerWizard.getPages()[0];
        page.setTypeName(HANDLER_CLASS_NAME, true);
        IFile serviceImpl = this.testProject.getFile("src/org/apache/hello_world_soap_http/Greeter.java");
        NewHandlerCreationTest.assertTrue((String)"should have web service implementation class.", (boolean)serviceImpl.exists());
        page.setWebServiceClassPath(serviceImpl.getLocation().toOSString());
        this.finishButton.notifyListeners(13, new Event());
        handlerClass = javaProject.findType(HANDLER_CLASS_NAME);
        NewHandlerCreationTest.assertNotNull((String)"should generate handler class with default package", (Object)handlerClass);
        handlerChainAnn = this.getHandlerChainAnn(serviceImpl);
        NewHandlerCreationTest.assertNotNull((String)"should generate handler chain annotaion for service impl.", (Object)handlerChainAnn);
    }

    protected void tearDown() throws Exception {
        if (this.testProject != null && this.testProject.exists()) {
            this.testProject.refreshLocal(2, null);
            File project = this.testProject.getLocation().toFile();
            if (project.exists()) {
                project.delete();
            }
        }
        if (this.wsdlProject != null && this.wsdlProject.exists()) {
            this.wsdlProject.delete(false, null);
        }
        if (this.dialog != null) {
            this.dialog.close();
        }
    }

    private Annotation getHandlerChainAnn(IFile file) {
        IType targetMember;
        ICompilationUnit cu;
        Annotation rtnValue = null;
        if (file != null && file.exists() && file.getFileExtension().equalsIgnoreCase("java") && (cu = JDTUtils.getJavaUnitFromFile((IFile)file)) != null && (targetMember = cu.findPrimaryType()) != null) {
            CompilationUnit astRoot = JDTUtils.getDomRootCompilationUnit((IMember)targetMember);
            Annotation node = ScAnnotationSupportUtils.getDefaultedAnnotationNode(HandlerChain.class, (CompilationUnit)astRoot, (IMember)targetMember, null);
            rtnValue = JDTUtils.findAnnotation((CompilationUnit)astRoot, (IMember)targetMember, (Annotation)node);
        }
        return rtnValue;
    }

    class MyWebServiceProjectWizard
    extends WebServiceProjectWizard {
        MyWebServiceProjectWizard() {
        }

        public boolean publicCreateProject() throws InvocationTargetException {
            return super.createProject(null);
        }
    }

    class MyWizardDialog
    extends WizardDialog {
        public MyWizardDialog(Shell parentShell, IWizard newWizard) {
            super(parentShell, newWizard);
        }

        public Button getTheButton(int id) {
            return super.getButton(id);
        }
    }
}

