/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.ResourceUtils;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.stp.sc.jaxws.wizards.enablejaxws.EnableWizardBase;
import org.eclipse.stp.sc.jaxws.wizards.enablejaxws.JavaFirstEnableWizard;
import org.eclipse.stp.sc.jaxws.wizards.enablejaxws.SelectProgramModeDialog;
import org.eclipse.stp.sc.jaxws.wizards.enablejaxws.WsdlFirstEnableWizard;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class EnableScNatureAction
implements IWorkbenchWindowActionDelegate {
    public static IAction enableAction = null;
    private static final LoggingProxy LOG = LoggingProxy.getlogger(EnableScNatureAction.class);

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        try {
            IProject project = ResourceUtils.getActiveProject();
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                SelectProgramModeDialog dialog = new SelectProgramModeDialog(shell);
                int choose = dialog.open();
                EnableWizardBase wizard = null;
                if (choose == 0) {
                    wizard = dialog.getIsJavaFirst() ? new JavaFirstEnableWizard(project) : new WsdlFirstEnableWizard(project);
                    RuntimeProviderManager runtimeMgr = RuntimeProviderManager.getInstance();
                    if (!runtimeMgr.getUseDefaultRuntime() || dialog.getIsJavaFirst()) {
                        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
                        wizardDialog.open();
                    } else {
                        wizard.performFinish();
                    }
                }
                IJavaProject javaProject = JavaCore.create((IProject)project);
                javaProject.setOutputLocation(JaxWsWorkspaceManager.getClassesFolder(project).getFullPath(), null);
                project.build(10, null);
            } else {
                LOG.error((Object)"only java project can be jax-ws enabled");
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"error while enabling JAX-WS", (Throwable)ex);
        }
    }

    public void selectionChanged(IAction action, ISelection sel) {
    }
}

