/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.annotations.filter;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.annvalidator.filter.IAnnFileFilter;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.jaxws.builders.JavaDocumentUtils;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;

public class JaxWsAnnFilter
implements IAnnFileFilter {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(JaxWsAnnFilter.class);

    public boolean needsToValidate(IFile file) {
        ICompilationUnit unit;
        block10: {
            block9: {
                block8: {
                    block7: {
                        if (file.getFileExtension() != null) break block7;
                        return false;
                    }
                    if (file.getFileExtension().equals("java")) break block8;
                    return false;
                }
                if (file.getPersistentProperty(JaxWsWorkspaceManager.WSDL_PROPERTY) == null) break block9;
                return false;
            }
            unit = JDTUtils.getJavaUnitFromFile((IFile)file);
            if (unit != null) break block10;
            return false;
        }
        try {
            IType type = unit.findPrimaryType();
            if (type != null) {
                return JavaDocumentUtils.hasWebServiceAnnotation(file);
            }
        }
        catch (CoreException e) {
            LOG.debug((Object)"error when check for validator filter", (Throwable)e);
        }
        return false;
    }
}

