/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards;

import java.util.ArrayList;
import javax.jws.WebService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.utils.ResourceUtils;
import org.eclipse.stp.sc.common.workspace.WorkspaceManager;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IAdditionalPageContents;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IStartingPointPageContents;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.stp.sc.jaxws.utils.ScJDTUtils;
import org.eclipse.stp.sc.jaxws.wizards.AdditionalWizardPage;
import org.eclipse.stp.sc.jaxws.wizards.WizardPageBase;
import org.eclipse.stp.sc.jaxws.wizards.annotations.CreateAnnotationWizard;
import org.eclipse.stp.sc.jaxws.wizards.annotations.webmethod.CreateWebMethodWizard;
import org.eclipse.stp.sc.jaxws.wizards.annotations.webservice.CreateWebServiceWizard;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartingPointWizardPage
extends WizardPageBase<IStartingPointPageContents> {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(StartingPointWizardPage.class);
    private IWizardPage nextPage = null;

    public StartingPointWizardPage(String pageName) {
        super(pageName, null);
    }

    @Override
    protected Composite createPage(Composite parent) {
        ((IStartingPointPageContents)this.pageContents).createContents(parent);
        return parent;
    }

    public void updateControl(String newRuntimeType) {
        IAdditionalPageContents addPage;
        RuntimeProviderManager rtMgr = RuntimeProviderManager.getInstance();
        this.pageContents = rtMgr.getStartingPointPage(newRuntimeType);
        if (this.pageContents != null) {
            ((IStartingPointPageContents)this.pageContents).setChangeListener(this);
            super.updateControl();
        }
        if ((addPage = rtMgr.getAdditionalPage(newRuntimeType)) != null) {
            AdditionalWizardPage newWizardPage = new AdditionalWizardPage(addPage.getPageName(), addPage);
            newWizardPage.setWizard(this.getWizard());
            this.nextPage = newWizardPage;
        } else {
            this.nextPage = null;
        }
    }

    public IWizardPage getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(IWizardPage page) {
        this.nextPage = page;
    }

    @Override
    public void performFinish(IProject project) {
        super.performFinish(project);
        try {
            String originalFile = ((IStartingPointPageContents)this.pageContents).getStartingPoint();
            IFile targetFile = JDTUtils.importJavaFileToProject((String)originalFile, (IFolder)JaxWsWorkspaceManager.getSrcFolder(project));
            project.setPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_STARTING_POINT, targetFile.getProjectRelativePath().toOSString());
            this.importDependencies(project);
            this.addExternalLibraries(project);
            project.build(10, null);
            this.annotateStartPointClass(project);
            ResourceUtils.selectAndOpenResource((IFile)targetFile);
        }
        catch (Exception ex) {
            LOG.error((Object)"error during import the starting point", (Throwable)ex);
        }
    }

    protected void annotateStartPointClass(IProject project) {
        block15: {
            ICompilationUnit cu = null;
            try {
                try {
                    String fileName = project.getPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_STARTING_POINT);
                    IFile targetFile = project.getFile(fileName);
                    cu = (ICompilationUnit)JavaCore.create((IFile)targetFile);
                    cu.open(null);
                    IType mainType = cu.findPrimaryType();
                    if (mainType.isInterface()) {
                        this.annotateInterface(mainType);
                        break block15;
                    }
                    if (mainType.getSuperInterfaceNames() != null && mainType.getSuperInterfaceNames().length > 0) {
                        this.annotateImpl(mainType);
                        break block15;
                    }
                    this.annotatePojo(mainType);
                }
                catch (Exception exception) {
                    LOG.error((Object)("error while add web service annotations to the starting point of project: " + project));
                    try {
                        if (cu != null && cu.isOpen()) {
                            cu.save(null, true);
                            cu.close();
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex);
                    }
                }
            }
            finally {
                try {
                    if (cu != null && cu.isOpen()) {
                        cu.save(null, true);
                        cu.close();
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                }
            }
        }
    }

    protected void addExternalLibraries(IProject project) {
        String[] libs = ((IStartingPointPageContents)this.pageContents).getDependentLibraries();
        if (libs != null && libs.length > 0) {
            ArrayList<IClasspathEntry> clsLibs = new ArrayList<IClasspathEntry>();
            int i = 0;
            while (i < libs.length) {
                try {
                    clsLibs.add(JavaCore.newLibraryEntry((IPath)new Path(libs[i]), null, null));
                }
                catch (Exception ex) {
                    LOG.error((Object)("error during creating librarie: " + libs[i]), (Throwable)ex);
                }
                ++i;
            }
            try {
                if (clsLibs.size() > 0) {
                    WorkspaceManager.addEntriesToClassPath((IJavaProject)JavaCore.create((IProject)project), clsLibs);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)("error during adding libraries: " + clsLibs), (Throwable)ex);
            }
        }
    }

    protected void importDependencies(IProject project) {
        String[] files = ((IStartingPointPageContents)this.pageContents).getDependentJavaFiles();
        if (files != null && files.length > 0) {
            int i = 0;
            while (i < files.length) {
                try {
                    JDTUtils.importJavaFileToProject((String)files[i], (IFolder)JaxWsWorkspaceManager.getSrcFolder(project));
                }
                catch (Exception ex) {
                    LOG.error((Object)("error during import java file: " + files[i]), (Throwable)ex);
                }
                ++i;
            }
        }
    }

    private void annotateInterface(IType mainType) {
        IPreferenceStore store = null;
        CreateAnnotationWizard wizard = null;
        try {
            store = ScJaxWsPlugin.getDefault().getPreferenceStore();
            String prefValue = store.getString("annWizEnabled");
            store.setValue("annWizEnabled", "disabled");
            if (mainType.isInterface()) {
                IMethod[] methods;
                wizard = new CreateWebServiceWizard((IMember)mainType);
                wizard.performFinish();
                store.setValue("annWizEnabled", prefValue);
                if (((IStartingPointPageContents)this.pageContents).getNeedAddWebMethodAnnotations() && (methods = mainType.getMethods()) != null && methods.length > 0) {
                    if (mainType.isInterface()) {
                        int i = 0;
                        while (i < methods.length) {
                            wizard = new CreateWebMethodWizard((IMember)methods[i]);
                            wizard.performFinish();
                            ++i;
                        }
                    } else if (!Flags.isAbstract((int)mainType.getFlags())) {
                        int i = 0;
                        while (i < methods.length) {
                            if (Flags.isPublic((int)methods[i].getFlags()) && !Flags.isAbstract((int)methods[i].getFlags())) {
                                wizard = new CreateWebMethodWizard((IMember)methods[i]);
                                wizard.performFinish();
                            }
                            ++i;
                        }
                    } else {
                        LOG.error((Object)("invalid class to be annotated: " + mainType.getElementName()));
                    }
                }
            } else {
                LOG.error((Object)("this class is not an interface: " + mainType.getElementName()));
            }
        }
        catch (Exception exception) {
            LOG.error((Object)("error while add web service annotations to the SEI class: " + mainType));
        }
    }

    private void annotateImpl(IType mainType) {
        try {
            if (mainType.isInterface()) {
                LOG.error((Object)("this class should not be an interface: " + mainType.getElementName()));
                return;
            }
            String[] superInterfaceNames = mainType.getSuperInterfaceNames();
            if (superInterfaceNames != null && superInterfaceNames.length > 0) {
                IType[] interfaces = mainType.newSupertypeHierarchy(null).getAllInterfaces();
                if (interfaces == null) {
                    this.annotatePojo(mainType);
                    return;
                }
                IType webserviceType = interfaces[0];
                ICompilationUnit cu = webserviceType.getCompilationUnit();
                if (cu.exists()) {
                    cu.open(null);
                    this.annotateInterface(webserviceType);
                    cu.save(null, true);
                    cu.close();
                }
                CompilationUnit astRoot = JDTUtils.getDomRootCompilationUnit((IMember)mainType);
                ArrayList<MemberValuePair> annotValues = new ArrayList<MemberValuePair>();
                MemberValuePair valPair = JDTUtils.newMemberValuePair((CompilationUnit)astRoot, (String)"endpointInterface", (Object)webserviceType.getFullyQualifiedName());
                annotValues.add(valPair);
                NormalAnnotation node = JDTUtils.newNormalAnnotation((CompilationUnit)astRoot, (String)WebService.class.getSimpleName(), annotValues);
                if (node != null) {
                    try {
                        ScJDTUtils.addAnnotationToCu((ICompilationUnit)mainType.getCompilationUnit(), (CompilationUnit)astRoot, (Annotation)node, (IMember)mainType, null, (boolean)true);
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                LOG.error((Object)("this class should be an IMPL class: " + mainType));
            }
        }
        catch (Exception exception) {
            LOG.error((Object)("error while add web service annotations to the IMPL class: " + mainType));
        }
    }

    private void annotatePojo(IType mainType) {
        try {
            CompilationUnit astRoot = JDTUtils.getDomRootCompilationUnit((IMember)mainType);
            NormalAnnotation node = JDTUtils.newNormalAnnotation((CompilationUnit)astRoot, (String)WebService.class.getSimpleName(), null);
            if (node != null) {
                try {
                    ScJDTUtils.addAnnotationToCu((ICompilationUnit)mainType.getCompilationUnit(), (CompilationUnit)astRoot, (Annotation)node, (IMember)mainType, null, (boolean)true);
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception exception) {
            LOG.error((Object)("error while add web service annotations to the POJO class: " + mainType));
        }
    }
}

