/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IPageContentsChangeListener;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IWizardPageContentsBase;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WizardPageBase<T extends IWizardPageContentsBase>
extends WizardPage
implements IPageContentsChangeListener {
    protected T pageContents;
    private static final LoggingProxy LOG = LoggingProxy.getlogger(WizardPageBase.class);

    public WizardPageBase(String pageName, T pageContents) {
        super(pageName);
        this.pageContents = pageContents;
    }

    protected Composite createPage(Composite parent) {
        this.pageContents.createContents(parent);
        return parent;
    }

    public void createControl(Composite parent) {
        Composite pageComposite = new Composite(parent, 0);
        pageComposite.setLayoutData((Object)new GridData(1808));
        pageComposite.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)pageComposite);
        if (this.pageContents != null) {
            this.createPage(pageComposite);
            this.setTitle(this.pageContents.getTitle());
            this.setDescription(this.pageContents.getDescription());
            this.validatePage();
        }
    }

    public boolean validatePage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (this.pageContents.isPageValid()) {
            this.setPageComplete(true);
            return true;
        }
        this.setPageComplete(false);
        this.setErrorMessage(this.pageContents.getErrorMsg());
        return false;
    }

    @Override
    public void whenValidStatusChanged() {
        this.validatePage();
    }

    public void performFinish(IProject project) {
        this.pageContents.setProject(project);
        this.pageContents.performFinish();
    }

    public void setPageContents(T pageContents) {
        this.pageContents = pageContents;
        if (pageContents != null) {
            pageContents.setChangeListener(this);
        }
    }

    public void updateControl() {
        if (this.pageContents != null) {
            Control curComposite = this.getControl();
            Composite parent = curComposite.getParent();
            Composite pageComposite = new Composite(parent, 0);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessVerticalSpace = true;
            gridData.grabExcessHorizontalSpace = true;
            gridData.verticalAlignment = 4;
            pageComposite.setLayoutData((Object)gridData);
            pageComposite.setLayout((Layout)new GridLayout(1, false));
            this.createPage(pageComposite);
            this.setControl((Control)pageComposite);
            this.setTitle(this.pageContents.getTitle());
            this.setDescription(this.pageContents.getDescription());
            parent.layout();
            curComposite.dispose();
            this.pageContents.setChangeListener(this);
            this.validatePage();
        } else {
            LOG.error((Object)"null page contents to be updated");
        }
    }
}

