/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards.handler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.jws.HandlerChain;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.utils.JDTUtils;
import org.eclipse.stp.sc.common.validator.XMLUtils;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.utils.ScJDTUtils;
import org.eclipse.stp.sc.jaxws.wizards.WsdlFirstProjectWizard;
import org.eclipse.stp.sc.jaxws.wizards.handler.NewHandlerWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class NewHandlerCreationWizard
extends BasicNewResourceWizard {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(WsdlFirstProjectWizard.class);
    static final String HANDLER_CHAINS_TAG = "handler-chains";
    static final String HANDLER_CHAIN_TAG = "handler-chain";
    static final String HANDLER_TAG = "handler";
    static final String HANDLER_NAME_TAG = "handler-name";
    static final String HANDLER_CLASS_TAG = "handler-class";
    static final String HANDLER_DEFAULT_NAMESPACE = "http://java.sun.com/xml/ns/javaee";
    private IWorkbench fWorkbench;
    private IStructuredSelection fSelection;
    NewHandlerWizardPage mainPage = null;

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.fWorkbench = workbench;
        this.fSelection = currentSelection;
        super.init(workbench, currentSelection);
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new NewHandlerWizardPage();
        this.mainPage.init(this.fSelection);
        this.addPage((IWizardPage)this.mainPage);
        this.setWindowTitle(ScJaxWsResources.getString("JaxwsHandler.NewHandlerCreationWizard.Title"));
    }

    public boolean performFinish() {
        if (this.mainPage != null) {
            this.mainPage.createHandlerClass((IProgressMonitor)new NullProgressMonitor());
            IResource resource = this.mainPage.getModifiedResource();
            if (resource != null) {
                this.selectAndReveal((IResource)((IFile)resource));
                this.openResource((IFile)resource);
            }
            IFile handlerChainFile = null;
            IFile serviceFile = null;
            if (this.mainPage.getIsAddedToChain()) {
                ICompilationUnit cu;
                IType targetMember;
                String filePath = this.mainPage.getHandlerChainFilePathAbsolute();
                if (filePath != null && filePath.length() > 0) {
                    File file = new File(filePath);
                    this.addHandlerToChainFile(file, this.mainPage.getTypeName().trim(), this.mainPage.getPackageText().trim().length() > 0 ? String.valueOf(this.mainPage.getPackageText().trim()) + "." + this.mainPage.getTypeName().trim() : this.mainPage.getTypeName().trim());
                    try {
                        handlerChainFile = this.mainPage.getFileFromPath(filePath);
                        if (handlerChainFile != null) {
                            handlerChainFile.refreshLocal(1, null);
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (this.mainPage.getIsAssociated() && (serviceFile = this.mainPage.getFileFromPath(this.mainPage.getServiceClassFilePath())) != null && (targetMember = (cu = JDTUtils.getJavaUnitFromFile((IFile)serviceFile)).findPrimaryType()) != null) {
                    String relativePath = this.mainPage.getHandlerChainFilePathAbsolute();
                    if (handlerChainFile != null && (relativePath = this.getRelativePath(handlerChainFile.getFullPath(), serviceFile.getFullPath())) == null) {
                        relativePath = handlerChainFile.getLocation().toString();
                    }
                    CompilationUnit astRoot = JDTUtils.getDomRootCompilationUnit((IMember)targetMember);
                    ArrayList<MemberValuePair> annotValues = new ArrayList<MemberValuePair>();
                    MemberValuePair valPair = JDTUtils.newMemberValuePair((CompilationUnit)astRoot, (String)"file", (Object)relativePath);
                    annotValues.add(valPair);
                    NormalAnnotation node = JDTUtils.newNormalAnnotation((CompilationUnit)astRoot, (String)HandlerChain.class.getSimpleName(), annotValues);
                    if (node != null) {
                        try {
                            ScJDTUtils.addAnnotationToCu((ICompilationUnit)cu, (CompilationUnit)astRoot, (Annotation)node, (IMember)targetMember, null, (boolean)true);
                        }
                        catch (Exception e) {
                            LOG.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }
        return true;
    }

    private void openResource(final IFile resource) {
        Display display;
        final IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null && (display = this.getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)resource, (boolean)true);
                    }
                    catch (PartInitException e) {
                        LOG.error((Object)e);
                    }
                }
            });
        }
    }

    private void addHandlerToChainFile(File file, String handlerName, String handlerClass) {
        DocumentBuilder db = null;
        Document doc = null;
        DocumentBuilderFactory.newInstance().setAttribute("", null);
        try {
            if (file != null) {
                db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            if (!file.exists()) {
                boolean isCreated = false;
                try {
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    isCreated = file.createNewFile();
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    isCreated = false;
                }
                if (!isCreated) {
                    LOG.error((Object)("Cannot create this file: " + file.toString()));
                    return;
                }
                doc = db.newDocument();
                Element rootElement = doc.createElementNS(HANDLER_DEFAULT_NAMESPACE, HANDLER_CHAINS_TAG);
                this.addHandlerToRootElement(doc, rootElement, handlerName, handlerClass);
                doc.appendChild(rootElement);
            } else {
                doc = db.parse(file);
                Element rootElement = doc.getDocumentElement();
                this.addHandlerToRootElement(doc, rootElement, handlerName, handlerClass);
            }
            XMLUtils.saveDocument((Document)doc, (String)file.getAbsolutePath());
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    private void addHandlerToRootElement(Document doc, Element root, String handlerName, String handlerClass) {
        if (doc != null && root != null) {
            Element chain = doc.createElement(HANDLER_CHAIN_TAG);
            Element handler = doc.createElement(HANDLER_TAG);
            Text txtName = doc.createTextNode(handlerName);
            Text txtClass = doc.createTextNode(handlerClass);
            Element handlerNameEle = doc.createElement(HANDLER_NAME_TAG);
            Element handlerClassEle = doc.createElement(HANDLER_CLASS_TAG);
            handlerNameEle.appendChild(txtName);
            handlerClassEle.appendChild(txtClass);
            handler.appendChild(handlerNameEle);
            handler.appendChild(handlerClassEle);
            chain.appendChild(handler);
            root.appendChild(chain);
        }
    }

    private String getRelativePath(IPath arg0, IPath arg1) {
        StringBuffer buf = new StringBuffer();
        if (arg0 != null && arg1 != null) {
            int count = arg0.matchingFirstSegments(arg1);
            int setCount0 = arg0.segmentCount();
            int segCount1 = arg1.segmentCount();
            int i = 0;
            while (i < segCount1 - count - 1) {
                buf.append("..");
                buf.append(File.separatorChar);
                ++i;
            }
            i = 0;
            while (i < setCount0 - count - 1) {
                buf.append(arg0.segment(count + i));
                buf.append(File.separatorChar);
                ++i;
            }
            buf.append(arg0.segment(setCount0 - 1));
        }
        return buf.toString();
    }
}

