/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxwsri.generators;

import java.util.HashMap;
import java.util.Hashtable;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.stp.sc.jaxwsri.generators.JAXWSRIWsdlToJavaGenerator;
import org.eclipse.stp.sc.jaxwsri.test.utils.TestUtilities;

public class JAXWSRIWsdlToJavaGeneratorTest
extends TestCase {
    private IProject testProject = null;
    private static final String TEST_PROJECT_NAME = "test.jaxwsri";
    private static final String WSDL_FILE = "wsdl/hello_world.wsdl";
    private static final String RESOURCE_WSDL_FILE = "/resources/hello_world.wsdl";
    private static final String SOURCE_FOLDER = "src";
    private static final String GENERATED_JAVA_FILE = "src/org/apache/hello_world_soap_http/Greeter.java";

    protected void setUp() throws Exception {
        this.testProject = TestUtilities.createTestJaxwsriProject(TEST_PROJECT_NAME);
        TestUtilities.setupJavaProject(this.testProject);
        TestUtilities.setupTestRuntimeInfo(this.testProject);
        TestUtilities.addFileResourceToTestProject(this.testProject, WSDL_FILE, ((Object)((Object)this)).getClass(), RESOURCE_WSDL_FILE);
    }

    protected void tearDown() throws Exception {
        if (this.testProject.exists()) {
            this.testProject.delete(true, null);
        }
    }

    public void testWsdl2Java() throws Exception {
        JAXWSRIWsdlToJavaGeneratorTest.assertTrue((String)"the project should exist", (boolean)this.testProject.exists());
        IFile wsdlFile = this.testProject.getFile(WSDL_FILE);
        JAXWSRIWsdlToJavaGeneratorTest.assertTrue((String)"the wsdl file should exist", (boolean)wsdlFile.exists());
        IFolder srcFolder = this.testProject.getFolder(SOURCE_FOLDER);
        JAXWSRIWsdlToJavaGeneratorTest.assertTrue((String)"the src folder should exist", (boolean)srcFolder.exists());
        Hashtable<String, Object> data = new Hashtable<String, Object>();
        data.put("GEN_OUTPUTDIR", srcFolder.getRawLocation().toOSString());
        data.put("TOOL_SPECIFIC_OPS", new HashMap());
        JAXWSRIWsdlToJavaGenerator generator = new JAXWSRIWsdlToJavaGenerator();
        generator.setInitializationData(null, null, data);
        generator.run(wsdlFile.getLocation(), this.testProject);
        IFile javaFile = this.testProject.getFile(GENERATED_JAVA_FILE);
        JAXWSRIWsdlToJavaGeneratorTest.assertTrue((String)"should generate service file", (boolean)javaFile.exists());
    }
}

