/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.soas.deploy.core.FilePackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.IServerType;
import org.eclipse.stp.soas.deploy.core.IVersion;
import org.eclipse.stp.soas.deploy.core.ServerType;
import org.eclipse.stp.soas.deploy.core.Version;
import org.eclipse.stp.soas.internal.deploy.core.wtpbridge.module.WTPServiceModuleFactory;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.internal.ServerPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentUtil {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(DeploymentUtil.class);

    public static Version convertWTPVersion(String version) {
        return null;
    }

    public static Map<org.eclipse.wst.server.core.IServerType, List<IServer>> getServerMap() {
        HashMap<org.eclipse.wst.server.core.IServerType, List<IServer>> mpServer = new HashMap<org.eclipse.wst.server.core.IServerType, List<IServer>>();
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            org.eclipse.wst.server.core.IServerType serverType = servers[i].getServerType();
            if (mpServer.containsKey(serverType)) {
                ((List)mpServer.get(serverType)).add(servers[i]);
            } else {
                ArrayList<IServer> svrs = new ArrayList<IServer>();
                svrs.add(servers[i]);
                mpServer.put(serverType, svrs);
            }
            ++i;
        }
        return mpServer;
    }

    public static IVersion getSTPVersionFromWTPServer(String serverId) {
        if (serverId == null) {
            return null;
        }
        String version = null;
        int maj = 0;
        int minor = 0;
        int index = serverId.lastIndexOf(".");
        if (index > 0 && (version = serverId.substring(index + 1)).length() > 1) {
            minor = Integer.valueOf(version.substring(version.length() - 1));
            maj = Integer.valueOf(version.substring(0, version.length() - 1));
        }
        return new Version(maj, minor, 0, "");
    }

    public static IVersion getSTPVersionByWTPRuntimeType(IRuntimeType runtimeType) {
        String wtpVersion = runtimeType.getVersion();
        int maj = 0;
        int min = 0;
        try {
            if (wtpVersion.length() > 1 && wtpVersion.indexOf(".") >= 0) {
                min = Integer.valueOf(wtpVersion.substring(wtpVersion.indexOf(".") + 1));
                maj = Integer.valueOf(wtpVersion.substring(0, wtpVersion.indexOf(".")));
            } else if (Integer.valueOf(wtpVersion) != null) {
                return new Version(Integer.valueOf(wtpVersion), min, 0, "");
            }
        }
        catch (Exception exception) {
            return Version.NULL_VERSION;
        }
        return new Version(maj, min, 0, "");
    }

    public static IVersion getSTPVersionByWTPServerType(org.eclipse.wst.server.core.IServerType serverType) {
        return DeploymentUtil.getSTPVersionByWTPRuntimeType(serverType.getRuntimeType());
    }

    public static IVersion getSTPVersionFromWTPServer(IServer server) {
        return DeploymentUtil.getSTPVersionByWTPServerType(server.getServerType());
    }

    public static IServerType convertWTPServerTypeToSTPServerType(org.eclipse.wst.server.core.IServerType wtpServerType) {
        String serverTypeId = wtpServerType.getId();
        return DeploymentUtil.getServerTypeByServerTypeId(serverTypeId);
    }

    public static IServerType getServerTypeByServerTypeId(String wtpServerTypeId) {
        org.eclipse.wst.server.core.IServerType serverType = ServerCore.findServerType((String)wtpServerTypeId);
        IVersion version = DeploymentUtil.getSTPVersionByWTPServerType(serverType);
        return new ServerType(wtpServerTypeId, version);
    }

    public static void deployWTPModule(IPackageOutputDescriptor descriptor, String serverID, IProject project) throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        root.getProjects();
        WTPServiceModuleFactory moduleFactory = null;
        ModuleFactory[] moduleFactoryArray = ServerPlugin.getModuleFactories();
        int n = moduleFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleFactory mf = moduleFactoryArray[n2];
            if (mf.getId().equals("org.eclipse.stp.soas.deploy.core.serverModuleFactory")) {
                moduleFactory = (WTPServiceModuleFactory)mf.getDelegate(null);
                LOG.debug((Object)"found stp module factory");
                break;
            }
            ++n2;
        }
        IModule module = null;
        if (descriptor instanceof FilePackageOutputDescriptor) {
            File warFile = ((FilePackageOutputDescriptor)descriptor).getFile();
            module = moduleFactory.createModule(project, descriptor, warFile);
        } else {
            module = moduleFactory.createModule(project, descriptor, null);
        }
        if (module != null) {
            LOG.debug((Object)("created IModule:" + module + " for server:" + serverID));
            IServer server = ServerCore.findServer((String)serverID);
            if (server != null) {
                moduleFactory.clearModuleCache();
                IServerWorkingCopy workingCopy = server.createWorkingCopy();
                workingCopy.modifyModules(new IModule[]{module}, null, null);
                IServer updatedSvr = workingCopy.save(false, null);
                LOG.debug((Object)"added to the server");
                IModule[] iModuleArray = updatedSvr.getModules();
                int n3 = iModuleArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IModule mod = iModuleArray[n4];
                    LOG.debug((Object)("server mod:" + mod.getName()));
                    ++n4;
                }
            }
        }
    }

    public static void undeployWTPModule(IPackageOutputDescriptor descriptor, String serverID) throws Exception {
        WTPServiceModuleFactory moduleFactory = null;
        ModuleFactory[] moduleFactoryArray = ServerPlugin.getModuleFactories();
        int n = moduleFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleFactory mf = moduleFactoryArray[n2];
            if (mf.getId().equals("org.eclipse.stp.soas.deploy.core.serverModuleFactory")) {
                moduleFactory = (WTPServiceModuleFactory)mf.getDelegate(null);
                LOG.debug((Object)"found stp module factory");
                break;
            }
            ++n2;
        }
        String moduleName = moduleFactory.getModuleName(descriptor);
        IServer server = ServerCore.findServer((String)serverID);
        IModule module = null;
        if (server != null) {
            IModule[] iModuleArray = server.getModules();
            int n3 = iModuleArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IModule mod = iModuleArray[n4];
                if (mod.getName().equals(moduleName)) {
                    module = mod;
                    break;
                }
                LOG.debug((Object)("server mod:" + mod.getName()));
                ++n4;
            }
            if (module != null) {
                IServerWorkingCopy workingCopy = server.createWorkingCopy();
                workingCopy.modifyModules(null, new IModule[]{module}, null);
                workingCopy.save(false, null);
                LOG.debug((Object)"remove from the server");
            }
        }
    }

    public static boolean containsWTPModule(IPackageOutputDescriptor descriptor, String serverID) {
        WTPServiceModuleFactory moduleFactory = null;
        ModuleFactory[] moduleFactoryArray = ServerPlugin.getModuleFactories();
        int n = moduleFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleFactory mf = moduleFactoryArray[n2];
            if (mf.getId().equals("org.eclipse.stp.soas.deploy.core.serverModuleFactory")) {
                moduleFactory = (WTPServiceModuleFactory)mf.getDelegate(null);
                LOG.debug((Object)"found stp module factory");
                break;
            }
            ++n2;
        }
        String moduleName = moduleFactory.getModuleName(descriptor);
        IServer server = ServerCore.findServer((String)serverID);
        if (server != null) {
            IModule[] iModuleArray = server.getModules();
            int n3 = iModuleArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IModule mod = iModuleArray[n4];
                if (mod.getName().equals(moduleName)) {
                    return true;
                }
                LOG.debug((Object)("server mod:" + mod.getName()));
                ++n4;
            }
        }
        return false;
    }

    public static File getDeployFolderByDescriptor(File warFile) {
        String outputDirectory = "";
        String moduleName = warFile.getName();
        File folder = warFile.getParentFile();
        outputDirectory = String.valueOf(folder.getAbsolutePath()) + File.separator + moduleName + "_tmp";
        if (warFile.getName().endsWith(".war")) {
            return new File(outputDirectory);
        }
        return null;
    }

    public static boolean unJarFile(String jarFileName, String outputDirectory) throws Exception {
        ZipInputStream in = null;
        try {
            JarEntry jen;
            File target = new File(outputDirectory);
            if (!target.exists()) {
                target.mkdir();
            }
            if (((JarInputStream)(in = new JarInputStream(new FileInputStream(jarFileName)))).getManifest() != null) {
                File manifest = new File(String.valueOf(outputDirectory) + File.separator + "MATA-INF" + File.separator + "MANIFEST.MF");
                if (!manifest.getParentFile().exists()) {
                    DeploymentUtil.createFolder(manifest.getParentFile());
                }
                manifest.createNewFile();
                FileOutputStream out = new FileOutputStream(manifest);
                ((JarInputStream)in).getManifest().write(out);
                out.close();
            }
            while ((jen = ((JarInputStream)in).getNextJarEntry()) != null) {
                if (jen.isDirectory()) {
                    String name = jen.getName();
                    name = name.substring(0, name.length() - 1);
                    File file = new File(String.valueOf(outputDirectory) + File.separator + name);
                    file.mkdir();
                    continue;
                }
                String fname = String.valueOf(outputDirectory) + File.separator + jen.getName().substring(0, jen.getName().indexOf("/"));
                File dt = new File(fname);
                if (!dt.exists()) {
                    dt.mkdir();
                }
                File file = new File(String.valueOf(outputDirectory) + File.separator + jen.getName());
                DeploymentUtil.creatFileForJarEntry(file, (JarInputStream)in);
            }
            in.close();
            return true;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private static void creatFileForJarEntry(File file, JarInputStream in) throws Exception {
        int b;
        if (!file.getParentFile().exists()) {
            DeploymentUtil.createFolder(file.getParentFile());
        }
        file.createNewFile();
        FileOutputStream out = new FileOutputStream(file);
        while ((b = in.read()) != -1) {
            out.write(b);
        }
        out.close();
    }

    public static boolean createFolder(File file) {
        if (!file.getParentFile().exists()) {
            DeploymentUtil.createFolder(file.getParentFile());
        }
        if (!file.exists()) {
            file.mkdir();
        }
        return true;
    }
}

