/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.core.wtpbridge.module;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.soas.deploy.core.FilePackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;
import org.eclipse.stp.soas.deploy.core.utils.DeploymentUtil;
import org.eclipse.stp.soas.internal.deploy.core.wtpbridge.module.ModuleFile;
import org.eclipse.stp.soas.internal.deploy.core.wtpbridge.module.StpModule;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.ModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ProjectModule;

public class ServiceModuleDelegate
extends ProjectModule
implements IWebModule {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(ServiceModuleDelegate.class);
    IPath ROOT = new Path("/");
    FilePackageOutputDescriptor fileDesc;
    IModule module;

    public ServiceModuleDelegate(IProject project, IPackageOutputDescriptor desc) {
        super(project);
        this.fileDesc = (FilePackageOutputDescriptor)desc;
    }

    public IModule[] getChildModules() {
        return null;
    }

    public IModuleResource[] members() throws CoreException {
        File outputFolder = null;
        if (this.module instanceof StpModule) {
            File warFile = ((StpModule)this.module).getDeployFile();
            outputFolder = DeploymentUtil.getDeployFolderByDescriptor(((StpModule)this.module).getDeployFile());
            if (!outputFolder.exists() && warFile.getName().endsWith(".war")) {
                try {
                    DeploymentUtil.unJarFile(warFile.getAbsolutePath(), outputFolder.getAbsolutePath());
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                    return new IModuleResource[0];
                }
            }
        }
        File[] files = outputFolder.listFiles();
        if (outputFolder == null || !outputFolder.exists() || files == null) {
            return new IModuleResource[0];
        }
        ArrayList<Object> reses = new ArrayList<Object>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File member = fileArray[n2];
            if (member.isDirectory()) {
                ModuleFolder mFolder = this.getModuleFolderMembers(member, (IPath)Path.EMPTY);
                reses.add(mFolder);
            } else {
                ModuleFile mFile = new ModuleFile(member, member.getName(), (IPath)Path.EMPTY);
                reses.add(mFile);
            }
            ++n2;
        }
        return reses.toArray(new IModuleResource[reses.size()]);
    }

    private ModuleFolder getModuleFolderMembers(File folder, IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer container = root.getContainerForLocation((IPath)new Path(folder.getAbsolutePath()));
        ModuleFolder mFolder = new ModuleFolder(container, folder.getName(), path);
        IModuleResource[] res = new IModuleResource[folder.listFiles().length];
        int i = 0;
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                ModuleFolder mf = this.getModuleFolderMembers(file, path.append(file.getParentFile().getName()));
                res[i] = mf;
            } else {
                ModuleFile mfile = new ModuleFile(file, file.getName(), path.append(file.getParentFile().getName()));
                res[i] = mfile;
            }
            ++i;
            ++n2;
        }
        mFolder.setMembers(res);
        return mFolder;
    }

    public IStatus validate() {
        return Status.OK_STATUS;
    }

    public String getContextRoot() {
        return this.module.getName();
    }

    public void setModule(IModule mod) {
        this.module = mod;
    }

    public IModule[] getModules() {
        return new IModule[]{this.module};
    }

    public String getURI(IModule module) {
        LOG.debug((Object)("get url called for module:" + module));
        return String.valueOf(module.getName()) + ".war";
    }

    public IContainer[] getJavaOutputFolders() {
        return null;
    }

    public IContainer[] getResourceFolders() {
        return null;
    }

    public boolean isBinary() {
        return true;
    }

    public String getId() {
        return this.module.getName();
    }
}

