/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipes.stp.soas.deploy.runtime.cxf.core.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

import org.eclipse.stp.common.logging.LoggingProxy;

/**
 * utils class to share between runtimes
 * @author jma
 *
 */
public class RuntimeUtils {
	private static final LoggingProxy LOG = LoggingProxy.getlogger(RuntimeUtils.class);
	
	/**
	 * get list of jar name defined in MANIFEST.MF/classpath for input jar file   
	 * @param jarFileName, jar file name
	 * @return, jar names defined in MANIFEST.ME/classpath
	 */
	public static String[] getLibEntryInManifest(String jarFileName) {
		File facadeFile = new File(jarFileName);
		ArrayList<String> libs = new ArrayList<String>();
		try {
			JarFile facadeJar = new JarFile(facadeFile);
			Manifest mfst = facadeJar.getManifest();
			Attributes attrs = mfst.getMainAttributes();
			String path = attrs.getValue("Class-Path");
			StringTokenizer tkzr = new StringTokenizer(path);
			String libEntry = null;
			while (tkzr.hasMoreTokens()) {
				libEntry = tkzr.nextToken();
				libs.add(libEntry);
			}
		} catch (IOException e) {
			LOG.debug("Exception getting jar facade", e);
		}
		return libs.toArray(new String[0]);
	}
	
	
}
