/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.runtime;

import java.util.List;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.runtime.ExtRuntimeManager;
import org.eclipse.stp.sc.common.runtime.IExtRuntimeProcessor;
import org.eclipse.stp.sc.common.utils.RuntimeUtils;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;

public class RuntimeChangeListener
implements IRuntimeLifecycleListener {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(RuntimeChangeListener.class);

    public void runtimeAdded(IRuntime runtime) {
        LOG.debug((Object)("Runtime " + runtime.getName() + " has been added."));
        this.updateRuntimeLibrary(runtime);
    }

    public void runtimeChanged(IRuntime runtime) {
        LOG.debug((Object)("Runtime " + runtime.getName() + " has been changed."));
        if (RuntimeUtils.getRuntimeLibName(runtime) != null) {
            this.updateRuntimeLibrary(runtime);
        }
    }

    public void runtimeRemoved(IRuntime runtime) {
        LOG.debug((Object)("Runtime " + runtime.getName() + " has been removed."));
        RuntimeUtils.removeRuntimeLib(runtime);
    }

    private void updateRuntimeLibrary(IRuntime runtime) {
        List<IClasspathEntry> cpEntries;
        IExtRuntimeProcessor processor = ExtRuntimeManager.getInstance().getExtendedRuntimeProcessor(runtime.getRuntimeType().getId());
        if (processor != null && (cpEntries = processor.getRuntimeClasspathEntry(runtime)) != null) {
            RuntimeUtils.createRuntimeLib(runtime);
        }
    }
}

