/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.validator;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.validator.MultiErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLSchemaValidator {
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String SCHEMA_FILE_EXD = ".xsd";
    static final String SCHEMA_LOCATION = "etc/validator/";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(XMLSchemaValidator.class);
    Hashtable<String, Schema> schemaTable = new Hashtable();
    MultiErrorHandler errorHandler = new MultiErrorHandler();

    public boolean validateXML(Document doc) {
        Schema schema;
        block3: {
            try {
                Element root = (Element)doc.getFirstChild();
                String namespace = root.getAttribute("xmlns:tns");
                schema = this.getSchemaByNamespace(namespace);
                if (schema != null) break block3;
                LOG.error((Object)"can't find schema for xml. return valid");
                return true;
            }
            catch (Exception e) {
                LOG.error((Object)"error during valid xml.", (Throwable)e);
                return true;
            }
        }
        return this.validateXML(doc, schema);
    }

    private Schema getSchemaByNamespace(String namespace) throws Exception {
        Schema schema = this.schemaTable.get(namespace);
        if (schema != null) {
            return schema;
        }
        String fileName = this.getFileNameFromNS(namespace);
        LOG.debug((Object)("schema file try to load:" + fileName));
        URL baseURL = Platform.getBundle((String)"org.eclipse.stp.sc.jaxws").getEntry("/");
        URL fileURL = new URL(baseURL, fileName);
        try {
            InputStream is = fileURL.openStream();
            SchemaFactory schemaFactory = SchemaFactory.newInstance(W3C_XML_SCHEMA);
            schema = schemaFactory.newSchema(new StreamSource(is));
            LOG.debug((Object)("schema loaded for file:" + fileName));
            this.schemaTable.put(namespace, schema);
        }
        catch (FileNotFoundException fnfe) {
            LOG.debug((Object)("can find schema file for annotation:" + fnfe.toString()));
            return null;
        }
        return schema;
    }

    private String getFileNameFromNS(String namespace) {
        LOG.debug((Object)("namespace:" + namespace));
        String prefix = "http://";
        String seperator = "/";
        String ns = namespace.substring(namespace.indexOf(prefix) + prefix.length(), namespace.length());
        StringTokenizer st = new StringTokenizer(ns, seperator);
        String fileName = SCHEMA_FILE_EXD;
        while (st.hasMoreTokens()) {
            if (!fileName.startsWith(".")) {
                fileName = "_" + fileName;
            }
            fileName = String.valueOf(st.nextToken()) + fileName;
        }
        LOG.debug((Object)("namespace:" + namespace + "|| schema fileName:" + fileName));
        fileName = SCHEMA_LOCATION + fileName;
        return fileName;
    }

    public boolean validateXML(InputStream xmlStream, InputStream schemaStream) throws Exception {
        return this.validateXML(xmlStream, new StreamSource(schemaStream));
    }

    public boolean validateXML(Document inputXmlDoc, Schema schema) throws Exception {
        Validator validator = schema.newValidator();
        this.errorHandler.reset();
        validator.setErrorHandler(this.errorHandler);
        DOMSource source = new DOMSource(inputXmlDoc);
        DOMResult result = new DOMResult();
        validator.validate(source, result);
        if (this.errorHandler.getErrorCount() > 0) {
            LOG.debug((Object)("XML file is not valid:" + this.errorHandler.getErrorMsg()));
            return false;
        }
        LOG.debug((Object)"it is valid xml");
        return true;
    }

    public boolean validateXML(InputStream inputXmlFile, Source schemaSource) throws Exception {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        Document doc = builder.parse(inputXmlFile);
        SchemaFactory schemaFactory = SchemaFactory.newInstance(W3C_XML_SCHEMA);
        Schema schema = schemaFactory.newSchema(schemaSource);
        return this.validateXML(doc, schema);
    }

    public String getErrorMessage() {
        return this.errorHandler.getErrorMsg();
    }
}

