/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.wizards;

import java.util.Map;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stp.sc.common.wizards.AbstractScWizard;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScWizardPage
extends WizardPage {
    protected AbstractScWizard parentWizard;
    private boolean doValidationAndUpdate;
    private String helpContextId;

    public AbstractScWizardPage(AbstractScWizard aParentWizard, String aPageName, String aHelpContextId) {
        super(aPageName);
        this.parentWizard = aParentWizard;
        this.helpContextId = aHelpContextId;
        this.setDoValidationAndUpdate(true);
        this.setPageComplete(false);
    }

    protected abstract boolean validateInputs();

    public abstract void initializeFromData(Map<String, Object> var1) throws Exception;

    public abstract void applyToData(Map<String, Object> var1) throws Exception;

    public final Map<String, Object> getWizardData() {
        return this.parentWizard == null ? null : this.parentWizard.getWizardData();
    }

    public final void initializeBeforeDisplay() throws Exception {
        this.setDoValidationAndUpdate(false);
        this.initializeFromData(this.parentWizard.getWizardData());
        this.setDoValidationAndUpdate(true);
        this.updatePageState();
    }

    public final void updatePageState() {
        if (this.isDoValidationAndUpdate()) {
            this.setErrorMessage(null);
            this.setMessage(null);
            this.setPageComplete(this.validateInputs());
        }
    }

    protected String getHelpContextId() {
        return this.helpContextId;
    }

    protected void setHelpContextId(String aHelpContextId) {
        this.helpContextId = aHelpContextId;
        this.applyHelpContextID();
    }

    protected void setControl(Control newControl) {
        super.setControl(newControl);
        this.applyHelpContextID();
    }

    private void applyHelpContextID() {
        if (this.getControl() != null && this.helpContextId != null && this.helpContextId.trim().length() > 0) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.helpContextId);
        }
    }

    public void setDoValidationAndUpdate(boolean validationAndUpdate) {
        this.doValidationAndUpdate = validationAndUpdate;
    }

    public boolean isDoValidationAndUpdate() {
        return this.doValidationAndUpdate;
    }

    public final class TableSelectionListener
    extends SelectionAdapter {
        private Table mTable;

        public TableSelectionListener(Table table) {
            this.mTable = table;
        }

        public void widgetSelected(SelectionEvent e) {
            this.mTable.deselect(this.mTable.getSelectionIndex());
        }
    }

    public final class UpdatePageStatusKeyPressedListener
    extends KeyAdapter {
        public void keyReleased(KeyEvent e) {
            AbstractScWizardPage.this.updatePageState();
        }
    }

    public final class UpdatePageStatusModifyListener
    implements ModifyListener {
        public void modifyText(ModifyEvent e) {
            AbstractScWizardPage.this.updatePageState();
        }
    }

    public final class UpdatePageStatusMouseListener
    extends MouseAdapter {
        public void mouseUp(MouseEvent e) {
            AbstractScWizardPage.this.updatePageState();
        }
    }

    public final class UpdatePageStatusSelectionListener
    extends SelectionAdapter {
        public void widgetSelected(SelectionEvent e) {
            AbstractScWizardPage.this.updatePageState();
        }
    }
}

