/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.generator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapter;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.properties.PropertyMerger;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.codegen.util.GIFEmitter;
import org.eclipse.emf.codegen.util.ImportManager;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.impl.SingletonAdapterImpl;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGeneratorAdapter
extends SingletonAdapterImpl
implements GeneratorAdapter {
    protected static final String MANIFEST_ENCODING = "UTF-8";
    protected static final String PROPERTIES_ENCODING = "ISO-8859-1";
    protected GeneratorAdapterFactory adapterFactory;
    protected Object generatingObject;
    protected String message;
    protected JETEmitter[] jetEmitters;
    protected GIFEmitter[] gifEmitters;
    protected ImportManager importManager;
    protected String lineDelimiter;
    protected URIConverter uriConverter;
    protected static final Class<?>[] OBJECT_ARGUMENT = new Class[]{Object.class};

    public AbstractGeneratorAdapter() {
    }

    public AbstractGeneratorAdapter(GeneratorAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    @Override
    public GeneratorAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    @Override
    public void setAdapterFactory(GeneratorAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public boolean isAdapterForType(Object type) {
        return type == this.adapterFactory;
    }

    @Override
    public Collection<?> getCanGenerateChildren(Object object, Object projectType) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Object getCanGenerateParent(Object object, Object projectType) {
        return null;
    }

    @Override
    public abstract boolean canGenerate(Object var1, Object var2);

    @Override
    public Collection<?> getGenerateChildren(Object object, Object projectType) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Object getGenerateParent(Object object, Object projectType) {
        return null;
    }

    @Override
    public final Diagnostic preGenerate(Object object, Object projectType) {
        try {
            this.generatingObject = object;
            if (this.getGenerator().getOptions().dynamicTemplates) {
                this.jetEmitters = null;
                this.gifEmitters = null;
            }
            Diagnostic diagnostic = this.doPreGenerate(object, projectType);
            return diagnostic;
        }
        finally {
            this.generatingObject = null;
        }
    }

    protected Diagnostic doPreGenerate(Object object, Object projectType) {
        return Diagnostic.OK_INSTANCE;
    }

    @Override
    public final Diagnostic generate(Object object, Object projectType, Monitor monitor) {
        try {
            if (this.canGenerate(object, projectType)) {
                this.generatingObject = object;
                this.message = null;
                Diagnostic diagnostic = this.doGenerate(object, projectType, monitor);
                return diagnostic;
            }
            Diagnostic diagnostic = Diagnostic.OK_INSTANCE;
            return diagnostic;
        }
        catch (Exception exception) {
            Diagnostic diagnostic = this.toDiagnostic(exception, this.message);
            return diagnostic;
        }
        finally {
            this.generatingObject = null;
            this.message = null;
            monitor.done();
        }
    }

    protected abstract Diagnostic doGenerate(Object var1, Object var2, Monitor var3) throws Exception;

    @Override
    public final Diagnostic postGenerate(Object object, Object projectType) {
        try {
            this.generatingObject = object;
            if (this.getGenerator().getOptions().dynamicTemplates) {
                this.jetEmitters = null;
                this.gifEmitters = null;
            }
            Diagnostic diagnostic = this.doPostGenerate(object, projectType);
            return diagnostic;
        }
        finally {
            this.generatingObject = null;
        }
    }

    protected Diagnostic doPostGenerate(Object object, Object projectType) {
        return Diagnostic.OK_INSTANCE;
    }

    protected Diagnostic toDiagnostic(Exception exception, String currentMessage) {
        CodeGenEcorePlugin.INSTANCE.log(exception);
        currentMessage = currentMessage != null ? CodeGenEcorePlugin.INSTANCE.getString("_UI_GenerateException_diagnostic", new Object[]{currentMessage}) : CodeGenEcorePlugin.INSTANCE.getString("_UI_GenericGenerateException_diagnostic");
        BasicDiagnostic diagnostic = new BasicDiagnostic("org.eclipse.emf.codegen.ecore", 0, currentMessage, null);
        diagnostic.add(BasicDiagnostic.toDiagnostic((Throwable)exception));
        return diagnostic;
    }

    protected Generator getGenerator() {
        return this.getAdapterFactory().getGenerator();
    }

    protected JETEmitter getJETEmitter(JETEmitterDescriptor[] jetEmitterDescriptors, int id) {
        JETEmitter jetEmitter;
        if (this.jetEmitters == null) {
            this.jetEmitters = new JETEmitter[jetEmitterDescriptors.length];
        }
        if ((jetEmitter = this.jetEmitters[id]) == null) {
            this.jetEmitters[id] = jetEmitter = this.createJETEmitter(jetEmitterDescriptors[id]);
        }
        return jetEmitter;
    }

    protected JETEmitter createJETEmitter(JETEmitterDescriptor jetEmitterDescriptor) {
        JETEmitter jetEmitter = new JETEmitter(this.getTemplatePath(), jetEmitterDescriptor.templatePathName, this.getClass().getClassLoader());
        try {
            this.setStaticTemplateClass(jetEmitter, jetEmitterDescriptor.className);
            this.addClasspathEntries(jetEmitter);
        }
        catch (JETException exception) {
            CodeGenEcorePlugin.INSTANCE.log((Object)exception);
        }
        return jetEmitter;
    }

    private String[] getTemplatePath() {
        String[] legacyPath = this.getGenerator().getOptions().templatePath;
        if (legacyPath != null) {
            return legacyPath;
        }
        ArrayList<String> result = new ArrayList<String>(this.getUserTemplatePath());
        result.addAll(this.getBaseTemplatePath());
        return result.toArray(new String[result.size()]);
    }

    protected List<String> getUserTemplatePath() {
        return Collections.emptyList();
    }

    private List<String> getBaseTemplatePath() {
        ArrayList<String> result = new ArrayList<String>();
        this.addBaseTemplatePathEntries(result);
        return result;
    }

    protected void addBaseTemplatePathEntries(List<String> templatePath) {
    }

    protected void setStaticTemplateClass(JETEmitter jetEmitter, String className) {
        if (!this.getGenerator().getOptions().dynamicTemplates) {
            try {
                Class<?> templateClass = this.getClass().getClassLoader().loadClass(className);
                Method emitterMethod = templateClass.getDeclaredMethod("generate", OBJECT_ARGUMENT);
                jetEmitter.setMethod(emitterMethod);
            }
            catch (Exception exception) {}
        }
    }

    protected void addClasspathEntries(JETEmitter jetEmitter) throws JETException {
        if (this.getGenerator().getOptions().templateClasspath != null) {
            for (String additionalClasspathEntry : this.getGenerator().getOptions().templateClasspath) {
                int index = additionalClasspathEntry.indexOf(61);
                if (index == -1) {
                    jetEmitter.addVariable(additionalClasspathEntry, additionalClasspathEntry);
                    continue;
                }
                jetEmitter.addVariable(additionalClasspathEntry.substring(0, index), additionalClasspathEntry.substring(index + 1));
            }
        }
    }

    protected GIFEmitter getGIFEmitter(String[] inputPathNames, int id) {
        GIFEmitter gifEmitter;
        if (this.gifEmitters == null) {
            this.gifEmitters = new GIFEmitter[inputPathNames.length];
        }
        if ((gifEmitter = this.gifEmitters[id]) == null) {
            this.gifEmitters[id] = gifEmitter = this.createGIFEmitter(inputPathNames[id]);
        }
        return gifEmitter;
    }

    protected GIFEmitter createGIFEmitter(String inputPathName) {
        return new GIFEmitter(JETCompiler.find((String[])this.getTemplatePath(), (String)inputPathName));
    }

    protected void generateText(String targetPathName, JETEmitter jetEmitter, Object[] arguments, boolean overwrite, String encoding, Monitor monitor) {
        try {
            try {
                monitor.beginTask("", 3);
                URI targetFile = this.toURI(targetPathName);
                monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingFile_message", new Object[]{targetFile}));
                URI targetDirectory = targetFile.trimSegments(1);
                this.ensureContainerExists(targetDirectory, this.createMonitor(monitor, 1));
                boolean exists = this.exists(targetFile);
                if (!exists || overwrite) {
                    if (arguments == null) {
                        arguments = new Object[]{this.generatingObject};
                    }
                    this.setLineDelimiter(this.getLineDelimiter(targetFile, encoding));
                    String emitterResult = jetEmitter.generate(this.createMonitor(monitor, 1), arguments, this.getLineDelimiter());
                    if (PROPERTIES_ENCODING.equals(encoding)) {
                        emitterResult = CodeGenUtil.unicodeEscapeEncode((String)emitterResult);
                    }
                    if (encoding == null) {
                        encoding = this.getEncoding(targetFile);
                    }
                    boolean changed = true;
                    if (exists) {
                        monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_ExaminingOld_message", new Object[]{targetFile}));
                        String oldContents = this.getContents(targetFile, encoding);
                        boolean bl = changed = !emitterResult.equals(oldContents);
                    }
                    if (changed) {
                        boolean redirect;
                        byte[] bytes = encoding == null ? emitterResult.toString().getBytes() : emitterResult.toString().getBytes(encoding);
                        String redirection = this.getGenerator().getOptions().redirectionPattern;
                        boolean bl = redirect = redirection != null && redirection.indexOf("{0}") != -1;
                        if (redirect) {
                            String baseName = MessageFormat.format(redirection, targetFile.lastSegment());
                            targetFile = targetDirectory.appendSegment(baseName);
                            monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingAlternate_message", new Object[]{targetFile}));
                        }
                        if (this.isReadOnly(targetFile)) {
                            if (this.getGenerator().getOptions().forceOverwrite) {
                                this.validateEdit(targetFile, this.createMonitor(monitor, 1));
                                this.setWriteable(targetFile);
                            } else {
                                targetFile = targetDirectory.appendSegment("." + targetFile.lastSegment() + ".new");
                                monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingDefaultAlternate_message", new Object[]{targetFile}));
                            }
                        }
                        OutputStream outputStream = this.createOutputStream(targetFile);
                        outputStream.write(bytes);
                        outputStream.close();
                    }
                }
            }
            catch (Exception exception) {
                CodeGenEcorePlugin.INSTANCE.log(exception);
                this.setLineDelimiter(null);
                monitor.done();
            }
        }
        finally {
            this.setLineDelimiter(null);
            monitor.done();
        }
    }

    protected void generateProperties(String targetPathName, JETEmitter jetEmitter, Object[] arguments, Monitor monitor) {
        try {
            try {
                monitor.beginTask("", 3);
                URI targetFile = this.toURI(targetPathName);
                monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingFile_message", new Object[]{targetFile}));
                URI targetDirectory = targetFile.trimSegments(1);
                this.ensureContainerExists(targetDirectory, this.createMonitor(monitor, 1));
                boolean changed = false;
                if (arguments == null) {
                    arguments = new Object[]{this.generatingObject};
                }
                this.setLineDelimiter(this.getLineDelimiter(targetFile, PROPERTIES_ENCODING));
                String emitterResult = CodeGenUtil.unicodeEscapeEncode((String)jetEmitter.generate(this.createMonitor(monitor, 1), arguments, this.getLineDelimiter()));
                byte[] bytes = emitterResult.toString().getBytes(PROPERTIES_ENCODING);
                if (this.exists(targetFile)) {
                    PropertyMerger propertyMerger = new PropertyMerger();
                    propertyMerger.setSourceProperties(emitterResult);
                    monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_ExaminingOld_message", new Object[]{targetFile}));
                    String oldProperties = propertyMerger.createPropertiesForInputStream(this.createInputStream(targetFile));
                    propertyMerger.setTargetProperties(oldProperties);
                    monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_PreparingNew_message", new Object[]{targetFile}));
                    propertyMerger.merge();
                    String mergedResult = propertyMerger.getTargetProperties();
                    boolean bl = changed = !mergedResult.equals(oldProperties);
                    if (changed) {
                        if (this.isReadOnly(targetFile) && this.validateEdit(targetFile, this.createMonitor(monitor, 1))) {
                            propertyMerger.setTargetProperties(propertyMerger.createPropertiesForInputStream(this.createInputStream(targetFile)));
                            propertyMerger.merge();
                            mergedResult = propertyMerger.getTargetProperties();
                        }
                        bytes = mergedResult.getBytes(PROPERTIES_ENCODING);
                    }
                } else {
                    changed = true;
                    monitor.worked(1);
                }
                if (changed) {
                    boolean redirect;
                    String redirection = this.getGenerator().getOptions().redirectionPattern;
                    boolean bl = redirect = redirection != null && redirection.indexOf("{0}") != -1;
                    if (redirect) {
                        String baseName = MessageFormat.format(redirection, targetFile.lastSegment());
                        targetFile = targetDirectory.appendSegment(baseName);
                        monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingAlternate_message", new Object[]{targetFile}));
                    }
                    if (this.isReadOnly(targetFile)) {
                        if (this.getGenerator().getOptions().forceOverwrite) {
                            this.setWriteable(targetFile);
                        } else {
                            targetFile = targetDirectory.appendSegment("." + targetFile.lastSegment() + ".new");
                            monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingDefaultAlternate_message", new Object[]{targetFile}));
                        }
                    }
                    OutputStream outputStream = this.createOutputStream(targetFile);
                    outputStream.write(bytes);
                    outputStream.close();
                }
            }
            catch (Exception exception) {
                CodeGenEcorePlugin.INSTANCE.log(exception);
                this.setLineDelimiter(null);
                monitor.done();
            }
        }
        finally {
            this.setLineDelimiter(null);
            monitor.done();
        }
    }

    protected void generateGIF(String targetPathName, GIFEmitter gifEmitter, String parentKey, String childKey, boolean overwrite, Monitor monitor) {
        try {
            try {
                monitor.beginTask("", 3);
                URI targetFile = this.toURI(targetPathName);
                monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingImage_message", new Object[]{targetFile}));
                URI targetDirectory = targetFile.trimSegments(1);
                this.ensureContainerExists(targetDirectory, this.createMonitor(monitor, 1));
                boolean exists = this.exists(targetFile);
                if (!exists || overwrite) {
                    boolean redirect;
                    byte[] emitterResult = gifEmitter.generateGIF(parentKey, childKey);
                    monitor.worked(1);
                    String redirection = this.getGenerator().getOptions().redirectionPattern;
                    boolean bl = redirect = redirection != null && redirection.indexOf("{0}") != -1;
                    if (redirect) {
                        String baseName = MessageFormat.format(redirection, targetFile.lastSegment());
                        targetFile = targetDirectory.appendSegment(baseName);
                        monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingAlternate_message", new Object[]{targetFile}));
                    }
                    if (this.isReadOnly(targetFile)) {
                        if (this.getGenerator().getOptions().forceOverwrite) {
                            this.validateEdit(targetFile, this.createMonitor(monitor, 1));
                            this.setWriteable(targetFile);
                        } else {
                            targetFile = targetDirectory.appendSegment("." + targetFile.lastSegment() + ".new");
                            monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingDefaultAlternate_message", new Object[]{targetFile}));
                        }
                    }
                    OutputStream outputStream = this.createOutputStream(targetFile);
                    outputStream.write(emitterResult);
                    outputStream.close();
                }
            }
            catch (Exception exception) {
                CodeGenEcorePlugin.INSTANCE.log(exception);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void generateJava(String targetPath, String packageName, String className, JETEmitter jetEmitter, Object[] arguments, Monitor monitor) {
        try {
            try {
                monitor.beginTask("", 4);
                URI targetDirectory = this.toURI(targetPath).appendSegments(packageName.split("\\."));
                URI targetFile = targetDirectory.appendSegment(String.valueOf(className) + ".java");
                monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_Generating_message", new Object[]{targetFile}));
                this.ensureContainerExists(targetDirectory, this.createMonitor(monitor, 1));
                if (arguments == null) {
                    arguments = new Object[]{this.generatingObject};
                }
                this.createImportManager(packageName, className);
                this.setLineDelimiter(this.getLineDelimiter(targetFile, this.getEncoding(targetFile)));
                String emitterResult = jetEmitter.generate(this.createMonitor(monitor, 1), arguments, this.getLineDelimiter());
                boolean changed = true;
                String newContents = emitterResult;
                boolean targetExists = this.exists(targetFile);
                JControlModel jControlModel = this.getGenerator().getJControlModel();
                boolean mergeSuccessful = jControlModel.canMerge();
                if (mergeSuccessful) {
                    JMerger jMerger = new JMerger(jControlModel);
                    jMerger.setFixInterfaceBrace(jControlModel.getFacadeHelper().fixInterfaceBrace());
                    try {
                        jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForContents(emitterResult));
                    }
                    catch (RuntimeException runtimeException) {
                        if (targetExists) {
                            throw runtimeException;
                        }
                        mergeSuccessful = false;
                    }
                    if (mergeSuccessful) {
                        Object codeFormatter;
                        Object object = codeFormatter = this.getGenerator().getOptions().codeFormatting ? this.createCodeFormatter(this.getGenerator().getOptions().codeFormatterOptions, targetFile) : null;
                        if (targetExists) {
                            monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_ExaminingOld_message", new Object[]{targetFile}));
                            jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream(this.createInputStream(targetFile), this.getEncoding(targetFile)));
                            String oldContents = jMerger.getTargetCompilationUnitContents();
                            monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_PreparingNew_message", new Object[]{targetFile}));
                            jMerger.merge();
                            newContents = this.formatCode(jMerger.getTargetCompilationUnitContents(), codeFormatter);
                            boolean bl = changed = !oldContents.equals(newContents);
                            if (changed && this.isReadOnly(targetFile) && this.validateEdit(targetFile, this.createMonitor(monitor, 1))) {
                                jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream(this.createInputStream(targetFile), this.getEncoding(targetFile)));
                                jMerger.remerge();
                                newContents = this.formatCode(jMerger.getTargetCompilationUnitContents(), codeFormatter);
                            }
                        } else {
                            changed = true;
                            monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_PreparingNew_message", new Object[]{targetFile}));
                            jMerger.merge();
                            newContents = this.formatCode(jMerger.getTargetCompilationUnitContents(), codeFormatter);
                        }
                        if (jControlModel.getFacadeHelper() != null) {
                            jControlModel.getFacadeHelper().reset();
                        }
                    }
                }
                if (!mergeSuccessful) {
                    newContents = CodeGenUtil.convertFormat((String)jControlModel.getLeadingTabReplacement(), (boolean)jControlModel.convertToStandardBraceStyle(), (String)emitterResult);
                    if (targetExists) {
                        monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_ExaminingOld_message", new Object[]{targetFile}));
                        String oldContents = this.getContents(targetFile, null);
                        changed = !oldContents.equals(newContents);
                    } else {
                        changed = true;
                    }
                }
                monitor.worked(1);
                if (changed) {
                    boolean redirect;
                    String encoding = this.getEncoding(targetFile);
                    byte[] bytes = encoding == null ? newContents.getBytes() : newContents.getBytes(encoding);
                    String redirection = this.getGenerator().getOptions().redirectionPattern;
                    boolean bl = redirect = redirection != null && redirection.indexOf("{0}") != -1;
                    if (redirect) {
                        String baseName = MessageFormat.format(redirection, String.valueOf(className) + ".java");
                        targetFile = targetDirectory.appendSegment(baseName);
                        monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingAlternate_message", new Object[]{targetFile}));
                    }
                    if (this.isReadOnly(targetFile)) {
                        if (this.getGenerator().getOptions().forceOverwrite) {
                            this.setWriteable(targetFile);
                        } else {
                            targetFile = targetDirectory.appendSegment("." + className + ".java.new");
                            monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingDefaultAlternate_message", new Object[]{targetFile}));
                        }
                    }
                    OutputStream outputStream = this.createOutputStream(targetFile);
                    outputStream.write(bytes);
                    outputStream.close();
                }
            }
            catch (Exception e) {
                throw e instanceof RuntimeException ? (RuntimeException)e : new WrappedException(e);
            }
        }
        finally {
            this.clearImportManager();
            this.setLineDelimiter(null);
            monitor.done();
        }
    }

    protected URI toURI(String pathName) {
        return URI.createURI((String)pathName);
    }

    protected URI toPlatformResourceURI(URI uri) {
        return URI.createPlatformResourceURI((String)uri.toString(), (boolean)true);
    }

    protected Monitor createMonitor(Monitor monitor, int ticks) {
        return CodeGenUtil.createMonitor((Monitor)monitor, (int)ticks);
    }

    protected void createImportManager(String packageName, String className) {
        this.importManager = new ImportManager(packageName);
        this.importManager.addMasterImport(packageName, className);
    }

    protected void clearImportManager() {
        this.importManager = null;
    }

    protected ImportManager getImportManager() {
        return this.importManager;
    }

    protected void setLineDelimiter(String lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }

    protected String getLineDelimiter() {
        return this.lineDelimiter;
    }

    protected void ensureProjectExists(String workspacePath, Object object, Object projectType, boolean force, Monitor monitor) {
        try {
            if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                EclipseHelper.ensureProjectExists(workspacePath, object, projectType, force, monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void ensureContainerExists(URI workspacePath, Monitor monitor) {
        try {
            if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                EclipseHelper.ensureContainerExists(workspacePath.toString(), monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected URIConverter getURIConverter() {
        URIConverter result;
        ResourceSet resourceSet = this.getGenerator().getOptions().resourceSet;
        URIConverter uRIConverter = result = resourceSet != null ? resourceSet.getURIConverter() : null;
        if (result != null) {
            return result;
        }
        if (this.uriConverter == null) {
            this.uriConverter = new ExtensibleURIConverterImpl();
        }
        return this.uriConverter;
    }

    /*
     * Exception decompiling
     */
    public String getLineDelimiter(URI workspacePath, String encoding) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 23[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean exists(URI workspacePath) {
        return this.getURIConverter().exists(this.toPlatformResourceURI(workspacePath), null);
    }

    protected boolean isReadOnly(URI workspacePath) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            return EclipseHelper.isReadOnly(workspacePath.toString());
        }
        URI uri = this.getURIConverter().normalize(this.toPlatformResourceURI(workspacePath));
        if ("file".equalsIgnoreCase(uri.scheme())) {
            File file = new File(uri.toFileString());
            return file.exists() && !file.canWrite();
        }
        return false;
    }

    protected void setWriteable(URI workspacePath) throws Exception {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            EclipseHelper.setWriteable(workspacePath.toString());
            return;
        }
        URI uri = this.getURIConverter().normalize(this.toPlatformResourceURI(workspacePath));
        if ("file".equalsIgnoreCase(uri.scheme())) {
            new File(uri.toFileString()).delete();
        }
    }

    protected boolean validateEdit(URI workspacePath, Monitor monitor) {
        try {
            if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                boolean bl = EclipseHelper.validateEdit(workspacePath.toString(), monitor);
                return bl;
            }
            return false;
        }
        finally {
            monitor.done();
        }
    }

    protected InputStream createInputStream(URI workspacePath) throws Exception {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            return EclipseHelper.createInputStream(workspacePath.toString());
        }
        return this.getURIConverter().createInputStream(this.toPlatformResourceURI(workspacePath), null);
    }

    protected OutputStream createOutputStream(URI workspacePath) throws Exception {
        return this.getURIConverter().createOutputStream(this.toPlatformResourceURI(workspacePath), null);
    }

    protected String getContents(URI workspacePath, String encoding) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.createInputStream(workspacePath));
        byte[] input = new byte[bufferedInputStream.available()];
        bufferedInputStream.read(input);
        bufferedInputStream.close();
        return encoding == null ? new String(input) : new String(input, encoding);
    }

    protected String getEncoding(URI workspacePath) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            return EclipseHelper.getEncoding(workspacePath.toString());
        }
        return null;
    }

    protected Object createCodeFormatter(Map<?, ?> options, URI workspacePath) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            return EclipseHelper.createCodeFormatter(options, workspacePath.toString());
        }
        return null;
    }

    protected String formatCode(String contents, Object codeFormatter) {
        return EMFPlugin.IS_ECLIPSE_RUNNING ? EclipseHelper.formatCode(contents, codeFormatter) : contents;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EclipseHelper {
        private EclipseHelper() {
        }

        public static boolean ensureProjectExists(String workspacePath, Object object, Object projectType, boolean force, Monitor monitor) {
            try {
                Path path = new Path(workspacePath);
                if (path.isAbsolute()) {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    IProject project = workspace.getRoot().getProject(path.segment(0));
                    if (!project.exists() || force) {
                        IPath javaSource = path.uptoSegment(1).append("src");
                        org.eclipse.emf.codegen.ecore.Generator.createEMFProject(javaSource, null, Collections.<IProject>emptyList(), monitor, org.eclipse.emf.codegen.ecore.Generator.EMF_PLUGIN_PROJECT_STYLE);
                    }
                    return workspace.getRoot().getProject(path.segment(0)).exists();
                }
            }
            catch (Exception exception) {
                CodeGenEcorePlugin.INSTANCE.log(exception);
            }
            return false;
        }

        public static boolean ensureContainerExists(String workspacePath, Monitor monitor) {
            IProject container;
            Path path;
            block10: {
                path = new Path(workspacePath);
                container = null;
                try {
                    try {
                        IWorkspace workspace;
                        IProject project;
                        monitor.beginTask("", path.segmentCount() + 1);
                        monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_OpeningFolder_message", new Object[]{path}));
                        if (path.isAbsolute() && (project = (workspace = ResourcesPlugin.getWorkspace()).getRoot().getProject(path.segment(0))).exists()) {
                            if (!project.isOpen()) {
                                project.open(BasicMonitor.toIProgressMonitor((Monitor)CodeGenUtil.createMonitor((Monitor)monitor, (int)1)));
                            } else {
                                monitor.worked(1);
                            }
                            container = project;
                            int i = 1;
                            int length = path.segmentCount();
                            while (i < length) {
                                IFolder folder = container.getFolder((IPath)new Path(path.segment(i)));
                                if (!folder.exists()) {
                                    folder.create(false, true, BasicMonitor.toIProgressMonitor((Monitor)CodeGenUtil.createMonitor((Monitor)monitor, (int)1)));
                                }
                                container = folder;
                                ++i;
                            }
                        }
                    }
                    catch (Exception exception) {
                        CodeGenEcorePlugin.INSTANCE.log(exception);
                        monitor.done();
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
            return container != null && container.getFullPath().equals((Object)path);
        }

        public static String getLineDelimiter(String workspacePath) {
            return Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", System.getProperty("line.separator"), new IScopeContext[]{new ProjectScope(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePath)).getProject()), new InstanceScope()});
        }

        public static boolean exists(String workspacePath) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePath)).exists();
        }

        public static boolean isReadOnly(String workspacePath) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePath)).isReadOnly();
        }

        public static void setWriteable(String workspacePath) throws Exception {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePath));
            ResourceAttributes resourceAttributes = file.getResourceAttributes();
            if (resourceAttributes != null) {
                resourceAttributes.setReadOnly(false);
                file.setResourceAttributes(resourceAttributes);
            }
        }

        public static boolean validateEdit(String workspacePath, Monitor monitor) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePath));
            return file.getWorkspace().validateEdit(new IFile[]{file}, (Object)monitor).isOK();
        }

        public static InputStream createInputStream(String workspacePath) throws Exception {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePath)).getContents(true);
        }

        public static String getEncoding(String workspacePath) {
            try {
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePath)).getCharset();
            }
            catch (CoreException coreException) {
                return null;
            }
        }

        public static Object createCodeFormatter(Map<?, ?> options, String workspacePath) {
            IJavaProject javaProject;
            IProject project;
            if (options == null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(new Path(workspacePath).segment(0))) != null && (javaProject = JavaCore.create((IProject)project)) != null) {
                options = javaProject.getOptions(true);
            }
            return ToolFactory.createCodeFormatter(options);
        }

        public static String formatCode(String contents, Object codeFormatter) {
            Document doc;
            TextEdit edit;
            if (codeFormatter instanceof CodeFormatter && (edit = ((CodeFormatter)codeFormatter).format(8, (doc = new Document(contents)).get(), 0, doc.get().length(), 0, null)) != null) {
                try {
                    edit.apply((IDocument)doc);
                    contents = doc.get();
                }
                catch (Exception exception) {
                    CodeGenEcorePlugin.INSTANCE.log(exception);
                }
            }
            return contents;
        }
    }

    protected static class JETEmitterDescriptor {
        public String templatePathName;
        public String className;

        public JETEmitterDescriptor(String templatePathName, String className) {
            this.templatePathName = templatePathName;
            this.className = className;
        }
    }
}

