/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementType;
import org.eclipse.gmf.runtime.emf.type.core.IContainerDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IMetamodelType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelper;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;

public class SpecializationType
extends ElementType
implements ISpecializationType {
    private final IContainerDescriptor containerDescriptor;
    private IElementMatcher matcher;
    private final IElementType[] specializedTypes;
    private String[] specializedTypeIds;
    private final IEditHelperAdvice editHelperAdvice;
    private IMetamodelType metamodelType;

    public SpecializationType(String id, URL iconURL, String displayName, IElementType[] elementTypes, IElementMatcher matcher, IContainerDescriptor descriptor, IEditHelperAdvice editHelperAdvice) {
        super(id, iconURL, displayName);
        this.containerDescriptor = descriptor;
        this.matcher = matcher;
        this.specializedTypes = elementTypes;
        this.editHelperAdvice = editHelperAdvice;
    }

    public SpecializationType(ISpecializationTypeDescriptor descriptor) {
        this(descriptor.getId(), descriptor.getIconURL(), descriptor.getName(), descriptor.getSpecializedTypes(), descriptor.getMatcher(), descriptor.getContainerDescriptor(), descriptor.getEditHelperAdvice());
    }

    public IContainerDescriptor getEContainerDescriptor() {
        return this.containerDescriptor;
    }

    public IElementMatcher getMatcher() {
        return this.matcher;
    }

    public IElementType[] getSpecializedTypes() {
        return this.specializedTypes;
    }

    public String[] getSpecializedTypeIds() {
        if (this.specializedTypeIds == null && this.specializedTypes != null) {
            this.specializedTypeIds = new String[this.specializedTypes.length];
            int i = 0;
            while (i < this.specializedTypes.length) {
                this.specializedTypeIds[i] = this.specializedTypes[i].getId();
                ++i;
            }
        }
        return this.specializedTypeIds;
    }

    public boolean isSpecializationOf(IElementType type) {
        String[] ids = this.getSpecializedTypeIds();
        int i = 0;
        while (i < ids.length) {
            if (type.getId().equals(ids[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IEditHelperAdvice getEditHelperAdvice() {
        return this.editHelperAdvice;
    }

    public EClass getEClass() {
        return this.getMetamodelType().getEClass();
    }

    public IMetamodelType getMetamodelType() {
        if (this.metamodelType == null) {
            int i = 0;
            while (i < this.getSpecializedTypes().length) {
                IElementType nextElementType = this.getSpecializedTypes()[i];
                if (nextElementType instanceof IMetamodelType) {
                    this.metamodelType = (IMetamodelType)nextElementType;
                    break;
                }
                if (nextElementType instanceof ISpecializationType) {
                    this.metamodelType = ((ISpecializationType)nextElementType).getMetamodelType();
                    break;
                }
                ++i;
            }
        }
        return this.metamodelType;
    }

    public IEditHelper getEditHelper() {
        return this.getMetamodelType().getEditHelper();
    }

    public ICommand getEditCommand(IEditCommandRequest request) {
        return this.getEditHelper().getEditCommand(request);
    }

    public IElementType[] getAllSuperTypes() {
        if (super.getAllSuperTypes() == null) {
            ArrayList<IMetamodelType> result = new ArrayList<IMetamodelType>();
            IElementType[] metamodelSupertypes = this.getMetamodelType().getAllSuperTypes();
            result.addAll((Collection)Arrays.asList(metamodelSupertypes));
            result.add(this.getMetamodelType());
            result.addAll(this.getSpecializationSupertypes(this));
            this.setAllSupertypes(result.toArray(new IElementType[0]));
        }
        return super.getAllSuperTypes();
    }

    private List getSpecializationSupertypes(ISpecializationType specializationType) {
        ArrayList<IElementType> result = new ArrayList<IElementType>();
        IElementType[] specializationSupertypes = specializationType.getSpecializedTypes();
        int i = 0;
        while (i < specializationSupertypes.length) {
            IElementType nextType = specializationSupertypes[i];
            if (nextType instanceof ISpecializationType) {
                result.addAll(this.getSpecializationSupertypes((ISpecializationType)nextType));
                result.add(nextType);
            }
            ++i;
        }
        return result;
    }

    public String toString() {
        return "SpecializationType[" + this.getId() + "]";
    }
}

