/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.wst.common.project.facet.core.IConstraint;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.IVersionExpr;
import org.eclipse.wst.common.project.facet.core.internal.Constraint;
import org.eclipse.wst.common.project.facet.ui.internal.ConstraintDisplayDialog;
import org.eclipse.wst.common.project.facet.ui.internal.DetailsPanel;
import org.eclipse.wst.common.project.facet.ui.internal.FacetsSelectionPanel;
import org.eclipse.wst.common.project.facet.ui.internal.util.EnhancedHyperlink;
import org.eclipse.wst.common.project.facet.ui.internal.util.GridLayoutUtil;
import org.eclipse.wst.common.project.facet.ui.internal.util.ImageWithTextComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacetDetailsPanel
extends Composite {
    public FacetDetailsPanel(Composite parent, FacetsSelectionPanel facetsSelectionPanel, IProjectFacetVersion facet) {
        super(parent, 0);
        this.setLayout((Layout)GridLayoutUtil.glmargins(GridLayoutUtil.gl(1), 0, 0));
        IFacetedProjectWorkingCopy fpjwc = facetsSelectionPanel.getFacetedProjectWorkingCopy();
        ImageWithTextComposite header = new ImageWithTextComposite(this);
        header.setLayoutData(GridLayoutUtil.gdhfill());
        header.setImage(facetsSelectionPanel.getImage(facet.getProjectFacet(), false));
        header.setFont(JFaceResources.getFontRegistry().get(DetailsPanel.HEADER_FONT));
        header.setText(facet.toString());
        Label separator = new Label((Composite)this, 258);
        separator.setLayoutData((Object)GridLayoutUtil.gdhfill());
        Label descLabel = new Label((Composite)this, 64);
        descLabel.setLayoutData((Object)GridLayoutUtil.gdhfill());
        descLabel.setText(facet.getProjectFacet().getDescription());
        final IConstraint prunedConstraint = Constraint.pruneConstraint((IProjectFacetVersion)facet, (Set)fpjwc.getFixedProjectFacets());
        if (prunedConstraint != null) {
            List<IConstraint> requirements = FacetDetailsPanel.getRequiresConstraints(prunedConstraint);
            if (requirements != null) {
                Label requiredFacetsLabel = new Label((Composite)this, 0);
                requiredFacetsLabel.setLayoutData((Object)GridLayoutUtil.gdvindent(GridLayoutUtil.gdhfill(), 5));
                requiredFacetsLabel.setText(Resources.requiredFacetsLabel);
                Composite requiredFacetsComposite = new Composite((Composite)this, 0);
                requiredFacetsComposite.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdvindent(GridLayoutUtil.gdfill(), 5), 5));
                requiredFacetsComposite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glmargins(GridLayoutUtil.gl(1), 0, 0), 0, 3));
                for (IConstraint requirement : requirements) {
                    IProjectFacet f = (IProjectFacet)requirement.getOperand(0);
                    StringBuilder text = new StringBuilder();
                    IVersionExpr vexpr = (IVersionExpr)requirement.getOperand(1);
                    text.append(f.getLabel());
                    if (!vexpr.toString().equals("*")) {
                        text.append(' ');
                        text.append(vexpr.toDisplayString());
                    }
                    ImageWithTextComposite fLabel = new ImageWithTextComposite(requiredFacetsComposite);
                    fLabel.setLayoutData(GridLayoutUtil.gdhfill());
                    fLabel.setImage(facetsSelectionPanel.getImage(f, false));
                    fLabel.setText(text.toString());
                }
            } else {
                EnhancedHyperlink showConstraintsLink = new EnhancedHyperlink(this, 0);
                showConstraintsLink.setText(Resources.showConstraintsLink);
                showConstraintsLink.setLayoutData(GridLayoutUtil.gdvindent(GridLayoutUtil.gd(), 4));
                showConstraintsLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        FacetDetailsPanel.this.handleShowConstraintsLinkActivated(prunedConstraint);
                    }
                });
            }
        }
    }

    private static List<IConstraint> getRequiresConstraints(IConstraint constraint) {
        List<IConstraint> requirements = FacetDetailsPanel.getRequiresConstraints(constraint, new ArrayList<IConstraint>());
        if (requirements != null) {
            Collections.sort(requirements, new Comparator<IConstraint>(){

                @Override
                public int compare(IConstraint x, IConstraint y) {
                    String xLabel = ((IProjectFacet)x.getOperand(0)).getLabel();
                    String yLabel = ((IProjectFacet)y.getOperand(0)).getLabel();
                    return xLabel.compareTo(yLabel);
                }
            });
        }
        return requirements;
    }

    private static List<IConstraint> getRequiresConstraints(IConstraint constraint, List<IConstraint> requirements) {
        if (constraint.getType() == IConstraint.Type.AND) {
            for (Object operand : constraint.getOperands()) {
                if (FacetDetailsPanel.getRequiresConstraints((IConstraint)operand, requirements) != null) continue;
                return null;
            }
            return requirements;
        }
        if (constraint.getType() == IConstraint.Type.REQUIRES) {
            requirements.add(constraint);
            return requirements;
        }
        return null;
    }

    private void handleShowConstraintsLinkActivated(IConstraint constraint) {
        ConstraintDisplayDialog dialog = new ConstraintDisplayDialog(this.getShell(), null, constraint);
        dialog.open();
    }

    private static final class Resources
    extends NLS {
        public static String showConstraintsLink;
        public static String requiredFacetsLabel;

        static {
            Resources.initializeMessages((String)FacetDetailsPanel.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

