/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.common.project.facet.core.ICategory;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetsChangedEvent;
import org.eclipse.wst.common.project.facet.ui.IDecorationsProvider;
import org.eclipse.wst.common.project.facet.ui.ModifyFacetedProjectWizard;
import org.eclipse.wst.common.project.facet.ui.internal.DetailsPanel;
import org.eclipse.wst.common.project.facet.ui.internal.FacetUiPlugin;
import org.eclipse.wst.common.project.facet.ui.internal.RuntimesPanel;
import org.eclipse.wst.common.project.facet.ui.internal.SavePresetDialog;
import org.eclipse.wst.common.project.facet.ui.internal.util.BasicToolTip;
import org.eclipse.wst.common.project.facet.ui.internal.util.GridLayoutUtil;
import org.eclipse.wst.common.project.facet.ui.internal.util.HeaderToolTip;
import org.eclipse.wst.common.project.facet.ui.internal.util.SwtUtil;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacetsSelectionPanel
extends Composite
implements ISelectionProvider {
    private static final String FACET_COLUMN = "facet";
    private static final String VERSION_COLUMN = "version";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String CW_FACET = "cw.facet";
    private static final String CW_VERSION = "cw.version";
    private static final String SASH1W1 = "sash.1.weight.1";
    private static final String SASH1W2 = "sash.1.weight.2";
    private static final String SASH2W1 = "sash.2.weight.1";
    private static final String SASH2W2 = "sash.2.weight.2";
    private static final String IMG_ERROR = "##error##";
    private static final String IMG_WARNING = "##warning##";
    private static final String IMG_DOWN_ARROW = "##down-arrow##";
    private final Composite topComposite;
    private final SashForm sform1;
    private final SashForm sform2;
    private final Label presetsLabel;
    private final Combo presetsCombo;
    private final Button savePresetButton;
    private final Button deletePresetButton;
    private final CheckboxTreeViewer treeViewer;
    private final Tree tree;
    private final TreeColumn colFacet;
    private final TreeColumn colVersion;
    private final ComboBoxCellEditor ceditor;
    private final FixedFacetToolTip fixedFacetToolTip;
    private final TableViewer problemsView;
    private final TabItem detailsTabItem;
    private final DetailsPanel detailsPanel;
    private final TabItem runtimesTabItem;
    private final RuntimesPanel runtimesPanel;
    private final IDialogSettings settings;
    private boolean showToolTips;
    private final IFacetedProjectWorkingCopy fpjwc;
    private final List<IFacetedProjectListener> registeredWorkingCopyListeners;
    private final Map<IProjectFacet, IProjectFacetVersion> selectedVersions;
    private final List<ISelectionChangedListener> selectionListeners;
    private Object selection;
    private final ImageRegistry imageRegistry;

    public FacetsSelectionPanel(Composite parent, IFacetedProjectWorkingCopy fpjwc) {
        super(parent, 0);
        this.fpjwc = fpjwc;
        this.registeredWorkingCopyListeners = new ArrayList<IFacetedProjectListener>();
        this.selectedVersions = new HashMap<IProjectFacet, IProjectFacetVersion>();
        this.selection = null;
        this.selectionListeners = new ArrayList<ISelectionChangedListener>();
        this.showToolTips = false;
        this.imageRegistry = new ImageRegistry();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.common.project.facet.ui");
        URL url = bundle.getEntry("images/error.gif");
        this.imageRegistry.put(IMG_ERROR, ImageDescriptor.createFromURL((URL)url));
        url = bundle.getEntry("images/warning.gif");
        this.imageRegistry.put(IMG_WARNING, ImageDescriptor.createFromURL((URL)url));
        url = bundle.getEntry("images/down-arrow.gif");
        this.imageRegistry.put(IMG_DOWN_ARROW, ImageDescriptor.createFromURL((URL)url));
        IDialogSettings root = FacetUiPlugin.getInstance().getDialogSettings();
        IDialogSettings temp = root.getSection(((Object)((Object)this)).getClass().getName());
        if (temp == null) {
            temp = root.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        if (temp.get(WIDTH) == null) {
            temp.put(WIDTH, 600);
        }
        if (temp.get(HEIGHT) == null) {
            temp.put(HEIGHT, 300);
        }
        if (temp.get(SASH1W1) == null) {
            temp.put(SASH1W1, 60);
        }
        if (temp.get(SASH1W2) == null) {
            temp.put(SASH1W2, 40);
        }
        if (temp.get(SASH2W1) == null) {
            temp.put(SASH2W1, 70);
        }
        if (temp.get(SASH2W2) == null) {
            temp.put(SASH2W2, 30);
        }
        this.settings = temp;
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        GridData topgd = GridLayoutUtil.gdfill();
        topgd.heightHint = this.settings.getInt(HEIGHT);
        topgd.widthHint = this.settings.getInt(WIDTH);
        this.topComposite = new Composite((Composite)this, 0);
        this.topComposite.setLayout((Layout)new GridLayout(4, false));
        this.topComposite.setLayoutData((Object)topgd);
        this.topComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Point size = FacetsSelectionPanel.this.topComposite.getSize();
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.WIDTH, size.x);
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.HEIGHT, size.y);
            }
        });
        this.presetsLabel = new Label(this.topComposite, 0);
        this.presetsLabel.setText(Resources.presetsLabel);
        this.presetsCombo = new Combo(this.topComposite, 8);
        this.presetsCombo.setLayoutData((Object)GridLayoutUtil.gdhfill());
        this.savePresetButton = new Button(this.topComposite, 8);
        this.savePresetButton.setText(Resources.saveButtonLabel);
        this.savePresetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacetsSelectionPanel.this.handleSavePreset();
            }
        });
        this.deletePresetButton = new Button(this.topComposite, 8);
        this.deletePresetButton.setText(Resources.deleteButtonLabel);
        this.deletePresetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacetsSelectionPanel.this.handleDeletePreset();
            }
        });
        int width = Math.max(SwtUtil.getPreferredWidth((Control)this.savePresetButton), SwtUtil.getPreferredWidth((Control)this.deletePresetButton)) + 15;
        this.savePresetButton.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gd(), width));
        this.deletePresetButton.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gd(), width));
        this.sform1 = new SashForm(this.topComposite, 65792);
        this.sform1.setLayoutData((Object)GridLayoutUtil.gdhspan(GridLayoutUtil.gdfill(), 4));
        this.sform2 = new SashForm((Composite)this.sform1, 66048);
        this.sform2.setLayoutData((Object)GridLayoutUtil.gdhspan(GridLayoutUtil.gdfill(), 4));
        this.treeViewer = new CheckboxTreeViewer((Composite)this.sform2, 2048);
        this.tree = this.treeViewer.getTree();
        this.tree.setHeaderVisible(true);
        this.ceditor = new ComboBoxCellEditor((Composite)this.tree, new String[0], 8);
        this.treeViewer.setColumnProperties(new String[]{FACET_COLUMN, VERSION_COLUMN});
        this.treeViewer.setCellModifier((ICellModifier)new CellModifier());
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = this.ceditor;
        this.treeViewer.setCellEditors(cellEditorArray);
        this.treeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.treeViewer.setSorter((ViewerSorter)new Sorter());
        this.colFacet = new TreeColumn(this.tree, 0);
        this.colFacet.setText(Resources.facetColumnLabel);
        this.colFacet.setResizable(true);
        if (this.settings.get(CW_FACET) == null) {
            this.settings.put(CW_FACET, this.computeDefaultFacetColumnWidth());
        }
        this.colFacet.setWidth(this.settings.getInt(CW_FACET));
        this.colFacet.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.CW_FACET, FacetsSelectionPanel.this.colFacet.getWidth());
            }
        });
        this.colVersion = new TreeColumn(this.tree, 0);
        this.colVersion.setText(Resources.versionColumnLabel);
        this.colVersion.setResizable(true);
        if (this.settings.get(CW_VERSION) == null) {
            this.settings.put(CW_VERSION, this.computeDefaultVersionColumnWidth());
        }
        this.colVersion.setWidth(this.settings.getInt(CW_VERSION));
        this.colVersion.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.CW_VERSION, FacetsSelectionPanel.this.colVersion.getWidth());
            }
        });
        new FacetToolTip((Control)this.tree);
        new CategoryToolTip((Control)this.tree);
        this.fixedFacetToolTip = new FixedFacetToolTip((Control)this.tree);
        this.treeViewer.setInput(new Object());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                FacetsSelectionPanel.this.handleSelectionChangedEvent(e);
            }
        });
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                FacetsSelectionPanel.this.handleCheckStateChanged(e);
            }
        });
        this.tree.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                FacetsSelectionPanel.this.handleMouseDownEvent(event);
            }
        });
        this.tree.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                FacetsSelectionPanel.this.handlePaintItemEvent(event);
            }
        });
        this.problemsView = new TableViewer((Composite)this.sform2, 2048);
        this.problemsView.setContentProvider((IContentProvider)new ProblemsContentProvider());
        this.problemsView.setLabelProvider((IBaseLabelProvider)new ProblemsLabelProvider());
        this.problemsView.setInput(new Object());
        this.problemsView.getTable().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int[] weights = FacetsSelectionPanel.this.sform2.getWeights();
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.SASH2W1, weights[0]);
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.SASH2W2, weights[1]);
            }
        });
        int[] weights2 = new int[]{this.settings.getInt(SASH2W1), this.settings.getInt(SASH2W2)};
        this.sform2.setWeights(weights2);
        TabFolder tabFolder = new TabFolder((Composite)this.sform1, 0);
        tabFolder.setLayoutData((Object)GridLayoutUtil.gdhhint(GridLayoutUtil.gdhfill(), 80));
        this.detailsPanel = new DetailsPanel((Composite)tabFolder, this);
        this.detailsTabItem = new TabItem(tabFolder, 0);
        this.detailsTabItem.setControl((Control)this.detailsPanel);
        this.detailsTabItem.setText(Resources.detailsTabLabel);
        this.runtimesPanel = new RuntimesPanel((Composite)tabFolder, this.fpjwc);
        this.runtimesTabItem = new TabItem(tabFolder, 0);
        this.runtimesTabItem.setControl((Control)this.runtimesPanel);
        this.runtimesTabItem.setText(Resources.runtimesTabLabel);
        this.runtimesPanel.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int[] weights = FacetsSelectionPanel.this.sform1.getWeights();
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.SASH1W1, weights[0]);
                FacetsSelectionPanel.this.settings.put(FacetsSelectionPanel.SASH1W2, weights[1]);
            }
        });
        int[] weights1 = new int[]{this.settings.getInt(SASH1W1), this.settings.getInt(SASH1W2)};
        this.sform1.setWeights(weights1);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FacetsSelectionPanel.this.handleDisposeEvent();
            }
        });
        Dialog.applyDialogFont((Control)parent);
        this.addWorkingCopyListener(new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                FacetsSelectionPanel.this.handleProjectFacetsChangedEvent(event);
            }
        }, IFacetedProjectEvent.Type.PROJECT_FACETS_CHANGED);
        this.handleProjectFacetsChangedEvent(null);
        this.addWorkingCopyListener(new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                FacetsSelectionPanel.this.handleValidationProblemsChangedEvent();
            }
        }, IFacetedProjectEvent.Type.VALIDATION_PROBLEMS_CHANGED);
        this.handleValidationProblemsChangedEvent();
        this.addWorkingCopyListener(new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                FacetsSelectionPanel.this.handleSelectedPresetChangedEvent();
            }
        }, IFacetedProjectEvent.Type.SELECTED_PRESET_CHANGED);
        ModifyFacetedProjectWizard.syncWithPresetsModel(this.fpjwc, this.presetsCombo);
        this.addWorkingCopyListener(new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                FacetsSelectionPanel.this.handleModelChangedEvent(event);
            }
        }, IFacetedProjectEvent.Type.FIXED_FACETS_CHANGED, IFacetedProjectEvent.Type.SELECTED_PRESET_CHANGED, IFacetedProjectEvent.Type.TARGETED_RUNTIMES_CHANGED);
    }

    public IFacetedProjectWorkingCopy getFacetedProjectWorkingCopy() {
        return this.fpjwc;
    }

    public boolean isSelectionValid() {
        return this.fpjwc.validate().getSeverity() != 4;
    }

    public boolean setFocus() {
        return this.tree.setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.selection);
    }

    public void setSelection(ISelection selection) {
        throw new UnsupportedOperationException();
    }

    private void notifySelectionChangedListeners() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : this.selectionListeners) {
            listener.selectionChanged(event);
        }
    }

    private ImageRegistry getImageRegistry() {
        return this.imageRegistry;
    }

    public Image getImage(IProjectFacet facet, boolean showDecorations) {
        boolean isFixed = this.getFacetedProjectWorkingCopy().isFixedProjectFacet(facet);
        String id = String.valueOf(isFixed && showDecorations ? "F:" : "f:") + facet.getId();
        Image image = this.getImageRegistry().get(id);
        if (image == null) {
            IDecorationsProvider decprov = (IDecorationsProvider)facet.getAdapter(IDecorationsProvider.class);
            Object imgdesc = decprov.getIcon();
            if (isFixed && showDecorations) {
                imgdesc = new FixedFacetImageDescriptor((ImageDescriptor)imgdesc);
            }
            this.getImageRegistry().put(id, imgdesc);
            image = this.getImageRegistry().get(id);
        }
        return image;
    }

    public Image getImage(ICategory category) {
        String id = "c:" + category.getId();
        Image image = this.getImageRegistry().get(id);
        if (image == null) {
            IDecorationsProvider decprov = (IDecorationsProvider)category.getAdapter(IDecorationsProvider.class);
            ImageDescriptor imgdesc = decprov.getIcon();
            this.getImageRegistry().put(id, imgdesc);
            image = this.getImageRegistry().get(id);
        }
        return image;
    }

    private void refresh() {
        Object[] checked = this.treeViewer.getCheckedElements();
        this.treeViewer.refresh();
        this.treeViewer.setCheckedElements(checked);
        this.refreshVersionsDropDown();
    }

    public void setCategoryExpandedState(ICategory category, boolean expanded) {
        this.treeViewer.setExpandedState((Object)category, expanded);
    }

    public boolean getShowToolTips() {
        return this.showToolTips;
    }

    public void setShowToolTips(boolean showToolTips) {
        this.showToolTips = showToolTips;
    }

    private void refreshCategoryState(ICategory category) {
        if (category == null) {
            return;
        }
        int selected = 0;
        for (IProjectFacet f : category.getProjectFacets()) {
            if (!this.fpjwc.hasProjectFacet(f)) continue;
            ++selected;
        }
        if (selected == 0) {
            this.treeViewer.setChecked((Object)category, false);
            this.treeViewer.setGrayed((Object)category, false);
        } else if (selected == category.getProjectFacets().size()) {
            this.treeViewer.setChecked((Object)category, true);
            this.treeViewer.setGrayed((Object)category, false);
        } else {
            this.treeViewer.setGrayChecked((Object)category, true);
        }
    }

    private void refreshVersionsDropDown() {
        IProjectFacet f = this.getSelectedProjectFacet();
        if (f == null) {
            return;
        }
        SortedSet versions = this.fpjwc.getAvailableVersions(f);
        String[] verstrs = new String[versions.size()];
        Integer value = null;
        int i = 0;
        for (IProjectFacetVersion fv : versions) {
            verstrs[i] = fv.getVersionString();
            if (fv == this.getSelectedVersion(f)) {
                value = new Integer(i);
            }
            ++i;
        }
        this.ceditor.setItems(verstrs);
        this.ceditor.setValue(value);
    }

    private void addWorkingCopyListener(IFacetedProjectListener listener, IFacetedProjectEvent.Type ... types) {
        this.fpjwc.addListener(listener, types);
        this.registeredWorkingCopyListeners.add(listener);
    }

    public IProjectFacet getSelectedProjectFacet() {
        IProjectFacetVersion fv = this.getSelectedProjectFacetVersion();
        if (fv != null) {
            return fv.getProjectFacet();
        }
        return null;
    }

    public IProjectFacetVersion getSelectedProjectFacetVersion() {
        if (this.selection != null && this.selection instanceof IProjectFacetVersion) {
            return (IProjectFacetVersion)this.selection;
        }
        return null;
    }

    private IProjectFacetVersion getSelectedVersion(IProjectFacet f) {
        SortedSet availableVersions = this.fpjwc.getAvailableVersions(f);
        if (availableVersions.isEmpty()) {
            throw new IllegalStateException();
        }
        IProjectFacetVersion selectedVersion = this.fpjwc.getProjectFacetVersion(f);
        if (selectedVersion == null) {
            selectedVersion = this.selectedVersions.get(f);
            if (selectedVersion == null) {
                selectedVersion = f.getDefaultVersion();
            }
            if (!availableVersions.contains(selectedVersion)) {
                selectedVersion = this.fpjwc.getHighestAvailableVersion(f);
            }
        }
        this.selectedVersions.put(f, selectedVersion);
        return selectedVersion;
    }

    private void setSelectedVersion(IProjectFacet f, IProjectFacetVersion fv) {
        if (this.fpjwc.getProjectFacetVersion(f) != null) {
            this.fpjwc.changeProjectFacetVersion(fv);
        }
        this.selectedVersions.put(f, fv);
        if (f == this.getSelectedProjectFacet()) {
            this.selection = fv;
            this.notifySelectionChangedListeners();
        }
    }

    private void handleSelectionChangedEvent(SelectionChangedEvent event) {
        Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (selection != null && selection instanceof IProjectFacet) {
            selection = this.getSelectedVersion((IProjectFacet)selection);
        }
        if (selection != this.selection) {
            this.selection = selection;
            this.refreshVersionsDropDown();
            this.notifySelectionChangedListeners();
        }
    }

    private void handleCheckStateChanged(CheckStateChangedEvent event) {
        Object el = event.getElement();
        boolean checked = event.getChecked();
        if (el instanceof IProjectFacet) {
            IProjectFacet f = (IProjectFacet)el;
            if (this.fpjwc.getFixedProjectFacets().contains(f)) {
                if (!checked) {
                    this.treeViewer.setChecked(el, true);
                    String msg = NLS.bind((String)Resources.couldNotDeselectFixedFacetMessage, (Object)f.getLabel());
                    this.fixedFacetToolTip.setMessage(msg);
                    Point cursorLocation = this.getDisplay().getCursorLocation();
                    this.fixedFacetToolTip.show(this.tree.toControl(cursorLocation));
                }
                return;
            }
            if (checked) {
                this.fpjwc.addProjectFacet(this.getSelectedVersion(f));
            } else {
                this.fpjwc.removeProjectFacet(f);
            }
            this.refreshCategoryState(f.getCategory());
        } else {
            ContentProvider cp = (ContentProvider)this.treeViewer.getContentProvider();
            HashSet<IProjectFacetVersion> facets = new HashSet<IProjectFacetVersion>(this.fpjwc.getProjectFacets());
            Object[] children = cp.getChildren(el);
            int selected = 0;
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                IProjectFacet f = (IProjectFacet)child;
                if (!this.fpjwc.getFixedProjectFacets().contains(f)) {
                    IProjectFacetVersion fv = this.getSelectedVersion(f);
                    if (checked) {
                        facets.add(fv);
                    } else {
                        facets.remove(fv);
                    }
                    this.treeViewer.setChecked((Object)f, checked);
                }
                if (this.fpjwc.hasProjectFacet(f)) {
                    ++selected;
                }
                ++n2;
            }
            if (selected == 0 || selected == children.length) {
                this.treeViewer.setGrayed(el, false);
            } else {
                this.treeViewer.setGrayChecked(el, true);
            }
            this.fpjwc.setProjectFacets(facets);
        }
        this.fpjwc.setSelectedPreset(null);
    }

    private void handleMouseDownEvent(Event event) {
        List<TreeItem> items = this.getAllTreeItems();
        for (TreeItem item : items) {
            if (!item.getBounds(1).contains(event.x, event.y)) continue;
            this.tree.setSelection(new TreeItem[]{item});
            this.treeViewer.editElement(item.getData(), 1);
        }
    }

    private void handlePaintItemEvent(Event event) {
        IProjectFacet f;
        TreeItem item = (TreeItem)event.item;
        Object itemData = item.getData();
        if (itemData instanceof IProjectFacet && event.index == 1 && this.fpjwc.getAvailableVersions(f = (IProjectFacet)itemData).size() > 1) {
            Image arrowImage = this.getImageRegistry().get(IMG_DOWN_ARROW);
            Rectangle arrowImageBounds = arrowImage.getBounds();
            int columnWidth = this.colVersion.getWidth();
            int itemHeight = this.tree.getItemHeight();
            int x = event.x + columnWidth - arrowImageBounds.width - 10;
            int y = event.y;
            event.gc.setBackground(item.getDisplay().getSystemColor(1));
            event.gc.fillRectangle(x, y, arrowImageBounds.width + 10, itemHeight);
            y = event.y + (itemHeight - arrowImageBounds.height) / 2;
            event.gc.drawImage(arrowImage, x, y);
        }
    }

    private void handleDisposeEvent() {
        this.imageRegistry.dispose();
        for (IFacetedProjectListener listener : this.registeredWorkingCopyListeners) {
            this.fpjwc.removeListener(listener);
        }
    }

    private void handleSavePreset() {
        Set facets = this.fpjwc.getProjectFacets();
        IPreset preset = SavePresetDialog.showDialog(this.getShell(), facets);
        if (preset != null) {
            this.fpjwc.setSelectedPreset(preset.getId());
        }
    }

    private void handleDeletePreset() {
        IPreset preset = this.fpjwc.getSelectedPreset();
        this.fpjwc.setSelectedPreset(null);
        ProjectFacetsManager.deletePreset((IPreset)preset);
    }

    private void handleProjectFacetsChangedEvent(IFacetedProjectEvent event) {
        HashSet<ICategory> affectedCategories = new HashSet<ICategory>();
        if (event != null) {
            IFacetedProjectWorkingCopy fpjwc = event.getWorkingCopy();
            IProjectFacetsChangedEvent evt = (IProjectFacetsChangedEvent)event;
            for (IProjectFacetVersion fv : evt.getAllAffectedFacets()) {
                IProjectFacet f = fv.getProjectFacet();
                boolean checked = fpjwc.hasProjectFacet(fv);
                this.treeViewer.setChecked((Object)f, checked);
                this.treeViewer.update((Object)f, null);
                ICategory category = f.getCategory();
                if (category == null) continue;
                affectedCategories.add(category);
            }
        } else {
            ArrayList<IProjectFacet> facets = new ArrayList<IProjectFacet>();
            for (IProjectFacetVersion fv : this.fpjwc.getProjectFacets()) {
                facets.add(fv.getProjectFacet());
            }
            this.treeViewer.setCheckedElements(facets.toArray());
            for (IProjectFacet facet : this.fpjwc.getAvailableFacets().keySet()) {
                ICategory category = facet.getCategory();
                if (category == null) continue;
                affectedCategories.add(category);
            }
            this.treeViewer.update(this.fpjwc.getAvailableFacets().keySet().toArray(), null);
        }
        for (ICategory category : affectedCategories) {
            this.refreshCategoryState(category);
        }
    }

    private void handleValidationProblemsChangedEvent() {
        this.problemsView.refresh();
        if (this.fpjwc.validate().isOK()) {
            if (this.sform2.getMaximizedControl() == null) {
                this.sform2.setMaximizedControl((Control)this.tree);
            }
        } else if (this.sform2.getMaximizedControl() != null) {
            this.sform2.setMaximizedControl(null);
        }
    }

    private void handleSelectedPresetChangedEvent() {
        IPreset preset = this.fpjwc.getSelectedPreset();
        if (preset == null) {
            this.savePresetButton.setEnabled(true);
            this.deletePresetButton.setEnabled(false);
        } else {
            this.savePresetButton.setEnabled(false);
            this.deletePresetButton.setEnabled(preset.getType() == IPreset.Type.USER_DEFINED);
        }
    }

    private void handleModelChangedEvent(IFacetedProjectEvent event) {
        switch (event.getType()) {
            case FIXED_FACETS_CHANGED: {
                this.refresh();
                break;
            }
            case TARGETED_RUNTIMES_CHANGED: {
                this.refresh();
            }
        }
    }

    private List<TreeItem> getAllTreeItems() {
        ArrayList<TreeItem> result = new ArrayList<TreeItem>();
        FacetsSelectionPanel.getAllTreeItems(this.tree.getItems(), result);
        return result;
    }

    private static void getAllTreeItems(TreeItem[] items, List<TreeItem> result) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            result.add(item);
            FacetsSelectionPanel.getAllTreeItems(item.getItems(), result);
            ++n2;
        }
    }

    private TreeItem getTreeItem(int x, int y) {
        return FacetsSelectionPanel.getTreeItemHelper(x, y, this.tree.getItems());
    }

    private static TreeItem getTreeItemHelper(int x, int y, TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getBounds().contains(x, y)) {
                return item;
            }
            TreeItem res = FacetsSelectionPanel.getTreeItemHelper(x, y, item.getItems());
            if (res != null) {
                return res;
            }
            ++n2;
        }
        return null;
    }

    private int computeDefaultFacetColumnWidth() {
        GC gc = new GC((Drawable)this.getDisplay());
        int maxFacetLabelWidth = 0;
        try {
            gc.setFont(this.tree.getFont());
            for (IProjectFacet f : ProjectFacetsManager.getProjectFacets()) {
                maxFacetLabelWidth = Math.max(maxFacetLabelWidth, gc.textExtent((String)f.getLabel()).x);
            }
        }
        finally {
            gc.dispose();
        }
        return Math.max(maxFacetLabelWidth + 100, 200);
    }

    private int computeDefaultVersionColumnWidth() {
        int columnLabelWidth;
        GC gc = new GC((Drawable)this.getDisplay());
        int maxVersionStringWidth = 0;
        try {
            gc.setFont(this.tree.getFont());
            for (IProjectFacet f : ProjectFacetsManager.getProjectFacets()) {
                for (IProjectFacetVersion fv : f.getVersions()) {
                    int textExtent = gc.textExtent((String)fv.getVersionString()).x;
                    maxVersionStringWidth = Math.max(maxVersionStringWidth, textExtent + 30);
                }
            }
            columnLabelWidth = gc.textExtent((String)Resources.versionColumnLabel).x + 30;
        }
        finally {
            gc.dispose();
        }
        return Math.max(maxVersionStringWidth, columnLabelWidth);
    }

    private final class CategoryToolTip
    extends HeaderToolTip {
        public CategoryToolTip(Control control) {
            super(control);
        }

        protected final boolean shouldCreateToolTip(Event event) {
            Object treeItemData;
            if (!FacetsSelectionPanel.this.getShowToolTips()) {
                return false;
            }
            TreeItem treeItem = FacetsSelectionPanel.this.getTreeItem(event.x, event.y);
            String description = null;
            if (treeItem != null && treeItem.getBounds(0).contains(event.x, event.y) && (treeItemData = treeItem.getData()) instanceof ICategory) {
                description = ((ICategory)treeItemData).getDescription();
            }
            return description != null && description.trim().length() > 0;
        }

        protected String getToolTipTitle(Event event) {
            return ((ICategory)FacetsSelectionPanel.this.getTreeItem(event.x, event.y).getData()).getLabel();
        }

        protected Composite createContentArea(Event event, Composite parent) {
            Display display = parent.getDisplay();
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)GridLayoutUtil.gl(1));
            composite.setBackground(display.getSystemColor(29));
            Label label = new Label(composite, 64);
            label.setLayoutData((Object)GridLayoutUtil.gdfill());
            label.setBackground(display.getSystemColor(29));
            ICategory category = (ICategory)FacetsSelectionPanel.this.getTreeItem(event.x, event.y).getData();
            label.setText(category.getDescription());
            return composite;
        }
    }

    private final class CellModifier
    implements ICellModifier {
        private final IFacetedProjectWorkingCopy fpjwc;

        public CellModifier() {
            this.fpjwc = FacetsSelectionPanel.this.getFacetedProjectWorkingCopy();
        }

        public Object getValue(Object element, String property) {
            IProjectFacet f = (IProjectFacet)element;
            if (property.equals(FacetsSelectionPanel.VERSION_COLUMN)) {
                int i = 0;
                for (IProjectFacetVersion fv : this.fpjwc.getAvailableVersions(f)) {
                    if (fv == FacetsSelectionPanel.this.getSelectedVersion(f)) {
                        return new Integer(i);
                    }
                    ++i;
                }
                return new IllegalStateException();
            }
            throw new IllegalStateException();
        }

        public boolean canModify(Object element, String property) {
            return property.equals(FacetsSelectionPanel.VERSION_COLUMN) && element instanceof IProjectFacet && this.fpjwc.getAvailableVersions((IProjectFacet)element).size() > 1;
        }

        public void modify(Object element, String property, Object value) {
            TreeItem item = (TreeItem)element;
            IProjectFacet f = (IProjectFacet)item.getData();
            if (property.equals(FacetsSelectionPanel.VERSION_COLUMN)) {
                int index = (Integer)value;
                if (index != -1) {
                    int i = 0;
                    for (IProjectFacetVersion fv : this.fpjwc.getAvailableVersions(f)) {
                        if (i == index) {
                            FacetsSelectionPanel.this.setSelectedVersion(f, fv);
                            FacetsSelectionPanel.this.treeViewer.update((Object)f, null);
                            break;
                        }
                        ++i;
                    }
                }
            } else {
                throw new IllegalStateException();
            }
        }
    }

    private final class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object element) {
            IFacetedProjectWorkingCopy fpjwc = FacetsSelectionPanel.this.getFacetedProjectWorkingCopy();
            ArrayList<Object> list = new ArrayList<Object>();
            Set categories = ProjectFacetsManager.getCategories();
            for (ICategory iCategory : categories) {
                boolean visible = false;
                for (IProjectFacet f : iCategory.getProjectFacets()) {
                    if (fpjwc.getAvailableVersions(f).isEmpty()) continue;
                    visible = true;
                    break;
                }
                if (!visible) continue;
                list.add(iCategory);
            }
            for (Map.Entry entry : fpjwc.getAvailableFacets().entrySet()) {
                IProjectFacet f = (IProjectFacet)entry.getKey();
                SortedSet availableVersions = (SortedSet)entry.getValue();
                if (f.getCategory() != null || availableVersions.isEmpty()) continue;
                list.add(f);
            }
            return list.toArray();
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof ICategory) {
                IFacetedProjectWorkingCopy fpjwc = FacetsSelectionPanel.this.getFacetedProjectWorkingCopy();
                ICategory category = (ICategory)parent;
                ArrayList<IProjectFacet> facets = new ArrayList<IProjectFacet>();
                for (IProjectFacet f : category.getProjectFacets()) {
                    if (fpjwc.getAvailableVersions(f).isEmpty()) continue;
                    facets.add(f);
                }
                return facets.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IProjectFacet) {
                IProjectFacet f = (IProjectFacet)element;
                return f.getCategory();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ICategory && !((ICategory)element).getProjectFacets().isEmpty();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldObject, Object newObject) {
        }
    }

    private final class FacetToolTip
    extends HeaderToolTip {
        public FacetToolTip(Control control) {
            super(control);
        }

        protected final boolean shouldCreateToolTip(Event event) {
            Object treeItemData;
            if (!FacetsSelectionPanel.this.getShowToolTips()) {
                return false;
            }
            TreeItem treeItem = FacetsSelectionPanel.this.getTreeItem(event.x, event.y);
            String description = null;
            if (treeItem != null && treeItem.getBounds(0).contains(event.x, event.y) && (treeItemData = treeItem.getData()) instanceof IProjectFacet) {
                description = ((IProjectFacet)treeItemData).getDescription();
            }
            return description != null && description.trim().length() > 0;
        }

        protected String getToolTipTitle(Event event) {
            IProjectFacet f = (IProjectFacet)FacetsSelectionPanel.this.getTreeItem(event.x, event.y).getData();
            return FacetsSelectionPanel.this.getSelectedVersion(f).toString();
        }

        protected Composite createContentArea(Event event, Composite parent) {
            Display display = parent.getDisplay();
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)GridLayoutUtil.gl(1));
            composite.setBackground(display.getSystemColor(29));
            Label label = new Label(composite, 64);
            label.setLayoutData((Object)GridLayoutUtil.gdfill());
            label.setBackground(display.getSystemColor(29));
            IProjectFacet f = (IProjectFacet)FacetsSelectionPanel.this.getTreeItem(event.x, event.y).getData();
            label.setText(f.getDescription());
            return composite;
        }
    }

    private static final class FixedFacetImageDescriptor
    extends CompositeImageDescriptor {
        private static final String OVERLAY_IMG_LOCATION = "images/lock.gif";
        private static final ImageData OVERLAY = FacetUiPlugin.getImageDescriptor("images/lock.gif").getImageData();
        private final ImageData base;
        private final Point size;

        public FixedFacetImageDescriptor(ImageDescriptor base) {
            this.base = base.getImageData();
            this.size = new Point(this.base.width, this.base.height);
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.base, 0, 0);
            this.drawImage(OVERLAY, 0, height - FixedFacetImageDescriptor.OVERLAY.height);
        }

        protected Point getSize() {
            return this.size;
        }
    }

    private final class FixedFacetToolTip
    extends BasicToolTip {
        private static final int FAKE_EVENT_TYPE = -9999;

        public FixedFacetToolTip(Control control) {
            super(control);
            this.setPopupDelay(0);
        }

        public void show(Point location) {
            Event fakeEvent = new Event();
            fakeEvent.type = -9999;
            fakeEvent.x = location.x;
            fakeEvent.y = location.y;
            try {
                Method method = ToolTip.class.getDeclaredMethod("toolTipCreate", Event.class);
                method.setAccessible(true);
                method.invoke((Object)this, fakeEvent);
            }
            catch (Exception e) {
                FacetUiPlugin.log(e);
            }
        }

        protected final boolean shouldCreateToolTip(Event event) {
            return event.type == -9999;
        }
    }

    public static interface IFilter {
        public boolean check(IProjectFacetVersion var1);
    }

    private final class LabelProvider
    implements ITableLabelProvider {
        private LabelProvider() {
        }

        public String getColumnText(Object element, int column) {
            if (element instanceof ICategory) {
                if (column == 0) {
                    return ((ICategory)element).getLabel();
                }
                return "";
            }
            IProjectFacet f = (IProjectFacet)element;
            switch (column) {
                case 0: {
                    return f.getLabel();
                }
                case 1: {
                    return FacetsSelectionPanel.this.getSelectedVersion(f).getVersionString();
                }
            }
            throw new IllegalStateException();
        }

        public Image getColumnImage(Object element, int column) {
            if (column != 0) {
                return null;
            }
            if (element instanceof IProjectFacet) {
                return FacetsSelectionPanel.this.getImage((IProjectFacet)element, true);
            }
            return FacetsSelectionPanel.this.getImage((ICategory)element);
        }

        public boolean isLabelProperty(Object obj, String s) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private final class ProblemsContentProvider
    implements IStructuredContentProvider {
        private ProblemsContentProvider() {
        }

        public Object[] getElements(Object element) {
            return FacetsSelectionPanel.this.fpjwc.validate().getChildren();
        }

        public void inputChanged(Viewer viewer, Object oldObject, Object newObject) {
        }

        public void dispose() {
        }
    }

    private final class ProblemsLabelProvider
    implements ITableLabelProvider {
        private ProblemsLabelProvider() {
        }

        public String getColumnText(Object element, int column) {
            return ((IStatus)element).getMessage();
        }

        public Image getColumnImage(Object element, int column) {
            IStatus st = (IStatus)element;
            if (st.getSeverity() == 4) {
                return FacetsSelectionPanel.this.getImageRegistry().get(FacetsSelectionPanel.IMG_ERROR);
            }
            return FacetsSelectionPanel.this.getImageRegistry().get(FacetsSelectionPanel.IMG_WARNING);
        }

        public boolean isLabelProperty(Object obj, String s) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static final class Resources
    extends NLS {
        public static String presetsLabel;
        public static String saveButtonLabel;
        public static String deleteButtonLabel;
        public static String savePresetDialogTitle;
        public static String savePresetDialogMessage;
        public static String facetColumnLabel;
        public static String versionColumnLabel;
        public static String couldNotDeselectFixedFacetMessage;
        public static String detailsTabLabel;
        public static String runtimesTabLabel;

        static {
            Resources.initializeMessages((String)FacetsSelectionPanel.class.getName(), Resources.class);
        }

        private Resources() {
        }

        public static String bind(String msg, Object arg1, Object arg2, Object arg3) {
            return NLS.bind((String)msg, (Object[])new Object[]{arg1, arg2, arg3});
        }
    }

    private static final class Sorter
    extends ViewerSorter {
        private Sorter() {
        }

        public int compare(Viewer viewer, Object a, Object b) {
            return Sorter.getLabel(a).compareToIgnoreCase(Sorter.getLabel(b));
        }

        private static String getLabel(Object obj) {
            if (obj instanceof IProjectFacet) {
                return ((IProjectFacet)obj).getLabel();
            }
            return ((ICategory)obj).getLabel();
        }
    }
}

