/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.ui.ModifyFacetedProjectWizard;
import org.eclipse.wst.common.project.facet.ui.internal.FacetUiPlugin;
import org.eclipse.wst.common.project.facet.ui.internal.RuntimesPanel;

public class RuntimesPropertyPage
extends PropertyPage {
    private IFacetedProject project;
    private IFacetedProjectListener projectListener;
    private IFacetedProjectWorkingCopy fpjwc;
    private RuntimesPanel panel;

    protected Control createContents(Composite parent) {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            try {
                this.project = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException coreException) {}
            if (this.project == null) {
                return null;
            }
            this.fpjwc = this.project.createWorkingCopy();
            this.projectListener = new IFacetedProjectListener(){

                public void handleEvent(IFacetedProjectEvent event) {
                    RuntimesPropertyPage.this.handleProjectChangedEvent();
                }
            };
            this.project.addListener(this.projectListener, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PROJECT_MODIFIED});
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)RuntimesPropertyPage.gdfill());
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginBottom = 5;
            composite.setLayout((Layout)layout);
            this.panel = new RuntimesPanel(composite, this.fpjwc);
            this.panel.setLayoutData(RuntimesPropertyPage.gdfill());
            Label hint = new Label(composite, 64);
            hint.setText(Resources.hint);
            GridData gd = RuntimesPropertyPage.gdhfill();
            gd.grabExcessHorizontalSpace = true;
            gd.widthHint = 300;
            gd.verticalIndent = 5;
            hint.setLayoutData((Object)gd);
            Hyperlink uninstallFacetsLink = new Hyperlink(composite, 0);
            uninstallFacetsLink.setForeground(parent.getDisplay().getSystemColor(10));
            uninstallFacetsLink.setUnderlined(true);
            uninstallFacetsLink.setText(Resources.uninstallFacetsLinkLabel);
            uninstallFacetsLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent evt) {
                    RuntimesPropertyPage.this.performAddRemoveFacets();
                }
            });
            composite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    RuntimesPropertyPage.this.handleDisposeEvent();
                }
            });
            Dialog.applyDialogFont((Control)parent);
            return composite;
        }
        return null;
    }

    public boolean performOk() {
        final Set targeted = this.fpjwc.getTargetedRuntimes();
        final IRuntime primary = this.fpjwc.getPrimaryRuntime();
        if (!this.project.getTargetedRuntimes().equals(primary) || !RuntimesPropertyPage.equals(this.project.getPrimaryRuntime(), primary)) {
            final IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IFacetedProject fpj = RuntimesPropertyPage.this.project;
                    fpj.setTargetedRuntimes(targeted, null);
                    if (primary != null) {
                        fpj.setPrimaryRuntime(primary, null);
                    }
                }
            };
            Runnable op = new Runnable(){

                public void run() {
                    IWorkspace ws = ResourcesPlugin.getWorkspace();
                    try {
                        ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, null);
                    }
                    catch (CoreException e) {
                        IStatus st = e.getStatus();
                        ErrorDialog.openError((Shell)RuntimesPropertyPage.this.getShell(), (String)Resources.errDlgTitle, (String)st.getMessage(), (IStatus)st);
                        FacetUiPlugin.log(st);
                    }
                }
            };
            BusyIndicator.showWhile(null, (Runnable)op);
        }
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.fpjwc.setTargetedRuntimes(this.project.getTargetedRuntimes());
        this.fpjwc.setPrimaryRuntime(this.project.getPrimaryRuntime());
    }

    private void performAddRemoveFacets() {
        ModifyFacetedProjectWizard wizard = new ModifyFacetedProjectWizard(this.project);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
    }

    private void handleProjectChangedEvent() {
        this.fpjwc.refreshTargetableRuntimes();
        Set targetedRuntimes = this.project.getTargetedRuntimes();
        this.fpjwc.setTargetedRuntimes(targetedRuntimes);
        IRuntime primaryRuntime = this.project.getPrimaryRuntime();
        this.fpjwc.setPrimaryRuntime(primaryRuntime);
    }

    private void handleDisposeEvent() {
        this.project.removeListener(this.projectListener);
        this.fpjwc.dispose();
    }

    private static boolean equals(IRuntime r1, IRuntime r2) {
        if (r1 == null && r2 == null) {
            return true;
        }
        if (r1 == null || r2 == null) {
            return false;
        }
        return r1.equals(r2);
    }

    private static GridData gdfill() {
        return new GridData(4, 4, true, true);
    }

    private static GridData gdhfill() {
        return new GridData(768);
    }

    private static final class Resources
    extends NLS {
        public static String errDlgTitle;
        public static String hint;
        public static String uninstallFacetsLinkLabel;

        static {
            Resources.initializeMessages((String)RuntimesPropertyPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

