/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.axis2.core.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jst.ws.axis2.core.utils.FileUtils;

public class Axis2CoreUtils {
    private static boolean alreadyComputedTempAxis2Directory = false;
    private static String tempAxis2Dir = null;

    public static String tempAxis2Directory() {
        if (!alreadyComputedTempAxis2Directory) {
            String[] nodes = new String[]{".metadata", ".plugins", "org.apache.axis2.facet"};
            tempAxis2Dir = FileUtils.addNodesToPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString(), nodes);
            alreadyComputedTempAxis2Directory = true;
        }
        return tempAxis2Dir;
    }

    public static String tempAxis2WebappFileLocation() {
        return Axis2CoreUtils.addAnotherNodeToPath(Axis2CoreUtils.tempAxis2Directory(), "server.properties");
    }

    public static String tempRuntimeStatusFileLocation() {
        return Axis2CoreUtils.addAnotherNodeToPath(Axis2CoreUtils.tempAxis2Directory(), "status.properties");
    }

    public static String tempWarStatusFileLocation() {
        return Axis2CoreUtils.addAnotherNodeToPath(Axis2CoreUtils.tempAxis2Directory(), "war.properties");
    }

    public static String addAnotherNodeToPath(String currentPath, String newNode) {
        return String.valueOf(currentPath) + File.separator + newNode;
    }

    public static void writePropertyToFile(File file, String key, String value) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "8859_1"));
        out.write(String.valueOf(key) + "=" + value + "\n");
        ((Writer)out).close();
    }
}

