/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.server.core.internal.IMemento;
import org.eclipse.jst.server.core.internal.JavaServerPlugin;
import org.eclipse.jst.server.core.internal.Trace;
import org.eclipse.jst.server.core.internal.XMLMemento;
import org.eclipse.wst.server.core.IRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RuntimeClasspathProviderDelegate {
    private List<SourceAttachmentUpdate> sourceAttachments;
    private String extensionId;
    private Map<String, IPath> runtimePathMap = new HashMap<String, IPath>();
    private Map<String, IClasspathEntry[]> previousClasspath = new HashMap<String, IClasspathEntry[]>();

    public final void initialize(String id) {
        this.extensionId = id;
    }

    public IClasspathEntry[] resolveClasspathContainer(IRuntime runtime) {
        return null;
    }

    public IClasspathEntry[] resolveClasspathContainer(IProject project, IRuntime runtime) {
        return null;
    }

    public IClasspathEntry[] resolveClasspathContainerImpl(IRuntime runtime) {
        return this.resolveClasspathContainerImpl(null, runtime);
    }

    public IClasspathEntry[] resolveClasspathContainerImpl(IProject project, IRuntime runtime) {
        if (runtime == null) {
            return new IClasspathEntry[0];
        }
        this.runtimePathMap.put(runtime.getId(), runtime.getLocation());
        IClasspathEntry[] entries = this.resolveClasspathContainer(project, runtime);
        if (entries == null) {
            entries = this.resolveClasspathContainer(runtime);
        }
        if (entries == null) {
            entries = new IClasspathEntry[]{};
        }
        if (this.sourceAttachments == null) {
            this.load();
        }
        int size = entries.length;
        int size2 = this.sourceAttachments.size();
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < size2) {
                SourceAttachmentUpdate sau = this.sourceAttachments.get(j);
                if (sau.runtimeId.equals(runtime.getId()) && sau.entry.equals((Object)entries[i].getPath())) {
                    entries[i] = JavaCore.newLibraryEntry((IPath)entries[i].getPath(), (IPath)sau.sourceAttachmentPath, (IPath)sau.sourceAttachmentRootPath, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])sau.attributes, (boolean)false);
                }
                ++j;
            }
            ++i;
        }
        String key = String.valueOf(project.getName()) + "/" + runtime.getId();
        if (!this.previousClasspath.containsKey(key)) {
            this.previousClasspath.put(key, entries);
        } else {
            IClasspathEntry[] previousEntries = this.previousClasspath.get(key);
            if (previousEntries == null || previousEntries.length != entries.length) {
                Trace.trace((byte)3, "Classpath update: " + key + " " + entries);
                this.previousClasspath.put(key, entries);
                Path path = new Path("org.eclipse.jst.server.core.container");
                path = path.append(this.extensionId).append(runtime.getId());
                try {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    JavaCore.setClasspathContainer((IPath)path, (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[1], (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    Trace.trace((byte)1, "Error updating classpath", e);
                }
            }
        }
        return entries;
    }

    public boolean hasRuntimeClasspathChanged(IRuntime runtime) {
        try {
            IPath path = this.runtimePathMap.get(runtime.getId());
            return path != null && !path.equals((Object)runtime.getLocation());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void addJarFiles(File dir, List<IClasspathEntry> list, boolean includeSubdirectories) {
        int depth = 0;
        if (includeSubdirectories) {
            depth = 2;
        }
        RuntimeClasspathProviderDelegate.addJarFiles(dir, list, depth);
    }

    private static void addJarFiles(File dir, List<IClasspathEntry> list, int depth) {
        if (dir == null) {
            throw new IllegalArgumentException();
        }
        File[] files = dir.listFiles();
        if (files != null) {
            int size = files.length;
            int i = 0;
            while (i < size) {
                if (files[i].isDirectory() && depth > 0) {
                    RuntimeClasspathProviderDelegate.addJarFiles(files[i], list, depth - 1);
                } else if (files[i].getAbsolutePath().endsWith(".jar") || files[i].getAbsolutePath().endsWith(".zip")) {
                    Path path = new Path(files[i].getAbsolutePath());
                    list.add(JavaCore.newLibraryEntry((IPath)path, null, null));
                }
                ++i;
            }
        }
    }

    protected static void addLibraryEntries(List<IClasspathEntry> list, File dir, boolean includeSubdirectories) {
        if (dir == null) {
            throw new IllegalArgumentException();
        }
        RuntimeClasspathProviderDelegate.addJarFiles(dir, list, includeSubdirectories);
    }

    public void requestClasspathContainerUpdate(IRuntime runtime, IClasspathEntry[] entries) {
        if (runtime == null || entries == null) {
            return;
        }
        this.sourceAttachments = new ArrayList<SourceAttachmentUpdate>();
        int size = entries.length;
        int i = 0;
        while (i < size) {
            if (entries[i].getSourceAttachmentPath() != null || entries[i].getExtraAttributes() != null) {
                SourceAttachmentUpdate sau = new SourceAttachmentUpdate();
                sau.runtimeId = runtime.getId();
                sau.entry = entries[i].getPath();
                sau.sourceAttachmentPath = entries[i].getSourceAttachmentPath();
                sau.sourceAttachmentRootPath = entries[i].getSourceAttachmentRootPath();
                sau.attributes = entries[i].getExtraAttributes();
                this.sourceAttachments.add(sau);
            }
            ++i;
        }
        this.save();
    }

    private void load() {
        this.sourceAttachments = new ArrayList<SourceAttachmentUpdate>();
        String id = this.extensionId;
        String filename = JavaServerPlugin.getInstance().getStateLocation().append(String.valueOf(id) + ".xml").toOSString();
        if (!new File(filename).exists()) {
            return;
        }
        try {
            IMemento memento = XMLMemento.loadMemento(filename);
            IMemento[] children = memento.getChildren("source-attachment");
            int size = children.length;
            int i = 0;
            while (i < size) {
                try {
                    IMemento[] attrChildren;
                    SourceAttachmentUpdate sau = new SourceAttachmentUpdate();
                    sau.runtimeId = children[i].getString("runtime-id");
                    String temp = children[i].getString("entry");
                    if (temp != null) {
                        sau.entry = new Path(temp);
                    }
                    if ((temp = children[i].getString("source-attachment-path")) != null) {
                        sau.sourceAttachmentPath = new Path(temp);
                    }
                    if ((temp = children[i].getString("source-attachment-root-path")) != null) {
                        sau.sourceAttachmentRootPath = new Path(temp);
                    }
                    if ((attrChildren = children[i].getChildren("attribute")) != null) {
                        int size2 = attrChildren.length;
                        sau.attributes = new IClasspathAttribute[size2];
                        int j = 0;
                        while (j < size2) {
                            String name = attrChildren[j].getString("name");
                            String value = attrChildren[j].getString("value");
                            sau.attributes[j] = JavaCore.newClasspathAttribute((String)name, (String)value);
                            ++j;
                        }
                    }
                    this.sourceAttachments.add(sau);
                }
                catch (Exception e) {
                    Trace.trace((byte)1, "Could not load source attachment: " + e);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace((byte)1, "Could not load source path info", e);
        }
    }

    private void save() {
        if (this.sourceAttachments == null) {
            return;
        }
        String id = this.extensionId;
        String filename = JavaServerPlugin.getInstance().getStateLocation().append(String.valueOf(id) + ".xml").toOSString();
        try {
            XMLMemento memento = XMLMemento.createWriteRoot("classpath");
            for (SourceAttachmentUpdate sau : this.sourceAttachments) {
                IMemento child = memento.createChild("source-attachment");
                child.putString("runtime-id", sau.runtimeId);
                if (sau.entry != null) {
                    child.putString("entry", sau.entry.toPortableString());
                }
                if (sau.sourceAttachmentPath != null) {
                    child.putString("source-attachment-path", sau.sourceAttachmentPath.toPortableString());
                }
                if (sau.sourceAttachmentRootPath != null) {
                    child.putString("source-attachment-root-path", sau.sourceAttachmentRootPath.toPortableString());
                }
                if (sau.attributes == null) continue;
                int size = sau.attributes.length;
                int i = 0;
                while (i < size) {
                    IClasspathAttribute attr = sau.attributes[i];
                    IMemento attrChild = child.createChild("attribute");
                    attrChild.putString("name", attr.getName());
                    attrChild.putString("value", attr.getValue());
                    ++i;
                }
            }
            memento.saveToFile(filename);
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error saving source path info", e);
        }
    }

    protected class SourceAttachmentUpdate {
        String runtimeId;
        IPath entry;
        IPath sourceAttachmentPath;
        IPath sourceAttachmentRootPath;
        IClasspathAttribute[] attributes;

        protected SourceAttachmentUpdate() {
        }
    }
}

