/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;

public class J2EEUtil {
    private static final String EAR_MODULE = "jst.ear";
    private static final String WEB_MODULE = "jst.web";
    private static final IModule[] EMPTY_LIST = new IModule[0];
    private static Map<IModule, List<IModule>> earCache;
    private static Map<IJ2EEModule, List<IModule>> earCache2;
    private static Map<IModule, List<IModule>> webCache;
    protected static String cache;

    public static IModule[] getEnterpriseApplications(IJ2EEModule module, IProgressMonitor monitor) {
        if (J2EEUtil.shouldUseCache()) {
            List<IModule> list = earCache2.get(module);
            if (list == null) {
                return EMPTY_LIST;
            }
            return list.toArray(new IModule[list.size()]);
        }
        ArrayList<IModule> list = new ArrayList<IModule>();
        IModule[] modules = ServerUtil.getModules((String)EAR_MODULE);
        if (modules != null) {
            int size = modules.length;
            int i = 0;
            while (i < size) {
                IModule[] modules2;
                IModule module2 = modules[i];
                IEnterpriseApplication ear = (IEnterpriseApplication)module2.loadAdapter(IEnterpriseApplication.class, monitor);
                if (ear != null && (modules2 = ear.getModules()) != null) {
                    int size2 = modules2.length;
                    int j = 0;
                    while (j < size2) {
                        if (module.equals(modules2[j].loadAdapter(IJ2EEModule.class, monitor))) {
                            list.add(module2);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return list.toArray(new IModule[list.size()]);
    }

    public static IModule[] getEnterpriseApplications(IModule module, IProgressMonitor monitor) {
        if (J2EEUtil.shouldUseCache()) {
            List<IModule> list = earCache.get(module);
            if (list == null) {
                return EMPTY_LIST;
            }
            return list.toArray(new IModule[list.size()]);
        }
        ArrayList<IModule> list = new ArrayList<IModule>();
        IModule[] modules = ServerUtil.getModules((String)EAR_MODULE);
        if (modules != null) {
            int size = modules.length;
            int i = 0;
            while (i < size) {
                IModule[] modules2;
                IModule module2 = modules[i];
                IEnterpriseApplication ear = (IEnterpriseApplication)module2.loadAdapter(IEnterpriseApplication.class, monitor);
                if (ear != null && (modules2 = ear.getModules()) != null) {
                    int size2 = modules2.length;
                    int j = 0;
                    while (j < size2) {
                        if (module.equals(modules2[j])) {
                            list.add(module2);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return list.toArray(new IModule[list.size()]);
    }

    public static IModule[] getWebModules(IModule module, IProgressMonitor monitor) {
        if (J2EEUtil.shouldUseCache()) {
            List<IModule> list = webCache.get(module);
            if (list == null) {
                return EMPTY_LIST;
            }
            return list.toArray(new IModule[list.size()]);
        }
        ArrayList<IModule> list = new ArrayList<IModule>();
        IModule[] modules = ServerUtil.getModules((String)WEB_MODULE);
        if (modules != null) {
            int size = modules.length;
            int i = 0;
            while (i < size) {
                IModule[] modules2;
                IModule module2 = modules[i];
                IWebModule web = (IWebModule)module2.loadAdapter(IWebModule.class, monitor);
                if (web != null && (modules2 = web.getModules()) != null) {
                    int size2 = modules2.length;
                    int j = 0;
                    while (j < size2) {
                        if (module.equals(modules2[j])) {
                            list.add(module2);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return list.toArray(new IModule[list.size()]);
    }

    private static void fillCache(IProgressMonitor monitor) {
        List<IModule> m;
        int j;
        int size2;
        IModule[] modules2;
        IModule module2;
        int i;
        int size;
        earCache = new HashMap<IModule, List<IModule>>();
        earCache2 = new HashMap<IJ2EEModule, List<IModule>>();
        webCache = new HashMap<IModule, List<IModule>>();
        IModule[] modules = ServerUtil.getModules((String)EAR_MODULE);
        if (modules != null) {
            size = modules.length;
            i = 0;
            while (i < size) {
                module2 = modules[i];
                IEnterpriseApplication ear = (IEnterpriseApplication)module2.loadAdapter(IEnterpriseApplication.class, monitor);
                if (ear != null && (modules2 = ear.getModules()) != null) {
                    size2 = modules2.length;
                    j = 0;
                    while (j < size2) {
                        m = earCache.get(modules2[j]);
                        if (m == null) {
                            m = new ArrayList<IModule>(2);
                            earCache.put(modules2[j], m);
                        }
                        m.add(module2);
                        IJ2EEModule mod = (IJ2EEModule)modules2[j].loadAdapter(IJ2EEModule.class, monitor);
                        if (mod != null) {
                            m = earCache2.get(mod);
                            if (m == null) {
                                m = new ArrayList<IModule>(2);
                                earCache2.put(mod, m);
                            }
                            m.add(module2);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if ((modules = ServerUtil.getModules((String)WEB_MODULE)) != null) {
            size = modules.length;
            i = 0;
            while (i < size) {
                module2 = modules[i];
                IWebModule web = (IWebModule)module2.loadAdapter(IWebModule.class, monitor);
                if (web != null && (modules2 = web.getModules()) != null) {
                    size2 = modules2.length;
                    j = 0;
                    while (j < size2) {
                        m = webCache.get(modules2[j]);
                        if (m == null) {
                            m = new ArrayList<IModule>(2);
                            webCache.put(modules2[j], m);
                        }
                        m.add(module2);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private static boolean shouldUseCache() {
        String s = System.getProperty("J2EEcache");
        if (s == null || "".equals(s) || "false".equals(s)) {
            webCache = null;
            earCache = null;
            return false;
        }
        if (cache == null || !cache.equals(s)) {
            cache = s;
            J2EEUtil.fillCache(null);
        }
        return true;
    }
}

