/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.core.IClasspathProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;

public final class StandardJreClasspathProvider
implements IClasspathProvider {
    private static final IProjectFacet JAVA_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.java");
    private IRuntimeComponent rc;

    public StandardJreClasspathProvider(IRuntimeComponent rc) {
        this.rc = rc;
    }

    public List getClasspathEntries(IProjectFacetVersion fv) {
        if (fv.getProjectFacet() == JAVA_FACET) {
            String s = this.rc.getProperty("classpath");
            if (s == null || s.length() == 0) {
                return null;
            }
            IClasspathEntry cpentry = JavaCore.newContainerEntry((IPath)new Path(s));
            return Collections.singletonList(cpentry);
        }
        return null;
    }

    public static final class Factory
    implements IAdapterFactory {
        private static final Class[] ADAPTER_TYPES = new Class[]{IClasspathProvider.class};

        public Object getAdapter(Object adaptable, Class adapterType) {
            IRuntimeComponent rc = (IRuntimeComponent)adaptable;
            return new StandardJreClasspathProvider(rc);
        }

        public Class[] getAdapterList() {
            return ADAPTER_TYPES;
        }
    }
}

