/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.analyzer.config.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.wst.wsi.internal.core.analyzer.config.UDDIReference;
import org.eclipse.wst.wsi.internal.core.analyzer.config.WSDLElement;

public class UDDIReferenceImpl
implements UDDIReference {
    protected String keyType = null;
    protected String key = null;
    protected String inquiryURL = null;
    protected WSDLElement wsdlElement = null;
    protected String serviceLocation = null;

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        if (!keyType.equals("bindingKey") && !keyType.equals("tModelKey")) {
            throw new IllegalArgumentException("Invalid UDDI key type: [" + keyType + "].");
        }
        this.keyType = keyType;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getInquiryURL() {
        return this.inquiryURL;
    }

    public void setInquiryURL(String inquiryURL) {
        this.inquiryURL = inquiryURL;
    }

    public WSDLElement getWSDLElement() {
        return this.wsdlElement;
    }

    public void setWSDLElement(WSDLElement wsdlElement) {
        this.wsdlElement = wsdlElement;
    }

    public String getServiceLocation() {
        return this.serviceLocation;
    }

    public void setServiceLocation(String serviceLocation) {
        this.serviceLocation = serviceLocation;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("  UDDI Reference: ");
        pw.println("    UDDI Key: ");
        pw.println("      type ................... " + this.keyType);
        pw.println("      key .................... " + this.key);
        pw.println("    inquiryURL ............... " + this.inquiryURL);
        if (this.serviceLocation != null) {
            pw.println("    serviceLocation .......... " + this.serviceLocation);
        }
        if (this.wsdlElement != null) {
            pw.print(this.wsdlElement.toString());
        }
        return sw.toString();
    }

    public String toXMLString(String namespaceName) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String nsName = namespaceName;
        if (!nsName.equals("") && !nsName.endsWith(":")) {
            nsName = String.valueOf(nsName) + ":";
        }
        pw.println("      <" + nsName + "uddiReference" + ">");
        pw.print("        <" + nsName + "uddiKey" + " ");
        pw.print("type=\"" + this.getKeyType() + "\">");
        pw.print(this.getKey());
        pw.println("</" + nsName + "uddiKey" + ">");
        pw.print("        <" + nsName + "inquiryURL" + ">");
        pw.print(this.getInquiryURL());
        pw.println("</" + nsName + "inquiryURL" + ">");
        if (this.wsdlElement != null) {
            pw.print(this.getWSDLElement().toXMLString(nsName));
        }
        if (this.serviceLocation != null) {
            pw.print("        <" + nsName + "serviceLocation" + ">");
            pw.print(this.getServiceLocation());
            pw.println("        </" + nsName + "serviceLocation" + ">");
        }
        pw.println("      </" + nsName + "uddiReference" + ">");
        return sw.toString();
    }
}

