/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BP1100
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1100(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        if (this.validator.isOneWayResponse(entryContext)) {
            this.result = "notApplicable";
        } else {
            Document doc = entryContext.getMessageEntryDocument();
            if (doc == null) {
                this.result = "notApplicable";
            } else {
                Element root = doc.getDocumentElement();
                NodeList faultList = root.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
                if (faultList == null || faultList.getLength() == 0) {
                    String httpStatus = Utils.getHTTPStatusCode(entryContext.getMessageEntry().getHTTPHeaders());
                    if (!"200".equals(httpStatus)) {
                        this.result = "warning";
                        this.failureDetail = this.validator.createFailureDetail("\nResponse message:\nHeaders:\n" + entryContext.getMessageEntry().getHTTPHeaders() + "\nMessage:\n" + entryContext.getMessageEntry().getMessage(), entryContext);
                    }
                } else {
                    this.result = "notApplicable";
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

