/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.generic.core.internal.CorePlugin;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.jst.server.generic.internal.files.DirectoryScanner;
import org.eclipse.jst.server.generic.servertype.definition.ArchiveType;
import org.eclipse.jst.server.generic.servertype.definition.Classpath;
import org.eclipse.jst.server.generic.servertype.definition.ExcludeType;
import org.eclipse.jst.server.generic.servertype.definition.FilesetType;
import org.eclipse.jst.server.generic.servertype.definition.IncludeType;
import org.eclipse.jst.server.generic.servertype.definition.Module;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;

public class ServerTypeDefinitionUtil {
    static /* synthetic */ Class class$0;

    public static ServerRuntime getServerTypeDefinition(IRuntime runtime) {
        GenericServerRuntime delegate;
        if (runtime == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.generic.core.internal.GenericServerRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((delegate = (GenericServerRuntime)((Object)runtime.loadAdapter((Class)clazz, null))) == null) {
            return null;
        }
        String serverType = delegate.getRuntime().getRuntimeType().getId();
        Map properties = delegate.getServerInstanceProperties();
        ServerRuntime definition = CorePlugin.getDefault().getServerTypeDefinitionManager().getServerRuntimeDefinition(serverType, properties);
        return definition;
    }

    public static IClasspathEntry[] getServerClassPathEntry(IRuntime runtime) {
        ServerRuntime definition = ServerTypeDefinitionUtil.getServerTypeDefinition(runtime);
        if (definition == null) {
            return null;
        }
        String ref = definition.getProject().getClasspathReference();
        ArrayList entryList = ServerTypeDefinitionUtil.getClasspathEntries(ref, definition, false);
        return entryList.toArray(new IClasspathEntry[entryList.size()]);
    }

    public static ArrayList getClasspathEntries(String ref, ServerRuntime definition, boolean isLaunch) {
        Classpath cp = definition.getClasspath(ref);
        Iterator archives = cp.getArchive().iterator();
        ArrayList<Object> entryList = new ArrayList<Object>();
        while (archives.hasNext()) {
            ArchiveType archive = (ArchiveType)archives.next();
            String item = definition.getResolver().resolveProperties(archive.getPath());
            if (isLaunch) {
                entryList.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(item)));
                continue;
            }
            entryList.add(JavaCore.newLibraryEntry((IPath)new Path(item), null, null));
        }
        Iterator fileSets = cp.getFileset().iterator();
        while (fileSets.hasNext()) {
            FilesetType fileset = (FilesetType)fileSets.next();
            String dir = definition.getResolver().resolveProperties(fileset.getDir());
            Iterator includes = fileset.getInclude().iterator();
            String[] inclstr = new String[fileset.getInclude().size()];
            int i = 0;
            while (includes.hasNext()) {
                IncludeType incl = (IncludeType)includes.next();
                inclstr[i++] = definition.getResolver().resolveProperties(incl.getName());
            }
            Iterator excludes = fileset.getExclude().iterator();
            String[] exclstr = new String[fileset.getExclude().size()];
            i = 0;
            while (excludes.hasNext()) {
                ExcludeType excl = (ExcludeType)excludes.next();
                exclstr[i++] = definition.getResolver().resolveProperties(excl.getName());
            }
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(dir);
            scanner.setIncludes(inclstr);
            scanner.setExcludes(exclstr);
            scanner.scan();
            String[] filesetFiles = scanner.getIncludedFiles();
            int j = 0;
            while (j < filesetFiles.length) {
                String item = String.valueOf(dir) + "/" + filesetFiles[j];
                if (isLaunch) {
                    entryList.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(item)));
                } else {
                    entryList.add(JavaCore.newLibraryEntry((IPath)new Path(item), null, null));
                }
                ++j;
            }
        }
        return entryList;
    }

    public static String getPublisherID(IModule module, ServerRuntime serverDefinition) {
        if (module == null || module.getModuleType() == null) {
            return null;
        }
        Module m = serverDefinition.getModule(module.getModuleType().getId());
        return m.getPublisherReference();
    }
}

