/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.XMLStringEncoder;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileTools {
    public static final String USER_HOME_DIRECTORY_NAME = System.getProperty("user.home");
    public static final String USER_TEMPORARY_DIRECTORY_NAME = System.getProperty("java.io.tmpdir");
    public static String DEFAULT_TEMPORARY_DIRECTORY_NAME = "tmpdir";
    public static final String CURRENT_WORKING_DIRECTORY_NAME = System.getProperty("user.dir");
    public static final char[] INVALID_FILENAME_CHARACTERS = new char[]{':', '*', '|', '&', '/', '\\', ';', '?', '[', ']', '=', '+', '<', '>', '\"', ','};
    public static final XMLStringEncoder FILE_NAME_ENCODER = new XMLStringEncoder(INVALID_FILENAME_CHARACTERS);
    private static final String[] WINDOWS_RESERVED_FILE_NAMES = new String[]{"con", "aux", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "prn", "nul"};
    public static final int MAXIMUM_SHORTENED_FILE_NAME_LENGTH = 60;

    public static void deleteDirectory(String directoryName) {
        FileTools.deleteDirectory(new File(directoryName));
    }

    public static void deleteDirectory(File directory) {
        FileTools.deleteDirectoryContents(directory);
        if (!directory.delete()) {
            throw new RuntimeException("unable to delete directory: " + directory.getAbsolutePath());
        }
    }

    public static void deleteDirectoryContents(String directoryName) {
        FileTools.deleteDirectoryContents(new File(directoryName));
    }

    public static void deleteDirectoryContents(File directory) {
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FileTools.deleteDirectory(file);
            } else if (!file.delete()) {
                throw new RuntimeException("unable to delete file: " + file.getAbsolutePath());
            }
            ++n2;
        }
    }

    public static void copyToFile(File sourceFile, File destinationFile) throws IOException {
        FileChannel sourceChannel = new FileInputStream(sourceFile).getChannel();
        FileChannel destinationChannel = new FileOutputStream(destinationFile).getChannel();
        try {
            destinationChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
        }
        finally {
            sourceChannel.close();
            destinationChannel.close();
        }
    }

    public static void copyToDirectory(File sourceFile, File destinationDirectory) throws IOException {
        File destinationFile = new File(destinationDirectory, sourceFile.getName());
        destinationFile.createNewFile();
        FileTools.copyToFile(sourceFile, destinationFile);
    }

    public static Iterator<File> filesIn(String directoryName) {
        return FileTools.filesIn(new File(directoryName));
    }

    public static Iterator<File> filesIn(File directory) {
        return FileTools.filesIn(directory.listFiles());
    }

    private static Iterator<File> filesIn(File[] files) {
        return new FilteringIterator<File>(new ArrayIterator<File>(files)){

            @Override
            protected boolean accept(Object next) {
                return ((File)next).isFile();
            }
        };
    }

    public static Iterator<File> directoriesIn(String directoryName) {
        return FileTools.directoriesIn(new File(directoryName));
    }

    public static Iterator<File> directoriesIn(File directory) {
        return FileTools.directoriesIn(directory.listFiles());
    }

    private static Iterator<File> directoriesIn(File[] files) {
        return new FilteringIterator<File>(new ArrayIterator<File>(files)){

            @Override
            protected boolean accept(Object next) {
                return ((File)next).isDirectory();
            }
        };
    }

    public static Iterator<File> filesInTree(String directoryName) {
        return FileTools.filesInTree(new File(directoryName));
    }

    public static Iterator<File> filesInTree(File directory) {
        return FileTools.filesInTreeAsSet(directory).iterator();
    }

    private static Set<File> filesInTreeAsSet(File directory) {
        HashSet<File> files = new HashSet<File>(10000);
        FileTools.addFilesInTreeTo(directory, files);
        return files;
    }

    private static void addFilesInTreeTo(File directory, Collection<File> allFiles) {
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                allFiles.add(file);
            } else if (file.isDirectory()) {
                FileTools.addFilesInTreeTo(file, allFiles);
            }
            ++n2;
        }
    }

    public static Iterator<File> directoriesInTree(String directoryName) {
        return FileTools.directoriesInTree(new File(directoryName));
    }

    public static Iterator<File> directoriesInTree(File directory) {
        File[] files = directory.listFiles();
        return new CompositeIterator<File>(FileTools.directoriesIn(files), FileTools.directoriesInTrees(FileTools.directoriesIn(files)));
    }

    private static Iterator<File> directoriesInTrees(Iterator<File> directories) {
        return new CompositeIterator<File>((Iterator<Iterator<File>>)new TransformationIterator<File, Iterator<File>>(directories){

            @Override
            protected Iterator<File> transform(File next) {
                return FileTools.directoriesInTree(next);
            }
        });
    }

    public static String stripExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    public static String stripExtension(File file) {
        return FileTools.stripExtension(file.getPath());
    }

    public static String extension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return fileName.substring(index);
    }

    public static String extension(File file) {
        return FileTools.extension(file.getPath());
    }

    public static File emptyTemporaryDirectory(String name) {
        File dir = new File(FileTools.userTemporaryDirectory(), name);
        if (dir.exists()) {
            FileTools.deleteDirectoryContents(dir);
        } else {
            dir.mkdirs();
        }
        return dir;
    }

    public static File emptyTemporaryDirectory() {
        return FileTools.emptyTemporaryDirectory(DEFAULT_TEMPORARY_DIRECTORY_NAME);
    }

    public static File temporaryDirectory(String name) {
        File dir = new File(FileTools.userTemporaryDirectory(), name);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static File temporaryDirectory() {
        return FileTools.temporaryDirectory(DEFAULT_TEMPORARY_DIRECTORY_NAME);
    }

    public static File newTemporaryDirectory(String prefix) {
        File dir;
        if (!prefix.endsWith(".")) {
            prefix = String.valueOf(prefix) + ".";
        }
        int i = 0;
        while (!(dir = new File(FileTools.userTemporaryDirectory(), String.valueOf(prefix) + ++i)).mkdirs()) {
        }
        return dir;
    }

    public static File newTemporaryDirectory() {
        return FileTools.newTemporaryDirectory(DEFAULT_TEMPORARY_DIRECTORY_NAME);
    }

    public static File resourceFile(String resourceName) throws URISyntaxException {
        if (!resourceName.startsWith("/")) {
            throw new IllegalArgumentException(resourceName);
        }
        return FileTools.resourceFile(resourceName, FileTools.class);
    }

    public static File resourceFile(String resourceName, Class<?> javaClass) throws URISyntaxException {
        URL url = javaClass.getResource(resourceName);
        return FileTools.buildFile(url);
    }

    public static File buildFile(URL url) throws URISyntaxException {
        return FileTools.buildFile(url.getFile());
    }

    public static File buildFile(String fileName) throws URISyntaxException {
        URI uri = new URI(fileName);
        File file = new File(uri.getPath());
        return file;
    }

    public static File canonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file.getAbsoluteFile();
        }
    }

    public static Iterator<File> canonicalFiles(Iterator<File> files) {
        return new TransformationIterator<File, File>(files){

            @Override
            protected File transform(File next) {
                return FileTools.canonicalFile(next);
            }
        };
    }

    public static Iterator<File> canonicalFiles(Collection<File> files) {
        return FileTools.canonicalFiles(files.iterator());
    }

    public static String canonicalFileName(String fileName) {
        return FileTools.canonicalFile(new File(fileName)).getAbsolutePath();
    }

    public static Iterator<String> canonicalFileNames(Iterator<String> fileNames) {
        return new TransformationIterator<String, String>(fileNames){

            @Override
            protected String transform(String next) {
                return FileTools.canonicalFileName(next);
            }
        };
    }

    public static Iterator<String> canonicalFileNames(Collection<String> fileNames) {
        return FileTools.canonicalFileNames(fileNames.iterator());
    }

    public static boolean fileNameIsInvalid(String filename) {
        return !FileTools.fileNameIsValid(filename);
    }

    public static boolean fileNameIsValid(String filename) {
        int len = filename.length();
        int i = 0;
        while (i < len) {
            char filenameChar = filename.charAt(i);
            if (CollectionTools.contains(INVALID_FILENAME_CHARACTERS, filenameChar)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String convertToValidFileName(String filename, char replacementChar) {
        int len = filename.length();
        StringBuilder sb = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            char filenameChar = filename.charAt(i);
            if (CollectionTools.contains(INVALID_FILENAME_CHARACTERS, filenameChar)) {
                sb.append(replacementChar);
            } else {
                sb.append(filenameChar);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String convertToValidFileName(String filename) {
        return FileTools.convertToValidFileName(filename, '.');
    }

    public static boolean fileNameIsReserved(String fileName) {
        if (FileTools.executingOnWindows()) {
            return CollectionTools.contains(WINDOWS_RESERVED_FILE_NAMES, (Object)fileName.toLowerCase());
        }
        return false;
    }

    public static boolean fileHasAnyReservedComponents(File file) {
        File temp = file;
        while (temp != null) {
            if (FileTools.fileNameIsReserved(temp.getName())) {
                return true;
            }
            temp = temp.getParentFile();
        }
        return false;
    }

    public static String shortenFileName(URL url) {
        return FileTools.shortenFileName(url, 60);
    }

    public static String shortenFileName(URL url, int maxLength) {
        File file;
        try {
            file = FileTools.buildFile(url);
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(url.getFile());
        }
        return FileTools.shortenFileName(file, maxLength);
    }

    public static String shortenFileName(File file) {
        return FileTools.shortenFileName(file, 60);
    }

    public static String shortenFileName(File file, int maxLength) {
        String absoluteFileName = FileTools.canonicalFile(file).getAbsolutePath();
        if (absoluteFileName.length() <= maxLength) {
            return absoluteFileName;
        }
        String fs = File.separator;
        String[] paths = absoluteFileName.split("\\" + fs);
        if (paths.length <= 1) {
            return paths[0];
        }
        if (paths.length == 2) {
            return absoluteFileName;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(paths[0]);
        int insertIndex = sb.length();
        sb.append(fs);
        sb.append(paths[paths.length - 1]);
        maxLength -= 4;
        int currentLength = sb.length() - 4;
        int leftIndex = 1;
        int rightIndex = paths.length - 2;
        boolean canAddFromLeft = true;
        boolean canAddFromRight = true;
        while (canAddFromLeft || canAddFromRight) {
            if (canAddFromRight) {
                String rightDirectory = paths[rightIndex];
                int rightLength = rightDirectory.length();
                if (currentLength + rightLength + 1 <= maxLength) {
                    sb.insert(insertIndex, fs);
                    sb.insert(insertIndex + 1, rightDirectory);
                    currentLength += rightLength + 1;
                    if (leftIndex >= --rightIndex) {
                        canAddFromRight = false;
                    }
                } else {
                    canAddFromRight = false;
                }
            }
            if (!canAddFromLeft) continue;
            String leftDirectory = paths[leftIndex];
            int leftLength = leftDirectory.length();
            if (currentLength + leftLength + 1 <= maxLength) {
                sb.insert(insertIndex, fs);
                sb.insert(insertIndex + 1, leftDirectory);
                insertIndex += leftLength + 1;
                currentLength += leftLength + 1;
                if (++leftIndex < rightIndex) continue;
                canAddFromLeft = false;
                continue;
            }
            canAddFromLeft = false;
        }
        if (leftIndex <= rightIndex) {
            sb.insert(insertIndex, fs);
            sb.insert(insertIndex + 1, "...");
        }
        return sb.toString();
    }

    public static File userHomeDirectory() {
        return new File(USER_HOME_DIRECTORY_NAME);
    }

    public static File userTemporaryDirectory() {
        return new File(USER_TEMPORARY_DIRECTORY_NAME);
    }

    public static File currentWorkingDirectory() {
        return new File(CURRENT_WORKING_DIRECTORY_NAME);
    }

    private static boolean executingOnWindows() {
        return FileTools.executingOn("Windows");
    }

    private static boolean executingOn(String osName) {
        return System.getProperty("os.name").indexOf(osName) != -1;
    }

    public static Iterator<File> filter(Iterator<File> files, final FileFilter fileFilter) {
        return new FilteringIterator<File>(files){

            @Override
            protected boolean accept(Object next) {
                return fileFilter.accept((File)next);
            }
        };
    }

    public static File convertToRelativeFile(File file, File dir) {
        int firstMismatch;
        File cDir;
        if (!file.isAbsolute()) {
            return file;
        }
        File cFile = FileTools.canonicalFile(file);
        if (cFile.equals(cDir = FileTools.canonicalFile(dir))) {
            return new File(".");
        }
        File[] filePathFiles = FileTools.pathFiles(cFile);
        File[] dirPathFiles = FileTools.pathFiles(cDir);
        if (!dirPathFiles[0].equals(filePathFiles[0])) {
            return file;
        }
        int i = 0;
        while (i < dirPathFiles.length && i < filePathFiles.length) {
            if (!dirPathFiles[i].equals(filePathFiles[i])) break;
            ++i;
        }
        if ((firstMismatch = i) == filePathFiles.length) {
            return FileTools.relativeParentFile(dirPathFiles.length - firstMismatch);
        }
        File diff = new File(filePathFiles[i].getName());
        while (++i < filePathFiles.length) {
            diff = new File(diff, filePathFiles[i].getName());
        }
        if (firstMismatch == dirPathFiles.length) {
            return diff;
        }
        return new File(FileTools.relativeParentFile(dirPathFiles.length - firstMismatch), diff.getPath());
    }

    public static File convertToRelativeFile(File file) {
        return FileTools.convertToRelativeFile(file, FileTools.currentWorkingDirectory());
    }

    private static File[] pathFiles(File file) {
        ArrayList<File> path = new ArrayList<File>();
        File f = file;
        while (f != null) {
            path.add(f);
            f = f.getParentFile();
        }
        Collections.reverse(path);
        return path.toArray(new File[path.size()]);
    }

    private static File relativeParentFile(int len) {
        if (len <= 0) {
            throw new IllegalArgumentException("length must be greater than zero: " + len);
        }
        File result = new File("..");
        int i = len - 1;
        while (i-- > 0) {
            result = new File(result, "..");
        }
        return result;
    }

    public static File convertToAbsoluteFile(File file, File dir) {
        if (file.isAbsolute()) {
            return file;
        }
        return FileTools.canonicalFile(new File(dir, file.getPath()));
    }

    public static File convertToAbsoluteFile(File file) {
        return FileTools.convertToAbsoluteFile(file, FileTools.currentWorkingDirectory());
    }

    private FileTools() {
        throw new UnsupportedOperationException();
    }
}

