/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringTools {
    public static final String CR = System.getProperty("line.separator");
    public static final char QUOTE = '\"';

    public static String pad(String string, int length) {
        return StringTools.pad(string, length, ' ');
    }

    public static void padOn(String string, int length, Writer writer) {
        StringTools.padOn(string, length, ' ', writer);
    }

    public static void padOn(String string, int length, StringBuffer sb) {
        StringTools.padOn(string, length, ' ', sb);
    }

    public static void padOn(String string, int length, StringBuilder sb) {
        StringTools.padOn(string, length, ' ', sb);
    }

    public static String pad(String string, int length, char c) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return StringTools.padInternal(string, length, c);
    }

    public static void padOn(String string, int length, char c, Writer writer) {
        StringTools.padOn(string.toCharArray(), length, c, writer);
    }

    public static void padOn(String string, int length, char c, StringBuffer sb) {
        StringTools.padOn(string.toCharArray(), length, c, sb);
    }

    public static void padOn(String string, int length, char c, StringBuilder sb) {
        StringTools.padOn(string.toCharArray(), length, c, sb);
    }

    public static char[] pad(char[] string, int length) {
        return StringTools.pad(string, length, ' ');
    }

    public static void padOn(char[] string, int length, Writer writer) {
        StringTools.padOn(string, length, ' ', writer);
    }

    public static void padOn(char[] string, int length, StringBuffer sb) {
        StringTools.padOn(string, length, ' ', sb);
    }

    public static void padOn(char[] string, int length, StringBuilder sb) {
        StringTools.padOn(string, length, ' ', sb);
    }

    public static char[] pad(char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return StringTools.padInternal(string, length, c);
    }

    public static void padOn(char[] string, int length, char c, Writer writer) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.padOnInternal(string, length, c, writer);
        }
    }

    public static void padOn(char[] string, int length, char c, StringBuffer sb) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringTools.padOnInternal(string, length, c, sb);
        }
    }

    public static void padOn(char[] string, int length, char c, StringBuilder sb) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringTools.padOnInternal(string, length, c, sb);
        }
    }

    public static String padOrTruncate(String string, int length) {
        return StringTools.padOrTruncate(string, length, ' ');
    }

    public static void padOrTruncateOn(String string, int length, Writer writer) {
        StringTools.padOrTruncateOn(string, length, ' ', writer);
    }

    public static void padOrTruncateOn(String string, int length, StringBuffer sb) {
        StringTools.padOrTruncateOn(string, length, ' ', sb);
    }

    public static void padOrTruncateOn(String string, int length, StringBuilder sb) {
        StringTools.padOrTruncateOn(string, length, ' ', sb);
    }

    public static String padOrTruncate(String string, int length, char c) {
        int stringLength = string.length();
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            return string.substring(0, length);
        }
        return StringTools.padInternal(string, length, c);
    }

    public static void padOrTruncateOn(String string, int length, char c, Writer writer) {
        StringTools.padOrTruncateOn(string.toCharArray(), length, c, writer);
    }

    public static void padOrTruncateOn(String string, int length, char c, StringBuffer sb) {
        StringTools.padOrTruncateOn(string.toCharArray(), length, c, sb);
    }

    public static void padOrTruncateOn(String string, int length, char c, StringBuilder sb) {
        StringTools.padOrTruncateOn(string.toCharArray(), length, c, sb);
    }

    public static char[] padOrTruncate(char[] string, int length) {
        return StringTools.padOrTruncate(string, length, ' ');
    }

    public static void padOrTruncateOn(char[] string, int length, Writer writer) {
        StringTools.padOrTruncateOn(string, length, ' ', writer);
    }

    public static void padOrTruncate(char[] string, int length, StringBuffer sb) {
        StringTools.padOrTruncateOn(string, length, ' ', sb);
    }

    public static void padOrTruncate(char[] string, int length, StringBuilder sb) {
        StringTools.padOrTruncateOn(string, length, ' ', sb);
    }

    public static char[] padOrTruncate(char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            char[] result = new char[length];
            System.arraycopy(string, 0, result, 0, length);
            return result;
        }
        return StringTools.padInternal(string, length, c);
    }

    public static void padOrTruncateOn(char[] string, int length, char c, Writer writer) {
        int stringLength = string.length;
        if (stringLength == length) {
            StringTools.writeStringOn(string, writer);
        } else if (stringLength > length) {
            StringTools.writeStringOn(string, 0, length, writer);
        } else {
            StringTools.padOnInternal(string, length, c, writer);
        }
    }

    public static void padOrTruncateOn(char[] string, int length, char c, StringBuffer sb) {
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, 0, length);
        } else {
            StringTools.padOnInternal(string, length, c, sb);
        }
    }

    public static void padOrTruncateOn(char[] string, int length, char c, StringBuilder sb) {
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, 0, length);
        } else {
            StringTools.padOnInternal(string, length, c, sb);
        }
    }

    private static String padInternal(String string, int length, char c) {
        return new String(StringTools.padInternal(string.toCharArray(), length, c));
    }

    private static char[] padInternal(char[] string, int length, char c) {
        char[] result = new char[length];
        int stringLength = string.length;
        System.arraycopy(string, 0, result, 0, stringLength);
        Arrays.fill(result, stringLength, length, c);
        return result;
    }

    private static void padOnInternal(char[] string, int length, char c, Writer writer) {
        StringTools.writeStringOn(string, writer);
        StringTools.writeStringOn(CollectionTools.fill(new char[length - string.length], c), writer);
    }

    private static void padOnInternal(char[] string, int length, char c, StringBuffer sb) {
        sb.append(string);
        sb.append(CollectionTools.fill(new char[length - string.length], c));
    }

    private static void padOnInternal(char[] string, int length, char c, StringBuilder sb) {
        sb.append(string);
        sb.append(CollectionTools.fill(new char[length - string.length], c));
    }

    public static String zeroPad(String string, int length) {
        return StringTools.frontPad(string, length, '0');
    }

    public static void zeroPadOn(String string, int length, Writer writer) {
        StringTools.frontPadOn(string, length, '0', writer);
    }

    public static void zeroPadOn(String string, int length, StringBuffer sb) {
        StringTools.frontPadOn(string, length, '0', sb);
    }

    public static void zeroPadOn(String string, int length, StringBuilder sb) {
        StringTools.frontPadOn(string, length, '0', sb);
    }

    public static String frontPad(String string, int length, char c) {
        int stringLength = string.length();
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return StringTools.frontPadInternal(string, length, c);
    }

    public static void frontPadOn(String string, int length, char c, Writer writer) {
        StringTools.frontPadOn(string.toCharArray(), length, c, writer);
    }

    public static void frontPadOn(String string, int length, char c, StringBuffer sb) {
        StringTools.frontPadOn(string.toCharArray(), length, c, sb);
    }

    public static void frontPadOn(String string, int length, char c, StringBuilder sb) {
        StringTools.frontPadOn(string.toCharArray(), length, c, sb);
    }

    public static char[] zeroPad(char[] string, int length) {
        return StringTools.frontPad(string, length, '0');
    }

    public static void zeroPadOn(char[] string, int length, Writer writer) {
        StringTools.frontPadOn(string, length, '0', writer);
    }

    public static void zeroPadOn(char[] string, int length, StringBuffer sb) {
        StringTools.frontPadOn(string, length, '0', sb);
    }

    public static void zeroPadOn(char[] string, int length, StringBuilder sb) {
        StringTools.frontPadOn(string, length, '0', sb);
    }

    public static char[] frontPad(char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            return string;
        }
        return StringTools.frontPadInternal(string, length, c);
    }

    public static void frontPadOn(char[] string, int length, char c, Writer writer) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.frontPadOnInternal(string, length, c, writer);
        }
    }

    public static void frontPadOn(char[] string, int length, char c, StringBuffer sb) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringTools.frontPadOnInternal(string, length, c, sb);
        }
    }

    public static void frontPadOn(char[] string, int length, char c, StringBuilder sb) {
        int stringLength = string.length;
        if (stringLength > length) {
            throw new IllegalArgumentException("String is too long: " + stringLength + " > " + length);
        }
        if (stringLength == length) {
            sb.append(string);
        } else {
            StringTools.frontPadOnInternal(string, length, c, sb);
        }
    }

    public static String zeroPadOrTruncate(String string, int length) {
        return StringTools.frontPadOrTruncate(string, length, '0');
    }

    public static void zeroPadOrTruncateOn(String string, int length, Writer writer) {
        StringTools.frontPadOrTruncateOn(string, length, '0', writer);
    }

    public static void zeroPadOrTruncateOn(String string, int length, StringBuffer sb) {
        StringTools.frontPadOrTruncateOn(string, length, '0', sb);
    }

    public static void zeroPadOrTruncateOn(String string, int length, StringBuilder sb) {
        StringTools.frontPadOrTruncateOn(string, length, '0', sb);
    }

    public static String frontPadOrTruncate(String string, int length, char c) {
        int stringLength = string.length();
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            return string.substring(stringLength - length);
        }
        return StringTools.frontPadInternal(string, length, c);
    }

    public static void frontPadOrTruncateOn(String string, int length, char c, Writer writer) {
        StringTools.frontPadOrTruncateOn(string.toCharArray(), length, c, writer);
    }

    public static void frontPadOrTruncateOn(String string, int length, char c, StringBuffer sb) {
        StringTools.frontPadOrTruncateOn(string.toCharArray(), length, c, sb);
    }

    public static void frontPadOrTruncateOn(String string, int length, char c, StringBuilder sb) {
        StringTools.frontPadOrTruncateOn(string.toCharArray(), length, c, sb);
    }

    public static char[] zeroPadOrTruncate(char[] string, int length) {
        return StringTools.frontPadOrTruncate(string, length, '0');
    }

    public static void zeroPadOrTruncateOn(char[] string, int length, Writer writer) {
        StringTools.frontPadOrTruncateOn(string, length, '0', writer);
    }

    public static void zeroPadOrTruncateOn(char[] string, int length, StringBuffer sb) {
        StringTools.frontPadOrTruncateOn(string, length, '0', sb);
    }

    public static void zeroPadOrTruncateOn(char[] string, int length, StringBuilder sb) {
        StringTools.frontPadOrTruncateOn(string, length, '0', sb);
    }

    public static char[] frontPadOrTruncate(char[] string, int length, char c) {
        int stringLength = string.length;
        if (stringLength == length) {
            return string;
        }
        if (stringLength > length) {
            char[] result = new char[length];
            System.arraycopy(string, stringLength - length, result, 0, length);
            return result;
        }
        return StringTools.frontPadInternal(string, length, c);
    }

    public static void frontPadOrTruncateOn(char[] string, int length, char c, Writer writer) {
        int stringLength = string.length;
        if (stringLength == length) {
            StringTools.writeStringOn(string, writer);
        } else if (stringLength > length) {
            StringTools.writeStringOn(string, stringLength - length, length, writer);
        } else {
            StringTools.frontPadOnInternal(string, length, c, writer);
        }
    }

    public static void frontPadOrTruncateOn(char[] string, int length, char c, StringBuffer sb) {
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, stringLength - length, length);
        } else {
            StringTools.frontPadOnInternal(string, length, c, sb);
        }
    }

    public static void frontPadOrTruncateOn(char[] string, int length, char c, StringBuilder sb) {
        int stringLength = string.length;
        if (stringLength == length) {
            sb.append(string);
        } else if (stringLength > length) {
            sb.append(string, stringLength - length, length);
        } else {
            StringTools.frontPadOnInternal(string, length, c, sb);
        }
    }

    private static String frontPadInternal(String string, int length, char c) {
        return new String(StringTools.frontPadInternal(string.toCharArray(), length, c));
    }

    private static char[] frontPadInternal(char[] string, int length, char c) {
        char[] result = new char[length];
        int stringLength = string.length;
        int padLength = length - stringLength;
        System.arraycopy(string, 0, result, padLength, stringLength);
        Arrays.fill(result, 0, padLength, c);
        return result;
    }

    private static void frontPadOnInternal(char[] string, int length, char c, Writer writer) {
        StringTools.writeStringOn(CollectionTools.fill(new char[length - string.length], c), writer);
        StringTools.writeStringOn(string, writer);
    }

    private static void frontPadOnInternal(char[] string, int length, char c, StringBuffer sb) {
        sb.append(CollectionTools.fill(new char[length - string.length], c));
        sb.append(string);
    }

    private static void frontPadOnInternal(char[] string, int length, char c, StringBuilder sb) {
        sb.append(CollectionTools.fill(new char[length - string.length], c));
        sb.append(string);
    }

    public static String quote(String string) {
        return StringTools.wrap(string, '\"');
    }

    public static void quoteOn(String string, Writer writer) {
        StringTools.wrapOn(string, '\"', writer);
    }

    public static void quoteOn(String string, StringBuffer sb) {
        StringTools.wrapOn(string, '\"', sb);
    }

    public static void quoteOn(String string, StringBuilder sb) {
        StringTools.wrapOn(string, '\"', sb);
    }

    public static Iterator<String> quote(Iterator<String> strings) {
        return new TransformationIterator<String, String>(strings){

            @Override
            protected String transform(String string) {
                return StringTools.quote(string);
            }
        };
    }

    public static String wrap(String string, char wrap) {
        return new String(StringTools.wrap(string.toCharArray(), wrap));
    }

    public static void wrapOn(String string, char wrap, Writer writer) {
        StringTools.wrapOn(string.toCharArray(), wrap, writer);
    }

    public static void wrapOn(String string, char wrap, StringBuffer sb) {
        StringTools.wrapOn(string.toCharArray(), wrap, sb);
    }

    public static void wrapOn(String string, char wrap, StringBuilder sb) {
        StringTools.wrapOn(string.toCharArray(), wrap, sb);
    }

    public static Iterator<String> wrap(Iterator<String> strings, final char wrap) {
        return new TransformationIterator<String, String>(strings){

            @Override
            protected String transform(String string) {
                return StringTools.wrap(string, wrap);
            }
        };
    }

    public static String wrap(String string, String wrap) {
        return new String(StringTools.wrap(string.toCharArray(), wrap.toCharArray()));
    }

    public static void wrapOn(String string, String wrap, Writer writer) {
        StringTools.wrapOn(string.toCharArray(), wrap.toCharArray(), writer);
    }

    public static void wrapOn(String string, String wrap, StringBuffer sb) {
        StringTools.wrapOn(string.toCharArray(), wrap.toCharArray(), sb);
    }

    public static void wrapOn(String string, String wrap, StringBuilder sb) {
        StringTools.wrapOn(string.toCharArray(), wrap.toCharArray(), sb);
    }

    public static Iterator<String> wrap(Iterator<String> strings, final String wrap) {
        return new TransformationIterator<String, String>(strings){

            @Override
            protected String transform(String string) {
                return StringTools.wrap(string, wrap);
            }
        };
    }

    public static char[] quote(char[] string) {
        return StringTools.wrap(string, '\"');
    }

    public static void quoteOn(char[] string, Writer writer) {
        StringTools.wrapOn(string, '\"', writer);
    }

    public static void quoteOn(char[] string, StringBuffer sb) {
        StringTools.wrapOn(string, '\"', sb);
    }

    public static void quoteOn(char[] string, StringBuilder sb) {
        StringTools.wrapOn(string, '\"', sb);
    }

    public static Iterator<char[]> quoteCharArrays(Iterator<char[]> strings) {
        return new TransformationIterator<char[], char[]>(strings){

            @Override
            protected char[] transform(char[] string) {
                return StringTools.quote(string);
            }
        };
    }

    public static char[] wrap(char[] string, char wrap) {
        int len = string.length;
        char[] result = new char[len + 2];
        result[0] = wrap;
        System.arraycopy(string, 0, result, 1, len);
        result[len + 1] = wrap;
        return result;
    }

    public static void wrapOn(char[] string, char wrap, Writer writer) {
        StringTools.writeCharOn(wrap, writer);
        StringTools.writeStringOn(string, writer);
        StringTools.writeCharOn(wrap, writer);
    }

    public static void wrapOn(char[] string, char wrap, StringBuffer sb) {
        sb.append(wrap);
        sb.append(string);
        sb.append(wrap);
    }

    public static void wrapOn(char[] string, char wrap, StringBuilder sb) {
        sb.append(wrap);
        sb.append(string);
        sb.append(wrap);
    }

    public static Iterator<char[]> wrapCharArrays(Iterator<char[]> strings, final char wrap) {
        return new TransformationIterator<char[], char[]>(strings){

            @Override
            protected char[] transform(char[] string) {
                return StringTools.wrap(string, wrap);
            }
        };
    }

    public static char[] wrap(char[] string, char[] wrap) {
        int stringLength = string.length;
        int wrapLength = wrap.length;
        char[] result = new char[stringLength + 2 * wrapLength];
        System.arraycopy(wrap, 0, result, 0, wrapLength);
        System.arraycopy(string, 0, result, wrapLength, stringLength);
        System.arraycopy(wrap, 0, result, stringLength + wrapLength, wrapLength);
        return result;
    }

    public static void wrapOn(char[] string, char[] wrap, Writer writer) {
        StringTools.writeStringOn(wrap, writer);
        StringTools.writeStringOn(string, writer);
        StringTools.writeStringOn(wrap, writer);
    }

    public static void wrapOn(char[] string, char[] wrap, StringBuffer sb) {
        sb.append(wrap);
        sb.append(string);
        sb.append(wrap);
    }

    public static void wrapOn(char[] string, char[] wrap, StringBuilder sb) {
        sb.append(wrap);
        sb.append(string);
        sb.append(wrap);
    }

    public static Iterator<char[]> wrapCharArrays(Iterator<char[]> strings, final char[] wrap) {
        return new TransformationIterator<char[], char[]>(strings){

            @Override
            protected char[] transform(char[] string) {
                return StringTools.wrap(string, wrap);
            }
        };
    }

    public static String removeFirstOccurrence(String string, char c) {
        int index = string.indexOf(c);
        if (index == -1) {
            return string;
        }
        if (index == 0) {
            return string.substring(1);
        }
        int last = string.length() - 1;
        if (index == last) {
            return string.substring(0, last);
        }
        return string.substring(0, index).concat(string.substring(index + 1));
    }

    public static void removeFirstOccurrenceOn(String string, char c, Writer writer) {
        StringTools.removeFirstOccurrenceOn(string.toCharArray(), c, writer);
    }

    public static void removeFirstOccurrenceOn(String string, char c, StringBuffer sb) {
        StringTools.removeFirstOccurrenceOn(string.toCharArray(), c, sb);
    }

    public static void removeFirstOccurrenceOn(String string, char c, StringBuilder sb) {
        StringTools.removeFirstOccurrenceOn(string.toCharArray(), c, sb);
    }

    public static char[] removeFirstOccurrence(char[] string, char c) {
        int index = CollectionTools.indexOf(string, c);
        if (index == -1) {
            return string;
        }
        int len = string.length - 1;
        char[] result = new char[len];
        if (index == 0) {
            System.arraycopy(string, 1, result, 0, len);
        } else if (index == len) {
            System.arraycopy(string, 0, result, 0, len);
        } else {
            System.arraycopy(string, 0, result, 0, index);
            System.arraycopy(string, index + 1, result, index, len - index);
        }
        return result;
    }

    public static void removeFirstOccurrenceOn(char[] string, char c, Writer writer) {
        int index = CollectionTools.indexOf(string, c);
        if (index == -1) {
            StringTools.writeStringOn(string, writer);
            return;
        }
        int len = string.length - 1;
        if (index == 0) {
            StringTools.writeStringOn(string, 1, len, writer);
        } else if (index == len) {
            StringTools.writeStringOn(string, 0, len, writer);
        } else {
            StringTools.writeStringOn(string, 0, index, writer);
            StringTools.writeStringOn(string, index + 1, len - index, writer);
        }
    }

    public static void removeFirstOccurrenceOn(char[] string, char c, StringBuffer sb) {
        int index = CollectionTools.indexOf(string, c);
        if (index == -1) {
            sb.append(string);
            return;
        }
        int len = string.length - 1;
        if (index == 0) {
            sb.append(string, 1, len);
        } else if (index == len) {
            sb.append(string, 0, len);
        } else {
            sb.append(string, 0, index);
            sb.append(string, index + 1, len - index);
        }
    }

    public static void removeFirstOccurrenceOn(char[] string, char c, StringBuilder sb) {
        int index = CollectionTools.indexOf(string, c);
        if (index == -1) {
            sb.append(string);
            return;
        }
        int len = string.length - 1;
        if (index == 0) {
            sb.append(string, 1, len);
        } else if (index == len) {
            sb.append(string, 0, len);
        } else {
            sb.append(string, 0, index);
            sb.append(string, index + 1, len - index);
        }
    }

    public static String removeAllOccurrences(String string, char c) {
        return new String(StringTools.removeAllOccurrences(string.toCharArray(), c));
    }

    public static void removeAllOccurrencesOn(String string, char c, Writer writer) {
        StringTools.removeAllOccurrencesOn(string.toCharArray(), c, writer);
    }

    public static void removeAllOccurrencesOn(String string, char c, StringBuffer sb) {
        StringTools.removeAllOccurrencesOn(string.toCharArray(), c, sb);
    }

    public static void removeAllOccurrencesOn(String string, char c, StringBuilder sb) {
        StringTools.removeAllOccurrencesOn(string.toCharArray(), c, sb);
    }

    public static char[] removeAllOccurrences(char[] string, char c) {
        StringBuilder sb = new StringBuilder(string.length);
        StringTools.removeAllOccurrencesOn(string, c, sb);
        int len = sb.length();
        char[] result = new char[len];
        sb.getChars(0, len, result, 0);
        return result;
    }

    public static void removeAllOccurrencesOn(char[] string, char c, Writer writer) {
        StringTools.removeAllOccurrencesOnInternal(string, c, writer);
    }

    private static void removeAllOccurrencesOnInternal(char[] string, char c, Writer writer) {
        char[] cArray = string;
        int n = string.length;
        int n2 = 0;
        while (n2 < n) {
            char d = cArray[n2];
            if (d != c) {
                StringTools.writeCharOn(d, writer);
            }
            ++n2;
        }
    }

    public static void removeAllOccurrencesOn(char[] string, char c, StringBuffer sb) {
        char[] cArray = string;
        int n = string.length;
        int n2 = 0;
        while (n2 < n) {
            char d = cArray[n2];
            if (d != c) {
                sb.append(d);
            }
            ++n2;
        }
    }

    public static void removeAllOccurrencesOn(char[] string, char c, StringBuilder sb) {
        char[] cArray = string;
        int n = string.length;
        int n2 = 0;
        while (n2 < n) {
            char d = cArray[n2];
            if (d != c) {
                sb.append(d);
            }
            ++n2;
        }
    }

    public static String removeAllSpaces(String string) {
        return StringTools.removeAllOccurrences(string, ' ');
    }

    public static int commonPrefixLength(String s1, String s2) {
        return StringTools.commonPrefixLength(s1.toCharArray(), s2.toCharArray());
    }

    public static int commonPrefixLength(char[] s1, char[] s2) {
        return StringTools.commonPrefixLengthInternal(s1, s2, Math.min(s1.length, s2.length));
    }

    public static int commonPrefixLength(String s1, String s2, int max) {
        return StringTools.commonPrefixLength(s1.toCharArray(), s2.toCharArray(), max);
    }

    public static int commonPrefixLength(char[] s1, char[] s2, int max) {
        return StringTools.commonPrefixLengthInternal(s1, s2, Math.min(max, Math.min(s1.length, s2.length)));
    }

    private static int commonPrefixLengthInternal(char[] s1, char[] s2, int max) {
        int i = 0;
        while (i < max) {
            if (s1[i] != s2[i]) {
                return i;
            }
            ++i;
        }
        return max;
    }

    private static char[] capitalizeInternal(char[] string) {
        string[0] = Character.toUpperCase(string[0]);
        return string;
    }

    public static char[] capitalize(char[] string) {
        if (string.length == 0 || Character.isUpperCase(string[0])) {
            return string;
        }
        return StringTools.capitalizeInternal(string);
    }

    public static String capitalize(String string) {
        if (string.length() == 0 || Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        return new String(StringTools.capitalizeInternal(string.toCharArray()));
    }

    private static void capitalizeOnInternal(char[] string, StringBuffer sb) {
        sb.append(Character.toUpperCase(string[0]));
        sb.append(string, 1, string.length - 1);
    }

    private static void capitalizeOnInternal(char[] string, StringBuilder sb) {
        sb.append(Character.toUpperCase(string[0]));
        sb.append(string, 1, string.length - 1);
    }

    public static void capitalizeOn(char[] string, StringBuffer sb) {
        if (string.length == 0) {
            return;
        }
        if (Character.isUpperCase(string[0])) {
            sb.append(string);
        } else {
            StringTools.capitalizeOnInternal(string, sb);
        }
    }

    public static void capitalizeOn(char[] string, StringBuilder sb) {
        if (string.length == 0) {
            return;
        }
        if (Character.isUpperCase(string[0])) {
            sb.append(string);
        } else {
            StringTools.capitalizeOnInternal(string, sb);
        }
    }

    public static void capitalizeOn(String string, StringBuffer sb) {
        if (string.length() == 0) {
            return;
        }
        if (Character.isUpperCase(string.charAt(0))) {
            sb.append(string);
        } else {
            StringTools.capitalizeOnInternal(string.toCharArray(), sb);
        }
    }

    public static void capitalizeOn(String string, StringBuilder sb) {
        if (string.length() == 0) {
            return;
        }
        if (Character.isUpperCase(string.charAt(0))) {
            sb.append(string);
        } else {
            StringTools.capitalizeOnInternal(string.toCharArray(), sb);
        }
    }

    private static void capitalizeOnInternal(char[] string, Writer writer) {
        StringTools.writeCharOn(Character.toUpperCase(string[0]), writer);
        StringTools.writeStringOn(string, 1, string.length - 1, writer);
    }

    public static void capitalizeOn(char[] string, Writer writer) {
        if (string.length == 0) {
            return;
        }
        if (Character.isUpperCase(string[0])) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.capitalizeOnInternal(string, writer);
        }
    }

    public static void capitalizeOn(String string, Writer writer) {
        if (string.length() == 0) {
            return;
        }
        if (Character.isUpperCase(string.charAt(0))) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.capitalizeOnInternal(string.toCharArray(), writer);
        }
    }

    private static char[] uncapitalizeInternal(char[] string) {
        string[0] = Character.toLowerCase(string[0]);
        return string;
    }

    private static boolean stringNeedNotBeUncapitalized(char[] string) {
        if (string.length == 0) {
            return true;
        }
        if (Character.isLowerCase(string[0])) {
            return true;
        }
        return string.length > 1 && Character.isUpperCase(string[1]) && Character.isUpperCase(string[0]);
    }

    public static char[] uncapitalize(char[] string) {
        if (StringTools.stringNeedNotBeUncapitalized(string)) {
            return string;
        }
        return StringTools.uncapitalizeInternal(string);
    }

    private static boolean stringNeedNotBeUncapitalized(String string) {
        if (string.length() == 0) {
            return true;
        }
        if (Character.isLowerCase(string.charAt(0))) {
            return true;
        }
        return string.length() > 1 && Character.isUpperCase(string.charAt(1)) && Character.isUpperCase(string.charAt(0));
    }

    public static String uncapitalize(String string) {
        if (StringTools.stringNeedNotBeUncapitalized(string)) {
            return string;
        }
        return new String(StringTools.uncapitalizeInternal(string.toCharArray()));
    }

    private static void uncapitalizeOnInternal(char[] string, StringBuffer sb) {
        sb.append(Character.toLowerCase(string[0]));
        sb.append(string, 1, string.length - 1);
    }

    private static void uncapitalizeOnInternal(char[] string, StringBuilder sb) {
        sb.append(Character.toLowerCase(string[0]));
        sb.append(string, 1, string.length - 1);
    }

    public static void uncapitalizeOn(char[] string, StringBuffer sb) {
        if (StringTools.stringNeedNotBeUncapitalized(string)) {
            sb.append(string);
        } else {
            StringTools.uncapitalizeOnInternal(string, sb);
        }
    }

    public static void uncapitalizeOn(char[] string, StringBuilder sb) {
        if (StringTools.stringNeedNotBeUncapitalized(string)) {
            sb.append(string);
        } else {
            StringTools.uncapitalizeOnInternal(string, sb);
        }
    }

    public static void uncapitalizeOn(String string, StringBuffer sb) {
        if (StringTools.stringNeedNotBeUncapitalized(string)) {
            sb.append(string);
        } else {
            StringTools.uncapitalizeOnInternal(string.toCharArray(), sb);
        }
    }

    public static void uncapitalizeOn(String string, StringBuilder sb) {
        if (StringTools.stringNeedNotBeUncapitalized(string)) {
            sb.append(string);
        } else {
            StringTools.uncapitalizeOnInternal(string.toCharArray(), sb);
        }
    }

    private static void uncapitalizeOnInternal(char[] string, Writer writer) {
        StringTools.writeCharOn(Character.toLowerCase(string[0]), writer);
        StringTools.writeStringOn(string, 1, string.length - 1, writer);
    }

    public static void uncapitalizeOn(char[] string, Writer writer) {
        if (StringTools.stringNeedNotBeUncapitalized(string)) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.uncapitalizeOnInternal(string, writer);
        }
    }

    public static void uncapitalizeOn(String string, Writer writer) {
        if (StringTools.stringNeedNotBeUncapitalized(string)) {
            StringTools.writeStringOn(string, writer);
        } else {
            StringTools.uncapitalizeOnInternal(string.toCharArray(), writer);
        }
    }

    public static String buildToStringFor(Object o, Object additionalInfo) {
        StringBuilder sb = new StringBuilder();
        StringTools.buildSimpleToStringOn(o, sb);
        sb.append(" (");
        sb.append(additionalInfo);
        sb.append(')');
        return sb.toString();
    }

    public static String buildToStringFor(Object o) {
        StringBuilder sb = new StringBuilder();
        StringTools.buildSimpleToStringOn(o, sb);
        return sb.toString();
    }

    public static void buildSimpleToStringOn(Object o, StringBuffer sb) {
        sb.append(ClassTools.toStringClassNameForObject(o));
        sb.append('[');
        sb.append(StringTools.zeroPad(Integer.toHexString(System.identityHashCode(o)).toUpperCase(), 8));
        sb.append(']');
    }

    public static void buildSimpleToStringOn(Object o, StringBuilder sb) {
        sb.append(ClassTools.toStringClassNameForObject(o));
        sb.append('[');
        sb.append(StringTools.zeroPad(Integer.toHexString(System.identityHashCode(o)).toUpperCase(), 8));
        sb.append(']');
    }

    public static boolean stringIsEmpty(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        return StringTools.stringIsEmptyInternal(string.toCharArray());
    }

    public static boolean stringIsEmpty(char[] string) {
        if (string == null || string.length == 0) {
            return true;
        }
        return StringTools.stringIsEmptyInternal(string);
    }

    private static boolean stringIsEmptyInternal(char[] s) {
        int i = s.length;
        while (i-- > 0) {
            if (Character.isWhitespace(s[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean stringsAreEqualIgnoreCase(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean stringsAreEqualIgnoreCase(char[] s1, char[] s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (s1.length != s2.length) {
            return false;
        }
        int i = s1.length;
        while (i-- > 0) {
            if (StringTools.charactersAreEqualIgnoreCase(s1[i], s2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean stringStartsWithIgnoreCase(char[] string, char[] prefix) {
        if (string.length < prefix.length) {
            return false;
        }
        int i = prefix.length;
        while (i-- > 0) {
            if (StringTools.charactersAreEqualIgnoreCase(string[i], prefix[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean stringStartsWithIgnoreCase(String string, String prefix) {
        return string.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean charactersAreEqualIgnoreCase(char c1, char c2) {
        return c1 == c2 || Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2);
    }

    public static String convertCamelCaseToAllCaps(String camelCaseString) {
        return new String(StringTools.convertCamelCaseToAllCaps(camelCaseString.toCharArray()));
    }

    public static char[] convertCamelCaseToAllCaps(char[] camelCaseString) {
        int len = camelCaseString.length;
        if (len == 0) {
            return camelCaseString;
        }
        StringBuilder sb = new StringBuilder(len * 2);
        StringTools.convertCamelCaseToAllCapsOnInternal(camelCaseString, len, sb);
        return StringTools.convertToCharArray(sb);
    }

    public static void convertCamelCaseToAllCapsOn(String camelCaseString, StringBuffer sb) {
        StringTools.convertCamelCaseToAllCapsOn(camelCaseString.toCharArray(), sb);
    }

    public static void convertCamelCaseToAllCapsOn(String camelCaseString, StringBuilder sb) {
        StringTools.convertCamelCaseToAllCapsOn(camelCaseString.toCharArray(), sb);
    }

    public static void convertCamelCaseToAllCapsOn(char[] camelCaseString, StringBuffer sb) {
        int len = camelCaseString.length;
        if (len != 0) {
            StringTools.convertCamelCaseToAllCapsOnInternal(camelCaseString, len, sb);
        }
    }

    public static void convertCamelCaseToAllCapsOn(char[] camelCaseString, StringBuilder sb) {
        int len = camelCaseString.length;
        if (len != 0) {
            StringTools.convertCamelCaseToAllCapsOnInternal(camelCaseString, len, sb);
        }
    }

    private static void convertCamelCaseToAllCapsOnInternal(char[] camelCaseString, int len, StringBuffer sb) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= len) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                sb.append('_');
            }
            sb.append(Character.toUpperCase(c));
            prev = c;
            ++i;
        }
    }

    private static void convertCamelCaseToAllCapsOnInternal(char[] camelCaseString, int len, StringBuilder sb) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= len) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                sb.append('_');
            }
            sb.append(Character.toUpperCase(c));
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCapsOn(String camelCaseString, Writer writer) {
        StringTools.convertCamelCaseToAllCapsOn(camelCaseString.toCharArray(), writer);
    }

    public static void convertCamelCaseToAllCapsOn(char[] camelCaseString, Writer writer) {
        int len = camelCaseString.length;
        if (len != 0) {
            StringTools.convertCamelCaseToAllCapsOnInternal(camelCaseString, len, writer);
        }
    }

    private static void convertCamelCaseToAllCapsOnInternal(char[] camelCaseString, int len, Writer writer) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= len) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                StringTools.writeCharOn('_', writer);
            }
            StringTools.writeCharOn(Character.toUpperCase(c), writer);
            prev = c;
            ++i;
        }
    }

    public static String convertCamelCaseToAllCaps(String camelCaseString, int maxLength) {
        return new String(StringTools.convertCamelCaseToAllCaps(camelCaseString.toCharArray(), maxLength));
    }

    public static char[] convertCamelCaseToAllCaps(char[] camelCaseString, int maxLength) {
        int len = camelCaseString.length;
        if (len == 0 || maxLength == 0) {
            return camelCaseString;
        }
        StringBuilder sb = new StringBuilder(maxLength);
        StringTools.convertCamelCaseToAllCapsOnInternal(camelCaseString, maxLength, len, sb);
        return StringTools.convertToCharArray(sb);
    }

    public static void convertCamelCaseToAllCapsOn(String camelCaseString, int maxLength, StringBuffer sb) {
        StringTools.convertCamelCaseToAllCapsOn(camelCaseString.toCharArray(), maxLength, sb);
    }

    public static void convertCamelCaseToAllCapsOn(String camelCaseString, int maxLength, StringBuilder sb) {
        StringTools.convertCamelCaseToAllCapsOn(camelCaseString.toCharArray(), maxLength, sb);
    }

    public static void convertCamelCaseToAllCapsOn(char[] camelCaseString, int maxLength, StringBuffer sb) {
        int len = camelCaseString.length;
        if (len != 0 && maxLength != 0) {
            StringTools.convertCamelCaseToAllCapsOnInternal(camelCaseString, maxLength, len, sb);
        }
    }

    public static void convertCamelCaseToAllCapsOn(char[] camelCaseString, int maxLength, StringBuilder sb) {
        int len = camelCaseString.length;
        if (len != 0 && maxLength != 0) {
            StringTools.convertCamelCaseToAllCapsOnInternal(camelCaseString, maxLength, len, sb);
        }
    }

    private static void convertCamelCaseToAllCapsOnInternal(char[] camelCaseString, int maxLength, int len, StringBuffer sb) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= len) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                sb.append('_');
                if (sb.length() == maxLength) {
                    return;
                }
            }
            sb.append(Character.toUpperCase(c));
            if (sb.length() == maxLength) {
                return;
            }
            prev = c;
            ++i;
        }
    }

    private static void convertCamelCaseToAllCapsOnInternal(char[] camelCaseString, int maxLength, int len, StringBuilder sb) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int i = 1;
        while (i <= len) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                sb.append('_');
                if (sb.length() == maxLength) {
                    return;
                }
            }
            sb.append(Character.toUpperCase(c));
            if (sb.length() == maxLength) {
                return;
            }
            prev = c;
            ++i;
        }
    }

    public static void convertCamelCaseToAllCapsOn(String camelCaseString, int maxLength, Writer writer) {
        StringTools.convertCamelCaseToAllCapsOn(camelCaseString.toCharArray(), maxLength, writer);
    }

    public static void convertCamelCaseToAllCapsOn(char[] camelCaseString, int maxLength, Writer writer) {
        int len = camelCaseString.length;
        if (len != 0 && maxLength != 0) {
            StringTools.convertCamelCaseToAllCapsOnInternal(camelCaseString, maxLength, len, writer);
        }
    }

    private static void convertCamelCaseToAllCapsOnInternal(char[] camelCaseString, int maxLength, int len, Writer writer) {
        char prev = '\u0000';
        char c = '\u0000';
        char next = camelCaseString[0];
        int writerLength = 0;
        int i = 1;
        while (i <= len) {
            c = next;
            char c2 = next = i == len ? (char)'\u0000' : camelCaseString[i];
            if (StringTools.camelCaseWordBreak(prev, c, next)) {
                StringTools.writeCharOn('_', writer);
                if (++writerLength == maxLength) {
                    return;
                }
            }
            StringTools.writeCharOn(Character.toUpperCase(c), writer);
            if (++writerLength == maxLength) {
                return;
            }
            prev = c;
            ++i;
        }
    }

    private static boolean camelCaseWordBreak(char prev, char c, char next) {
        if (prev == '\u0000') {
            return false;
        }
        if (Character.isLowerCase(c)) {
            return false;
        }
        if (Character.isLowerCase(prev)) {
            return true;
        }
        if (next == '\u0000') {
            return false;
        }
        return Character.isLowerCase(next);
    }

    public static String convertUnderscoresToCamelCase(String underscoreString) {
        return new String(StringTools.convertUnderscoresToCamelCase(underscoreString.toCharArray()));
    }

    public static char[] convertUnderscoresToCamelCase(char[] underscoreString) {
        return StringTools.convertUnderscoresToCamelCase(underscoreString, true);
    }

    public static String convertUnderscoresToCamelCase(String underscoreString, boolean capitalizeFirstLetter) {
        return new String(StringTools.convertUnderscoresToCamelCase(underscoreString.toCharArray(), capitalizeFirstLetter));
    }

    public static char[] convertUnderscoresToCamelCase(char[] underscoreString, boolean capitalizeFirstLetter) {
        int len = underscoreString.length;
        if (len == 0) {
            return underscoreString;
        }
        StringBuilder sb = new StringBuilder(len);
        StringTools.convertUnderscoresToCamelCaseOnInternal(underscoreString, capitalizeFirstLetter, len, sb);
        return StringTools.convertToCharArray(sb);
    }

    public static void convertUnderscoresToCamelCaseOn(String underscoreString, boolean capitalizeFirstLetter, StringBuffer sb) {
        StringTools.convertUnderscoresToCamelCaseOn(underscoreString.toCharArray(), capitalizeFirstLetter, sb);
    }

    public static void convertUnderscoresToCamelCaseOn(String underscoreString, boolean capitalizeFirstLetter, StringBuilder sb) {
        StringTools.convertUnderscoresToCamelCaseOn(underscoreString.toCharArray(), capitalizeFirstLetter, sb);
    }

    public static void convertUnderscoresToCamelCaseOn(char[] underscoreString, boolean capitalizeFirstLetter, StringBuffer sb) {
        int len = underscoreString.length;
        if (len != 0) {
            StringTools.convertUnderscoresToCamelCaseOnInternal(underscoreString, capitalizeFirstLetter, len, sb);
        }
    }

    public static void convertUnderscoresToCamelCaseOn(char[] underscoreString, boolean capitalizeFirstLetter, StringBuilder sb) {
        int len = underscoreString.length;
        if (len != 0) {
            StringTools.convertUnderscoresToCamelCaseOnInternal(underscoreString, capitalizeFirstLetter, len, sb);
        }
    }

    private static void convertUnderscoresToCamelCaseOnInternal(char[] underscoreString, boolean capitalizeFirstLetter, int len, StringBuffer sb) {
        char prev = '\u0000';
        char c = '\u0000';
        boolean first = true;
        int i = 0;
        while (i < len) {
            prev = c;
            c = underscoreString[i];
            if (c != '_') {
                if (first) {
                    first = false;
                    if (capitalizeFirstLetter) {
                        sb.append(Character.toUpperCase(c));
                    } else {
                        sb.append(Character.toLowerCase(c));
                    }
                } else if (prev == '_') {
                    sb.append(Character.toUpperCase(c));
                } else {
                    sb.append(Character.toLowerCase(c));
                }
            }
            ++i;
        }
    }

    private static void convertUnderscoresToCamelCaseOnInternal(char[] underscoreString, boolean capitalizeFirstLetter, int len, StringBuilder sb) {
        char prev = '\u0000';
        char c = '\u0000';
        boolean first = true;
        int i = 0;
        while (i < len) {
            prev = c;
            c = underscoreString[i];
            if (c != '_') {
                if (first) {
                    first = false;
                    if (capitalizeFirstLetter) {
                        sb.append(Character.toUpperCase(c));
                    } else {
                        sb.append(Character.toLowerCase(c));
                    }
                } else if (prev == '_') {
                    sb.append(Character.toUpperCase(c));
                } else {
                    sb.append(Character.toLowerCase(c));
                }
            }
            ++i;
        }
    }

    public static void convertUnderscoresToCamelCaseOn(String underscoreString, boolean capitalizeFirstLetter, Writer writer) {
        StringTools.convertUnderscoresToCamelCaseOn(underscoreString.toCharArray(), capitalizeFirstLetter, writer);
    }

    public static void convertUnderscoresToCamelCaseOn(char[] underscoreString, boolean capitalizeFirstLetter, Writer writer) {
        int len = underscoreString.length;
        if (len != 0) {
            StringTools.convertUnderscoresToCamelCaseOnInternal(underscoreString, capitalizeFirstLetter, len, writer);
        }
    }

    private static void convertUnderscoresToCamelCaseOnInternal(char[] underscoreString, boolean capitalizeFirstLetter, int len, Writer writer) {
        char prev = '\u0000';
        char c = '\u0000';
        boolean first = true;
        int i = 0;
        while (i < len) {
            prev = c;
            c = underscoreString[i];
            if (c != '_') {
                if (first) {
                    first = false;
                    if (capitalizeFirstLetter) {
                        StringTools.writeCharOn(Character.toUpperCase(c), writer);
                    } else {
                        StringTools.writeCharOn(Character.toLowerCase(c), writer);
                    }
                } else if (prev == '_') {
                    StringTools.writeCharOn(Character.toUpperCase(c), writer);
                } else {
                    StringTools.writeCharOn(Character.toLowerCase(c), writer);
                }
            }
            ++i;
        }
    }

    public static char[] convertToCharArray(StringBuffer sb) {
        int len = sb.length();
        char[] result = new char[len];
        sb.getChars(0, len, result, 0);
        return result;
    }

    public static char[] convertToCharArray(StringBuilder sb) {
        int len = sb.length();
        char[] result = new char[len];
        sb.getChars(0, len, result, 0);
        return result;
    }

    private static void writeStringOn(char[] string, Writer writer) {
        try {
            writer.write(string);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void writeStringOn(char[] string, int off, int len, Writer writer) {
        try {
            writer.write(string, off, len);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void writeStringOn(String string, Writer writer) {
        try {
            writer.write(string);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void writeCharOn(char c, Writer writer) {
        try {
            writer.write(c);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private StringTools() {
        throw new UnsupportedOperationException();
    }
}

