/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.model.Model;
import org.eclipse.jpt.utility.internal.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.StateChangeEvent;
import org.eclipse.jpt.utility.internal.model.event.TreeChangeEvent;
import org.eclipse.jpt.utility.internal.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.StateChangeListener;
import org.eclipse.jpt.utility.internal.model.listener.TreeChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModel
implements Model,
Serializable {
    private ChangeSupport changeSupport;

    protected AbstractModel() {
        this.initialize();
    }

    protected void initialize() {
    }

    private synchronized ChangeSupport changeSupport() {
        if (this.changeSupport == null) {
            this.changeSupport = this.buildChangeSupport();
        }
        return this.changeSupport;
    }

    protected ChangeSupport buildChangeSupport() {
        return new ChangeSupport(this);
    }

    @Override
    public synchronized void addStateChangeListener(StateChangeListener listener) {
        this.changeSupport().addStateChangeListener(listener);
    }

    @Override
    public synchronized void removeStateChangeListener(StateChangeListener listener) {
        this.changeSupport().removeStateChangeListener(listener);
    }

    protected final void fireStateChanged() {
        this.changeSupport().fireStateChanged();
    }

    protected final void fireStateChanged(StateChangeEvent event) {
        this.changeSupport().fireStateChanged(event);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport().addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport().addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport().removePropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport().removePropertyChangeListener(propertyName, listener);
    }

    protected final void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport().firePropertyChanged(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChanged(String propertyName, int oldValue, int newValue) {
        this.changeSupport().firePropertyChanged(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChanged(String propertyName, boolean oldValue, boolean newValue) {
        this.changeSupport().firePropertyChanged(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChanged(String propertyName, Object newValue) {
        this.changeSupport().firePropertyChanged(propertyName, null, newValue);
    }

    protected final void firePropertyChanged(PropertyChangeEvent event) {
        this.changeSupport().firePropertyChanged(event);
    }

    @Override
    public synchronized void addCollectionChangeListener(CollectionChangeListener listener) {
        this.changeSupport().addCollectionChangeListener(listener);
    }

    @Override
    public synchronized void addCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        this.changeSupport().addCollectionChangeListener(collectionName, listener);
    }

    @Override
    public synchronized void removeCollectionChangeListener(CollectionChangeListener listener) {
        this.changeSupport().removeCollectionChangeListener(listener);
    }

    @Override
    public synchronized void removeCollectionChangeListener(String collectionName, CollectionChangeListener listener) {
        this.changeSupport().removeCollectionChangeListener(collectionName, listener);
    }

    protected final void fireItemAdded(String collectionName, Object addedItem) {
        this.changeSupport().fireItemAdded(collectionName, addedItem);
    }

    protected final void fireItemsAdded(String collectionName, Collection<?> addedItems) {
        this.changeSupport().fireItemsAdded(collectionName, addedItems);
    }

    protected final void fireItemsAdded(CollectionChangeEvent event) {
        this.changeSupport().fireItemsAdded(event);
    }

    protected final void fireItemRemoved(String collectionName, Object removedItem) {
        this.changeSupport().fireItemRemoved(collectionName, removedItem);
    }

    protected final void fireItemsRemoved(String collectionName, Collection<?> removedItems) {
        this.changeSupport().fireItemsRemoved(collectionName, removedItems);
    }

    protected final void fireItemsRemoved(CollectionChangeEvent event) {
        this.changeSupport().fireItemsRemoved(event);
    }

    protected final void fireCollectionCleared(String collectionName) {
        this.changeSupport().fireCollectionCleared(collectionName);
    }

    protected final void fireCollectionCleared(CollectionChangeEvent event) {
        this.changeSupport().fireCollectionCleared(event);
    }

    protected final void fireCollectionChanged(String collectionName) {
        this.changeSupport().fireCollectionChanged(collectionName);
    }

    protected final void fireCollectionChanged(CollectionChangeEvent event) {
        this.changeSupport().fireCollectionChanged(event);
    }

    protected <E> boolean addItemToCollection(E item, Collection<E> collection, String collectionName) {
        if (collection.add(item)) {
            this.fireItemAdded(collectionName, item);
            return true;
        }
        return false;
    }

    protected <E> boolean addItemsToCollection(Iterable<? extends E> items, Collection<E> collection, String collectionName) {
        return this.addItemsToCollection(items.iterator(), collection, collectionName);
    }

    protected <E> boolean addItemsToCollection(Iterator<? extends E> items, Collection<E> collection, String collectionName) {
        ArrayList<E> addedItems = null;
        while (items.hasNext()) {
            E item = items.next();
            if (!collection.add(item)) continue;
            if (addedItems == null) {
                addedItems = new ArrayList<E>();
            }
            addedItems.add(item);
        }
        if (addedItems != null) {
            this.fireItemsAdded(collectionName, addedItems);
            return true;
        }
        return false;
    }

    protected boolean removeItemFromCollection(Object item, Collection<?> collection, String collectionName) {
        if (collection.remove(item)) {
            this.fireItemRemoved(collectionName, item);
            return true;
        }
        return false;
    }

    protected boolean removeItemsFromCollection(Iterable<?> items, Collection<?> collection, String collectionName) {
        return this.removeItemsFromCollection(items.iterator(), collection, collectionName);
    }

    protected boolean removeItemsFromCollection(Iterator<?> items, Collection<?> collection, String collectionName) {
        Collection<?> items2 = CollectionTools.collection(items);
        items2.retainAll(collection);
        boolean changed = collection.removeAll(items2);
        if (!items2.isEmpty()) {
            this.fireItemsRemoved(collectionName, items2);
        }
        return changed;
    }

    protected boolean retainItemsInCollection(Iterable<?> items, Collection<?> collection, String collectionName) {
        return this.retainItemsInCollection(items.iterator(), collection, collectionName);
    }

    protected boolean retainItemsInCollection(Iterator<?> items, Collection<?> collection, String collectionName) {
        Collection<?> items2 = CollectionTools.collection(items);
        Collection<?> removedItems = CollectionTools.collection(collection);
        removedItems.removeAll(items2);
        boolean changed = collection.retainAll(items2);
        if (!removedItems.isEmpty()) {
            this.fireItemsRemoved(collectionName, removedItems);
        }
        return changed;
    }

    protected boolean clearCollection(Collection<?> collection, String collectionName) {
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        this.fireCollectionCleared(collectionName);
        return true;
    }

    protected <E> boolean synchronizeCollection(Collection<E> newCollection, Collection<E> collection, String collectionName) {
        if (newCollection.isEmpty()) {
            return this.clearCollection(collection, collectionName);
        }
        if (collection.isEmpty()) {
            return this.addItemsToCollection(newCollection, collection, collectionName);
        }
        boolean changed = false;
        HashBag<E> removeItems = new HashBag<E>(collection);
        removeItems.removeAll(newCollection);
        changed |= this.removeItemsFromCollection(removeItems, collection, collectionName);
        HashBag<E> addItems = new HashBag<E>(newCollection);
        addItems.removeAll(collection);
        return changed |= this.addItemsToCollection(addItems, collection, collectionName);
    }

    protected <E> boolean synchronizeCollection(Iterator<E> newItems, Collection<E> collection, String collectionName) {
        return this.synchronizeCollection(CollectionTools.collection(newItems), collection, collectionName);
    }

    @Override
    public synchronized void addListChangeListener(ListChangeListener listener) {
        this.changeSupport().addListChangeListener(listener);
    }

    @Override
    public synchronized void addListChangeListener(String listName, ListChangeListener listener) {
        this.changeSupport().addListChangeListener(listName, listener);
    }

    @Override
    public synchronized void removeListChangeListener(ListChangeListener listener) {
        this.changeSupport().removeListChangeListener(listener);
    }

    @Override
    public synchronized void removeListChangeListener(String listName, ListChangeListener listener) {
        this.changeSupport().removeListChangeListener(listName, listener);
    }

    protected final void fireItemAdded(String listName, int index, Object addedItem) {
        this.changeSupport().fireItemAdded(listName, index, addedItem);
    }

    protected final void fireItemsAdded(String listName, int index, List<?> addedItems) {
        this.changeSupport().fireItemsAdded(listName, index, addedItems);
    }

    protected final void fireItemsAdded(ListChangeEvent event) {
        this.changeSupport().fireItemsAdded(event);
    }

    protected final void fireItemRemoved(String listName, int index, Object removedItem) {
        this.changeSupport().fireItemRemoved(listName, index, removedItem);
    }

    protected final void fireItemsRemoved(String listName, int index, List<?> removedItems) {
        this.changeSupport().fireItemsRemoved(listName, index, removedItems);
    }

    protected final void fireItemsRemoved(ListChangeEvent event) {
        this.changeSupport().fireItemsRemoved(event);
    }

    protected final void fireItemReplaced(String listName, int index, Object newItem, Object replacedItem) {
        this.changeSupport().fireItemReplaced(listName, index, newItem, replacedItem);
    }

    protected final <E> void fireItemsReplaced(String listName, int index, List<? extends E> newItems, List<E> replacedItems) {
        this.changeSupport().fireItemsReplaced(listName, index, newItems, replacedItems);
    }

    protected final void fireItemsReplaced(ListChangeEvent event) {
        this.changeSupport().fireItemsReplaced(event);
    }

    protected final void fireItemMoved(String listName, int targetIndex, int sourceIndex) {
        this.changeSupport().fireItemMoved(listName, targetIndex, sourceIndex);
    }

    protected final <E> void fireItemsMoved(String listName, int targetIndex, int sourceIndex, int length) {
        this.changeSupport().fireItemsMoved(listName, targetIndex, sourceIndex, length);
    }

    protected final void fireItemsMoved(ListChangeEvent event) {
        this.changeSupport().fireItemsMoved(event);
    }

    protected final void fireListCleared(String listName) {
        this.changeSupport().fireListCleared(listName);
    }

    protected final void fireListCleared(ListChangeEvent event) {
        this.changeSupport().fireListCleared(event);
    }

    protected final void fireListChanged(String listName) {
        this.changeSupport().fireListChanged(listName);
    }

    protected final void fireListChanged(ListChangeEvent event) {
        this.changeSupport().fireListChanged(event);
    }

    protected <E> void addItemToList(int index, E item, List<E> list, String listName) {
        list.add(index, item);
        this.fireItemAdded(listName, index, item);
    }

    protected <E> boolean addItemToList(E item, List<E> list, String listName) {
        if (list.add(item)) {
            this.fireItemAdded(listName, list.size() - 1, item);
            return true;
        }
        return false;
    }

    protected <E> boolean addItemsToList(int index, Iterable<? extends E> items, List<E> list, String listName) {
        return this.addItemsToList(index, items.iterator(), list, listName);
    }

    protected <E> boolean addItemsToList(int index, Iterator<? extends E> items, List<E> list, String listName) {
        List<? extends E> items2 = CollectionTools.list(items);
        if (list.addAll(index, items2)) {
            this.fireItemsAdded(listName, index, items2);
            return true;
        }
        return false;
    }

    protected <E> boolean addItemsToList(Iterable<? extends E> items, List<E> list, String listName) {
        return this.addItemsToList(items.iterator(), list, listName);
    }

    protected <E> boolean addItemsToList(Iterator<? extends E> items, List<E> list, String listName) {
        List<? extends E> items2 = CollectionTools.list(items);
        int index = list.size();
        if (list.addAll(items2)) {
            this.fireItemsAdded(listName, index, items2);
            return true;
        }
        return false;
    }

    protected <E> E removeItemFromList(int index, List<E> list, String listName) {
        E item = list.remove(index);
        this.fireItemRemoved(listName, index, item);
        return item;
    }

    protected boolean removeItemFromList(Object item, List<?> list, String listName) {
        int index = list.indexOf(item);
        if (index == -1) {
            return false;
        }
        list.remove(index);
        this.fireItemRemoved(listName, index, item);
        return true;
    }

    protected <E> List<E> removeItemsFromList(int index, int length, List<E> list, String listName) {
        List<E> subList = list.subList(index, index + length);
        ArrayList<E> removedItems = new ArrayList<E>(subList);
        subList.clear();
        this.fireItemsRemoved(listName, index, removedItems);
        return removedItems;
    }

    protected boolean removeItemsFromList(Iterable<?> items, List<?> list, String listName) {
        return this.removeItemsFromList(items.iterator(), list, listName);
    }

    protected boolean removeItemsFromList(Iterator<?> items, List<?> list, String listName) {
        boolean changed = false;
        while (items.hasNext()) {
            changed |= this.removeItemFromList(items.next(), list, listName);
        }
        return changed;
    }

    protected boolean retainItemsInList(Iterable<?> items, List<?> list, String listName) {
        return this.retainItemsInList(items.iterator(), list, listName);
    }

    protected boolean retainItemsInList(Iterator<?> items, List<?> list, String listName) {
        Collection<?> items2 = CollectionTools.collection(items);
        Collection<?> removedItems = CollectionTools.collection(list);
        removedItems.removeAll(items2);
        return this.removeItemsFromList(removedItems, list, listName);
    }

    protected <E> E setItemInList(int index, E item, List<E> list, String listName) {
        E replacedItem = list.set(index, item);
        this.fireItemReplaced(listName, index, item, replacedItem);
        return replacedItem;
    }

    protected <E> E replaceItemInList(E oldItem, E newItem, List<E> list, String listName) {
        return this.setItemInList(list.indexOf(oldItem), newItem, list, listName);
    }

    protected <E> List<E> setItemsInList(int index, List<? extends E> items, List<E> list, String listName) {
        List<E> subList = list.subList(index, index + items.size());
        ArrayList<E> replacedItems = new ArrayList<E>(subList);
        int i = 0;
        while (i < items.size()) {
            subList.set(i, items.get(i));
            ++i;
        }
        this.fireItemsReplaced(listName, index, items, replacedItems);
        return replacedItems;
    }

    protected <E> void moveItemsInList(int targetIndex, int sourceIndex, int length, List<E> list, String listName) {
        CollectionTools.move(list, targetIndex, sourceIndex, length);
        this.fireItemsMoved(listName, targetIndex, sourceIndex, length);
    }

    protected <E> void moveItemInList(int targetIndex, int sourceIndex, List<E> list, String listName) {
        CollectionTools.move(list, targetIndex, sourceIndex);
        this.fireItemMoved(listName, targetIndex, sourceIndex);
    }

    protected boolean clearList(List<?> list, String listName) {
        if (list.isEmpty()) {
            return false;
        }
        list.clear();
        this.fireListCleared(listName);
        return true;
    }

    @Override
    public synchronized void addTreeChangeListener(TreeChangeListener listener) {
        this.changeSupport().addTreeChangeListener(listener);
    }

    @Override
    public synchronized void addTreeChangeListener(String treeName, TreeChangeListener listener) {
        this.changeSupport().addTreeChangeListener(treeName, listener);
    }

    @Override
    public synchronized void removeTreeChangeListener(TreeChangeListener listener) {
        this.changeSupport().removeTreeChangeListener(listener);
    }

    @Override
    public synchronized void removeTreeChangeListener(String treeName, TreeChangeListener listener) {
        this.changeSupport().removeTreeChangeListener(treeName, listener);
    }

    protected final void fireNodeAdded(String treeName, Object[] path) {
        this.changeSupport().fireNodeAdded(treeName, path);
    }

    protected final void fireNodeAdded(TreeChangeEvent event) {
        this.changeSupport().fireNodeAdded(event);
    }

    protected final void fireNodeRemoved(String treeName, Object[] path) {
        this.changeSupport().fireNodeRemoved(treeName, path);
    }

    protected final void fireNodeRemoved(TreeChangeEvent event) {
        this.changeSupport().fireNodeRemoved(event);
    }

    protected final void fireTreeCleared(String treeName) {
        this.changeSupport().fireTreeCleared(treeName);
    }

    protected final void fireTreeCleared(TreeChangeEvent event) {
        this.changeSupport().fireTreeCleared(event);
    }

    protected final void fireTreeChanged(String treeName) {
        this.changeSupport().fireTreeChanged(treeName);
    }

    protected final void fireTreeChanged(String treeName, Object[] path) {
        this.changeSupport().fireTreeChanged(treeName, path);
    }

    protected final void fireTreeChanged(TreeChangeEvent event) {
        this.changeSupport().fireTreeChanged(event);
    }

    public boolean hasAnyStateChangeListeners() {
        return this.changeSupport().hasAnyStateChangeListeners();
    }

    public boolean hasNoStateChangeListeners() {
        return !this.hasAnyStateChangeListeners();
    }

    public boolean hasAnyPropertyChangeListeners(String propertyName) {
        return this.changeSupport().hasAnyPropertyChangeListeners(propertyName);
    }

    public boolean hasNoPropertyChangeListeners(String propertyName) {
        return !this.hasAnyPropertyChangeListeners(propertyName);
    }

    public boolean hasAnyCollectionChangeListeners(String collectionName) {
        return this.changeSupport().hasAnyCollectionChangeListeners(collectionName);
    }

    public boolean hasNoCollectionChangeListeners(String collectionName) {
        return !this.hasAnyCollectionChangeListeners(collectionName);
    }

    public boolean hasAnyListChangeListeners(String listName) {
        return this.changeSupport().hasAnyListChangeListeners(listName);
    }

    public boolean hasNoListChangeListeners(String listName) {
        return !this.hasAnyListChangeListeners(listName);
    }

    public boolean hasAnyTreeChangeListeners(String treeName) {
        return this.changeSupport().hasAnyTreeChangeListeners(treeName);
    }

    public boolean hasNoTreeChangeListeners(String treeName) {
        return !this.hasAnyTreeChangeListeners(treeName);
    }

    protected final boolean valuesAreEqual(Object value1, Object value2) {
        return this.changeSupport().valuesAreEqual(value1, value2);
    }

    protected final boolean attributeValueHasNotChanged(Object oldValue, Object newValue) {
        return this.valuesAreEqual(oldValue, newValue);
    }

    protected final boolean valuesAreDifferent(Object value1, Object value2) {
        return this.changeSupport().valuesAreDifferent(value1, value2);
    }

    protected final boolean attributeValueHasChanged(Object oldValue, Object newValue) {
        return this.valuesAreDifferent(oldValue, newValue);
    }

    protected AbstractModel clone() throws CloneNotSupportedException {
        AbstractModel clone = (AbstractModel)super.clone();
        clone.postClone();
        return clone;
    }

    protected void postClone() {
        this.changeSupport = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        StringTools.buildSimpleToStringOn((Object)this, sb);
        sb.append(" (");
        this.toString(sb);
        sb.append(')');
        return sb.toString();
    }

    public void toString(StringBuilder sb) {
    }
}

